/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.HashMap;
import java.util.Map;

public class ToUrlExpression
extends Expression {
    private ToUrlLink link;
    private ToUrlLink linkName;
    private String responseFormat;
    private String mimeType;

    public ToUrlExpression(ToUrlLink link, ToUrlLink linkName, String responseFormat, String mimeType) {
        super(1);
        this.link = link;
        this.linkName = linkName;
        this.responseFormat = responseFormat;
        this.mimeType = mimeType;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        this.link.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        if (this.linkName != null) {
            this.linkName.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.dataType = session.dataspaceStore.schemaManager.getDomainOrDistinctType("URL", "SYS", true);
        this.link.resolveTypes(session, parent);
        if (this.linkName != null) {
            this.linkName.resolveTypes(session, parent);
        }
    }

    @Override
    public Object getValue(Session session) {
        Object uri = this.link.getValue(session);
        if (this.responseFormat != null) {
            uri = (String)uri + "&responseFormat=" + this.responseFormat;
        }
        if (this.mimeType != null) {
            uri = (String)uri + "&responseMimeType=" + this.mimeType;
        }
        String name = this.linkName != null ? this.linkName.getValue(session) : null;
        return new URL((String)uri, name);
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("toUrl((").append(this.link.getSQL()).append(")");
        if (this.linkName != null) {
            builder.append(",(").append(this.linkName.getSQL()).append(")");
        }
        if (this.responseFormat != null) {
            builder.append(", '").append(this.responseFormat).append("'");
        }
        if (this.mimeType != null) {
            builder.append(", '").append(this.mimeType).append("'");
        }
        builder.append(")");
        return builder.toString();
    }

    public static interface ToUrlLink {
        public HsqlList resolveColumnReferences(Session var1, RangeVariable[] var2, int var3, HsqlList var4, boolean var5);

        public void resolveTypes(Session var1, Expression var2);

        public String getValue(Session var1);

        public String getSQL();
    }

    public static class ToUrlLinkExpression
    implements ToUrlLink {
        private Expression expression;

        public ToUrlLinkExpression(Expression expression) {
            this.expression = expression;
        }

        @Override
        public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
            this.expression.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
            return unresolvedSet;
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            this.expression.resolveTypes(session, parent);
            this.expression.setDataType(session, Type.SQL_VARCHAR);
        }

        @Override
        public String getValue(Session session) {
            return (String)Type.SQL_VARCHAR.convertToDefaultType(session, this.expression.getValue(session));
        }

        @Override
        public String getSQL() {
            return this.expression.getSQL();
        }
    }

    public static class ToUrlLinkNameQuerySpecification
    implements ToUrlLink {
        private QuerySpecification nameQuerySpecification;

        public ToUrlLinkNameQuerySpecification(QuerySpecification nameQuerySpecification) {
            this.nameQuerySpecification = nameQuerySpecification;
        }

        @Override
        public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
            this.nameQuerySpecification.setReturningResult();
            this.nameQuerySpecification.resolve(session, rangeVarArray, null);
            if (this.nameQuerySpecification.getMetaData().getColumnCount() != 1) {
                throw new DataspaceException("Inner toUrl link name query result set contains more then 1 column.");
            }
            return unresolvedSet;
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            this.nameQuerySpecification.resolveTypes(session);
        }

        @Override
        public String getValue(Session session) {
            Result r = this.nameQuerySpecification.getResult(session, 0);
            if (r.getNavigator().getSize() != 1) {
                throw new DataspaceException("Inner toUrl link name query result set contains more then 1 row.");
            }
            return (String)Type.SQL_VARCHAR.convertToDefaultType(session, r.getSingleRowData()[0]);
        }

        @Override
        public String getSQL() {
            return this.nameQuerySpecification.getSQL();
        }
    }

    public static class ToUrlLinkQuerySpecification
    implements ToUrlLink {
        private QuerySpecification querySpecification;

        public ToUrlLinkQuerySpecification(QuerySpecification querySpecification) {
            this.querySpecification = querySpecification;
        }

        @Override
        public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
            this.querySpecification.setReturningResult();
            this.querySpecification.resolve(session, rangeVarArray, null);
            return unresolvedSet;
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getValue(Session session) {
            Map<Expression, Expression> querySpecificationReplaceMap = this.resolveExpressions(session, this.querySpecification);
            try {
                DataspaceComponent component = session.dataspaceStore.lookup(session.currentDataspace.getNameString());
                String dataspaceName = component.getType() + "." + component.getName();
                String string = "/ds/" + dataspaceName + "/dsql?q=" + HTTPUtils.encodeString(this.querySpecification.getSQL());
                return string;
            }
            finally {
                this.unresolveExpressions(this.querySpecification, querySpecificationReplaceMap);
            }
        }

        protected Map<Expression, Expression> resolveExpressions(Session session, QuerySpecification query) {
            HashMap<Expression, Expression> replaceMap = new HashMap<Expression, Expression>();
            if (query.unresolvedExpressions != null) {
                for (int i = 0; i < query.unresolvedExpressions.size(); ++i) {
                    Expression expression = (Expression)query.unresolvedExpressions.get(i);
                    if (replaceMap.containsKey(expression)) continue;
                    Expression valueExpression = new Expression(1);
                    valueExpression.setDataType(session, expression.getDataType());
                    valueExpression.setAsConstantValue(expression.getValue(session));
                    valueExpression.alias = expression.alias;
                    replaceMap.put(expression, valueExpression);
                }
                query.replaceExpressions(replaceMap);
            }
            return replaceMap;
        }

        protected void unresolveExpressions(QuerySpecification query, Map<Expression, Expression> replaceMap) {
            HashMap<Expression, Expression> reverseMap = new HashMap<Expression, Expression>();
            for (Map.Entry<Expression, Expression> entry : replaceMap.entrySet()) {
                reverseMap.put(entry.getValue(), entry.getKey());
            }
            query.replaceExpressions(reverseMap);
        }

        @Override
        public String getSQL() {
            return this.querySpecification.getSQL();
        }
    }
}

