/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.table.DataFrame;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.sdo.rowset.RowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class ToDataFrameExpression
extends Expression {
    private final QuerySpecification querySpecification;
    private Expression expression;

    public ToDataFrameExpression(QuerySpecification querySpecification, Expression expression) {
        super(1);
        this.querySpecification = querySpecification;
        this.expression = expression;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.querySpecification != null) {
            this.querySpecification.setReturningResult();
            this.querySpecification.resolve(session, rangeVarArray, null);
        } else {
            this.expression.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.dataType = session.dataspaceStore.schemaManager.getDomainOrDistinctType("DataFrame", "SYS", true);
        if (this.querySpecification != null) {
            this.querySpecification.resolveTypes(session);
        } else {
            this.expression.resolveTypes(session, parent);
        }
    }

    @Override
    public Object getValue(Session session) {
        if (this.querySpecification != null) {
            Result r = this.querySpecification.getResult(session, 0);
            RowSetNavigator navigator = r.getNavigator();
            DataFrame dataFrame = new DataFrame("", navigator.getSize(), r.metaData.getColumnCount());
            int i = 0;
            while (navigator.hasNext()) {
                Object[] current = navigator.getNext();
                for (int j = 0; j < current.length; ++j) {
                    double value = 0.0;
                    if (current[j] instanceof Number) {
                        value = ((Number)current[j]).doubleValue();
                    } else if (current[j] instanceof String) {
                        value = Double.valueOf((String)current[j]);
                    } else {
                        throw new DataspaceException("Failed to convert value '" + String.valueOf(current[j]) + "' to double.");
                    }
                    dataFrame.set(i, j, value);
                }
                ++i;
            }
            dataFrame.setColumnNames(new ArrayList<String>(Arrays.asList(r.metaData.columnLabels)));
            return dataFrame;
        }
        Object value = this.expression.getValue(session);
        if ((value = OtherTypeWrapper.unwrap(value)) instanceof RowSet) {
            try {
                return ((RowSet)value).toDataFrame();
            }
            catch (SQLException exception) {
                throw new DataspaceException(exception);
            }
        }
        if (value instanceof Snapshot) {
            return ((Snapshot)value).toDataFrame();
        }
        throw new DataspaceException("Invalid value passed to toDataFrame function. Should be RowSet or Snapshot or SELECT expression.");
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("toDataFrame((").append(this.querySpecification != null ? this.querySpecification.getSQL() : this.expression.getSQL()).append(")");
        return builder.toString();
    }
}

