/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.navigator.RowSetNavigatorDataTable;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import java.util.Comparator;

public class SubQuery
implements Comparator {
    public int level;
    private boolean isResolved;
    private boolean isCorrelated;
    private boolean isExistsPredicate;
    private boolean isRecursive;
    private boolean uniqueRows;
    private boolean fullOrder;
    public QueryExpression queryExpression;
    DataspaceStore database;
    private TableDerived table;
    View view;
    public View parentView;
    public String sql;
    public Expression dataExpression;
    boolean isDataExpression;
    SubQuery recursiveSubQuery;
    NameManager.SimpleName[] columnNames;
    int parsePosition;
    public static final SubQuery[] emptySubqueryArray = new SubQuery[0];

    public SubQuery(DataspaceStore database, int level, QueryExpression queryExpression, int mode) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        switch (mode) {
            case 55: {
                this.isExistsPredicate = true;
                break;
            }
            case 54: {
                this.uniqueRows = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
                break;
            }
            case 57: {
                this.fullOrder = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
            }
        }
    }

    public SubQuery(DataspaceStore database, int level, QueryExpression queryExpression, SubQuery sq) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        this.isRecursive = true;
        this.recursiveSubQuery = sq;
    }

    public SubQuery(DataspaceStore database, int level, Expression dataExpression, int mode) {
        this.level = level;
        this.database = database;
        this.dataExpression = dataExpression;
        dataExpression.subQuery = this;
        this.isDataExpression = true;
        switch (mode) {
            case 54: {
                this.uniqueRows = true;
            }
        }
    }

    public SubQuery(DataspaceStore database, int level, QueryExpression queryExpression, View view) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        this.view = view;
    }

    public void collectViewReferences(Set set) {
        if (this.queryExpression != null) {
            OrderedHashSet tmp = new OrderedHashSet();
            this.queryExpression.collectObjectNames(tmp);
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof NameManager.ObjectName) || ((NameManager.ObjectName)o).type != 5) continue;
                set.add(o);
            }
        }
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public void setCorrelated() {
        this.isCorrelated = true;
    }

    public void setUniqueRows() {
        this.uniqueRows = true;
    }

    public TableDerived getTable() {
        return this.table;
    }

    public void createTable() {
        NameManager.ObjectName name = this.database.nameManager.getSubqueryTableName();
        this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
    }

    public void prepareTable(Session session, NameManager.ObjectName name, NameManager.ObjectName[] columns) {
        if (this.isResolved) {
            return;
        }
        if (this.table == null) {
            this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
        }
        this.table.columnCount = this.queryExpression.getColumnCount();
        this.table.columnList = this.queryExpression.getColumns();
        if (columns != null) {
            if (columns.length != this.table.columnList.size()) {
                throw Error.error(5593);
            }
            for (int i = 0; i < this.table.columnCount; ++i) {
                this.table.columnList.setKey(i, columns[i].name);
                ColumnSchema col = (ColumnSchema)this.table.columnList.get(i);
                col.getObjectName().rename(columns[i]);
            }
        }
        TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
        this.isResolved = true;
    }

    public void prepareTable(Session session) {
        if (this.isResolved) {
            return;
        }
        if (this.view == null) {
            if (this.table == null) {
                NameManager.ObjectName name = this.database.nameManager.getSubqueryTableName();
                this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
            }
            if (this.isDataExpression) {
                TableUtil.addAutoColumns(this.table, this.dataExpression.nodeDataTypes);
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            } else {
                this.table.columnList = this.queryExpression.getColumns();
                this.table.columnCount = this.queryExpression.getColumnCount();
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            }
        } else {
            this.table = new TableDerived(this.database, this.view.getObjectName(), 9, this.queryExpression, this);
            this.table.columnList = this.view.columnList;
            this.table.columnCount = this.table.columnList.size();
            this.table.createPrimaryKey();
        }
        this.isResolved = true;
    }

    public void setColumnNames(NameManager.SimpleName[] names) {
        this.columnNames = names;
    }

    public NameManager.SimpleName[] getColumnNames() {
        return this.columnNames;
    }

    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated) {
            this.materialise(session);
        }
    }

    public void materialise(Session session) {
        if (this.isDataExpression) {
            PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
            this.dataExpression.insertValuesIntoSubqueryTable(session, store);
            return;
        }
        Result result = this.isRecursive ? this.queryExpression.getResultRecursive(session, this.recursiveSubQuery.table) : this.queryExpression.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            RowSetNavigatorData navigator = (RowSetNavigatorData)result.getNavigator();
            navigator.removeDuplicates(session);
        }
        PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
        this.table.insertResult(session, store, result);
        result.getNavigator().release();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        RowSetNavigatorDataTable navigator = new RowSetNavigatorDataTable(session, this.table);
        boolean result = ((RowSetNavigatorData)navigator).hasUniqueNotNullRows(session);
        return result;
    }

    public Object[] getValues(Session session) {
        RowIterator it = this.table.rowIterator(session);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (it.hasNext()) {
                throw Error.error(3201, new Object[]{this.sql});
            }
            return row.getData();
        }
        return new Object[this.table.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] data = this.getValues(session);
        return data[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable navigator = new RowSetNavigatorDataTable(session, this.table);
        return navigator;
    }

    public int compare(Object a, Object b) {
        SubQuery sqa = (SubQuery)a;
        SubQuery sqb = (SubQuery)b;
        if (sqa.parentView == null && sqb.parentView == null) {
            return sqb.level - sqa.level;
        }
        if (sqa.parentView != null && sqb.parentView != null) {
            int diff;
            int ia = this.database.schemaManager.getTableIndex(sqa.parentView);
            int ib = this.database.schemaManager.getTableIndex(sqb.parentView);
            if (ia == -1) {
                ia = this.database.schemaManager.getTables(sqa.parentView.getSchemaName().name).size();
            }
            if (ib == -1) {
                ib = this.database.schemaManager.getTables(sqb.parentView.getSchemaName().name).size();
            }
            return (diff = ia - ib) == 0 ? sqb.level - sqa.level : diff;
        }
        return sqa.parentView == null ? 1 : -1;
    }
}

