/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionOrderBy;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.Type;

public final class SortAndSlice {
    public static final SortAndSlice noSort = new SortAndSlice();
    static final int[] defaultLimits = new int[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    public Collation[] collations;
    boolean sortUnion;
    public HsqlArrayList exprList = new HsqlArrayList();
    ExpressionOp limitCondition;
    int columnCount;
    boolean hasNullsLast;
    boolean strictLimit;
    boolean zeroLimit;
    public boolean usingIndex;
    boolean allDescending;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    public Index index;
    public Table primaryTable;
    public Index primaryTableIndex;
    public int[] colIndexes;
    public boolean isGenerated;

    public HsqlArrayList getExpressionList() {
        return this.exprList;
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression e) {
        this.exprList.add(e);
    }

    public void addLimitCondition(ExpressionOp expression) {
        this.limitCondition = expression;
    }

    public void setStrictLimit() {
        this.strictLimit = true;
    }

    public void setZeroLimit() {
        this.zeroLimit = true;
    }

    public void setUsingIndex() {
        this.usingIndex = true;
    }

    public void prepareSingleColumn(int colIndex) {
        this.sortOrder = new int[1];
        this.sortDescending = new boolean[1];
        this.sortNullsLast = new boolean[1];
        this.sortOrder[0] = colIndex;
    }

    public void prepare(int degree) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount + degree];
        this.sortDescending = new boolean[this.columnCount + degree];
        this.sortNullsLast = new boolean[this.columnCount + degree];
        ArrayUtil.fillSequence(this.sortOrder);
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            this.sortDescending[i] = sort.isDescending();
            this.sortNullsLast[i] = sort.isNullsLast();
            if (sort != null && sort.getColumn() != null && sort.getColumn().isPrimaryKey() || sort.nodes != null && sort.nodes.length == 1 && sort.nodes[0].getColumn() != null && sort.nodes[0].getColumn().isPrimaryKey()) {
                this.sortNullsLast[i] = false;
            }
            this.hasNullsLast |= this.sortNullsLast[i];
        }
    }

    public void prepare(QuerySpecification select) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = sort.getLeftNode().queryTableColumnIndex == -1 ? select.indexStartOrderBy + i : sort.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = sort.isDescending();
            this.sortNullsLast[i] = sort.isNullsLast();
            if (sort != null && sort.getColumn() != null && sort.getColumn().isPrimaryKey() || sort.nodes != null && sort.nodes.length == 1 && sort.nodes[0].getColumn() != null && sort.nodes[0].getColumn().isPrimaryKey()) {
                this.sortNullsLast[i] = false;
            }
            this.hasNullsLast |= this.sortNullsLast[i];
            if (sort.collation == null) continue;
            if (this.collations == null) {
                this.collations = new Collation[this.columnCount];
            }
            this.collations[i] = sort.collation;
        }
    }

    void setSortIndex(QuerySpecification select) {
        int i;
        if (this.isGenerated) {
            return;
        }
        for (i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            Type dataType = sort.getLeftNode().getDataType();
            if (!dataType.isArrayType() && !dataType.isLobType()) continue;
            throw Error.error(5534);
        }
        if (select.isDistinctSelect || select.isGrouped || select.isAggregated) {
            return;
        }
        if (this.columnCount == 0) {
            if (this.limitCondition == null) {
                return;
            }
            this.skipFullResult = true;
            return;
        }
        if (select == null || this.hasNullsLast) {
            return;
        }
        if (this.collations != null) {
            return;
        }
        this.colIndexes = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            Expression e = ((Expression)this.exprList.get(i)).getLeftNode();
            if (e.getType() != 2) {
                return;
            }
            if (((ExpressionColumn)e).getRangeVariable() != select.rangeVariables[0]) {
                return;
            }
            this.colIndexes[i] = e.columnIndex;
        }
        int count = ArrayUtil.countTrueElements(this.sortDescending);
        boolean bl = this.allDescending = count == this.columnCount;
        if (!this.allDescending && count > 0) {
            return;
        }
        this.primaryTable = select.rangeVariables[0].getTable();
        this.primaryTableIndex = this.primaryTable.getFullIndexForColumns(this.colIndexes);
    }

    void setSortRange(QuerySpecification select) {
        if (this.primaryTableIndex == null) {
            return;
        }
        Index rangeIndex = select.rangeVariables[0].getSortIndex();
        if (rangeIndex == null) {
            return;
        }
        if (this.primaryTable != select.rangeVariables[0].rangeTable) {
            return;
        }
        if (rangeIndex == this.primaryTableIndex) {
            boolean reversed;
            if (this.allDescending && !(reversed = select.rangeVariables[0].reverseOrder())) {
                return;
            }
            this.skipSort = true;
            this.skipFullResult = true;
        } else if (!select.rangeVariables[0].joinConditions[0].hasIndexCondition() && select.rangeVariables[0].setSortIndex(this.primaryTableIndex, this.allDescending)) {
            this.skipSort = true;
            this.skipFullResult = true;
        }
    }

    public boolean prepareSpecial(Session session, QuerySpecification select) {
        Expression e = select.exprColumns[select.indexStartAggregates];
        int opType = e.getType();
        if ((e = e.getLeftNode()).getType() != 2) {
            return false;
        }
        if (((ExpressionColumn)e).getRangeVariable() != select.rangeVariables[0]) {
            return false;
        }
        Index rangeIndex = select.rangeVariables[0].getSortIndex();
        if (rangeIndex == null) {
            return false;
        }
        if (select.rangeVariables[0].hasSingleIndexCondition()) {
            int[] colIndexes = rangeIndex.getColumns();
            if (colIndexes[0] != ((ExpressionColumn)e).getColumnIndex()) {
                return false;
            }
            if (opType == 74) {
                select.rangeVariables[0].reverseOrder();
            }
        } else {
            if (select.rangeVariables[0].hasAnyIndexCondition()) {
                return false;
            }
            Table table = select.rangeVariables[0].getTable();
            Index index = table.getIndexForColumn(session, ((ExpressionColumn)e).getColumnIndex());
            if (index == null) {
                return false;
            }
            if (!select.rangeVariables[0].setSortIndex(index, opType == 74)) {
                return false;
            }
        }
        this.columnCount = 1;
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.skipSort = true;
        this.skipFullResult = true;
        return true;
    }

    int[] getLimits(Session session, QueryExpression qe, int maxRows) {
        int skipRows = 0;
        int limitRows = Integer.MAX_VALUE;
        int limitFetch = Integer.MAX_VALUE;
        boolean hasLimits = false;
        if (this.hasLimit()) {
            Integer value = (Integer)this.limitCondition.getLeftNode().getValue(session);
            if (value == null || value < 0) {
                throw Error.error(3453);
            }
            skipRows = value;
            boolean bl = hasLimits = skipRows != 0;
            if (this.limitCondition.getRightNode() != null) {
                value = (Integer)this.limitCondition.getRightNode().getValue(session);
                if (value == null || value < 0 || this.strictLimit && value == 0) {
                    throw Error.error(3452);
                }
                if (value == 0 && !this.zeroLimit) {
                    limitRows = Integer.MAX_VALUE;
                } else {
                    limitRows = value;
                    hasLimits = true;
                }
            }
        }
        if (maxRows != 0) {
            if (maxRows < limitRows) {
                limitRows = maxRows;
            }
            hasLimits = true;
        }
        boolean simpleLimit = false;
        if (qe instanceof QuerySpecification) {
            QuerySpecification qs = (QuerySpecification)qe;
            if (!qs.isDistinctSelect && !qs.isGrouped) {
                simpleLimit = true;
            }
        }
        if (hasLimits) {
            if (!(!simpleLimit || this.hasOrder() && !this.skipSort || this.hasLimit() && !this.skipFullResult || limitFetch - skipRows <= limitRows)) {
                limitFetch = skipRows + limitRows;
            }
            return new int[]{skipRows, limitRows, limitFetch};
        }
        return defaultLimits;
    }

    public void setIndex(Session session, TableBase table) {
        this.index = this.getNewIndex(session, table);
    }

    public Index getNewIndex(Session session, TableBase table) {
        if (this.hasOrder()) {
            Index orderIndex = table.createAndAddIndexStructure(null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false, null);
            if (this.collations != null) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.collations[i] == null) continue;
                    Type type = orderIndex.getColumnTypes()[i];
                    orderIndex.getColumnTypes()[i] = type = Type.getType(type.typeCode, type.getCharacterSet(), this.collations[i], type.precision, type.scale);
                }
            }
            return orderIndex;
        }
        return null;
    }
}

