/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.collection.tspace.table.SnapshotCollection;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.session.Session;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class SnapshotCallExpression
extends Expression {
    private final Expression expression;
    private final ExpressionValue tableValue;
    private SnapshotCollection snapshotCollection;
    private Collection<SnapshotCollection> dependedSnapshotCollection;
    private boolean readOnlyOperations = true;

    public SnapshotCallExpression(Expression expression, ExpressionValue tableValue, SnapshotCollection snapshotCollection, Collection<SnapshotCollection> dependedSnapshotCollection) {
        super(1);
        String methodName;
        this.expression = expression;
        this.tableValue = tableValue;
        this.snapshotCollection = snapshotCollection;
        this.dependedSnapshotCollection = new HashSet<SnapshotCollection>(dependedSnapshotCollection);
        this.dependedSnapshotCollection.remove(this.snapshotCollection);
        this.dataType = expression.dataType;
        this.metaResultObject = expression.metaResultObject;
        String string = methodName = expression instanceof ExpressionOp ? ((ExpressionOp)expression).methodName : null;
        if ("insert".equalsIgnoreCase(methodName) || "deleteWhere".equals(methodName) || "clear".equals(methodName) || "truncate".equals(methodName)) {
            this.readOnlyOperations = false;
        }
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        return this.expression.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.tableValue.resolveTypes(session, parent);
        this.expression.resolveTypes(session, parent);
        this.dataType = this.expression.getDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Session session) {
        PersistentStore store = this.snapshotCollection.getBaseTable().getRowStore(session);
        if (this.readOnlyOperations) {
            store.readLock();
        } else {
            store.writeLock();
        }
        try {
            Object object;
            Iterator<SnapshotCollection> iterator = this.dependedSnapshotCollection.iterator();
            while (iterator.hasNext()) {
                iterator.next().getBaseTable().getRowStore(session).readLock();
            }
            try {
                this.tableValue.setAsConstantValue(((SnapshotDataspaceTable)this.snapshotCollection.getBaseTable()).getSTable());
                object = this.expression.getValue(session);
                iterator = this.dependedSnapshotCollection.iterator();
            }
            catch (Throwable throwable) {
                iterator = this.dependedSnapshotCollection.iterator();
                while (iterator.hasNext()) {
                    iterator.next().getBaseTable().getRowStore(session).readUnlock();
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                iterator.next().getBaseTable().getRowStore(session).readUnlock();
            }
            return object;
        }
        finally {
            if (this.readOnlyOperations) {
                store.readUnlock();
            } else {
                store.writeUnlock();
            }
        }
    }

    public SnapshotCollection getSnapshotCollection() {
        return this.snapshotCollection;
    }

    public Collection<SnapshotCollection> getDependedSnapshotCollection() {
        return this.dependedSnapshotCollection;
    }

    @Override
    public String getSQL() {
        return this.expression.getSQL();
    }
}

