/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.DTIType;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SetFunction
implements Serializable {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int typeCode;
    private Type type;
    private ArrayType arrayType;
    private Type returnType;
    private long count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static final BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    long hi;
    long lo;
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunction(int setType, Type type, Type returnType, boolean isDistinct, ArrayType arrayType) {
        this.setType = setType;
        this.type = type;
        this.returnType = returnType;
        if (isDistinct) {
            this.isDistinct = true;
            this.arrayType = arrayType;
            this.distinctValues = new HashSet();
        }
        if (setType == 81 || setType == 79) {
            this.sample = true;
        }
        if (type != null) {
            this.typeCode = type.typeCode;
            if (type.isIntervalType()) {
                this.typeCode = 10;
            }
        }
    }

    void add(Session session, Object item) {
        if (item == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(item)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 71: {
                return;
            }
            case 72: 
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 1117: {
                        this.currentLong += (long)((Number)item).intValue();
                        return;
                    }
                    case 10: {
                        if (item instanceof IntervalSecondData) {
                            this.addLong(((IntervalSecondData)item).getSeconds());
                            this.currentLong += (long)((IntervalSecondData)item).getNanos();
                            if (Math.abs(this.currentLong) >= (long)DTIType.nanoScaleFactors[0]) {
                                this.addLong(this.currentLong / (long)DTIType.nanoScaleFactors[0]);
                                this.currentLong %= (long)DTIType.nanoScaleFactors[0];
                            }
                        } else if (item instanceof IntervalMonthData) {
                            this.addLong(((IntervalMonthData)item).units);
                        }
                        return;
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        this.addLong(((TimestampData)item).getMilliseconds());
                        this.currentLong += (long)((TimestampData)item).getNanos();
                        if (Math.abs(this.currentLong) >= (long)DTIType.nanoScaleFactors[0]) {
                            this.addLong(this.currentLong / (long)DTIType.nanoScaleFactors[0]);
                            this.currentLong %= (long)DTIType.nanoScaleFactors[0];
                        }
                        this.currentDouble = ((TimestampData)item).getZone();
                        return;
                    }
                    case 25: {
                        this.addLong(((Number)item).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)item).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)item : this.currentBigDecimal.add((BigDecimal)item);
                        return;
                    }
                }
                throw Error.error(5563);
            }
            case 73: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (this.type.compare(session, this.currentValue, item) > 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 74: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (this.type.compare(session, this.currentValue, item) < 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 76: {
                if (!(item instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.every = this.every && (Boolean)item != false;
                return;
            }
            case 77: {
                if (!(item instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.some = this.some || (Boolean)item != false;
                return;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.addDataPoint((Number)item);
                return;
            }
            case 98: {
                this.currentValue = item;
                return;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    Object getValue(Session session) {
        if (this.hasNull) {
            session.addWarning(Error.error(1003));
        }
        if (this.setType == 71) {
            if (this.isDistinct && this.type.isCharacterType()) {
                Object[] array = new Object[this.distinctValues.size()];
                this.distinctValues.toArray(array);
                SortAndSlice sort = new SortAndSlice();
                sort.prepareSingleColumn(0);
                this.arrayType.sort(session, array, sort);
                this.count = this.arrayType.deDuplicate(session, array, sort);
            }
            return ValuePool.getLong(this.count);
        }
        if (this.count == 0L) {
            return null;
        }
        switch (this.setType) {
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 1117: {
                        if (this.returnType.scale != 0) {
                            return this.returnType.divide(session, this.currentLong, this.count);
                        }
                        return new Long(this.currentLong / this.count);
                    }
                    case 25: {
                        long value = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(value);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        if (this.returnType.scale == this.type.scale) {
                            return this.currentBigDecimal.divide(new BigDecimal(this.count), 1);
                        }
                        return this.returnType.divide(session, this.currentBigDecimal, this.count);
                    }
                    case 10: {
                        BigInteger bi = this.getLongSum().divide(BigInteger.valueOf(this.count));
                        if (!NumberType.isInLongLimits(bi)) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isDaySecondIntervalType()) {
                            return new IntervalSecondData(bi.longValue(), this.currentLong, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bi.longValue(), (IntervalType)this.type);
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        BigInteger bi = this.getLongSum().divide(BigInteger.valueOf(this.count));
                        if (!NumberType.isInLongLimits(bi)) {
                            throw Error.error(3435);
                        }
                        return new TimestampData(bi.longValue(), (int)this.currentLong, (int)this.currentDouble);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 72: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 1117: {
                        return new Long(this.currentLong);
                    }
                    case 25: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                    case 10: {
                        BigInteger bi = this.getLongSum();
                        if (!NumberType.isInLongLimits(bi)) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isDaySecondIntervalType()) {
                            return new IntervalSecondData(bi.longValue(), this.currentLong, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bi.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 73: 
            case 74: {
                return this.currentValue;
            }
            case 76: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 77: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 78: 
            case 79: {
                return this.getStdDev();
            }
            case 80: 
            case 81: {
                return this.getVariance();
            }
            case 98: {
                return this.currentValue;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    static Type getType(Session session, int setType, Type type) {
        if (setType == 71) {
            return Type.LONG;
        }
        int typeCode = type.isIntervalType() ? 10 : type.typeCode;
        switch (setType) {
            case 75: 
            case 85: {
                switch (typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 25: 
                    case 1117: {
                        int scale = session.dataspaceStore.sqlAvgScale;
                        if (scale <= type.scale) {
                            return type;
                        }
                        int digits = ((NumberType)type).getDecimalPrecision();
                        return NumberType.getNumberType(3, digits + scale, scale);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 91: 
                    case 93: 
                    case 95: {
                        return type;
                    }
                }
                throw Error.error(5563);
            }
            case 72: {
                switch (typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 1117: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(type.typeCode, null, null, type.precision * 2L, type.scale);
                    }
                    case 10: {
                        return IntervalType.newIntervalType(type.typeCode, 9L, type.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 73: 
            case 74: {
                if (type.isArrayType() || type.isLobType()) {
                    throw Error.error(5563);
                }
                return type;
            }
            case 76: 
            case 77: {
                if (!type.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!type.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 98: {
                return type;
            }
            default: {
                throw Error.runtimeError(201, "SetFunction");
            }
        }
        throw Error.error(5563);
    }

    void addLong(long value) {
        if (value != 0L) {
            if (value > 0L) {
                this.hi += value >> 32;
                this.lo += value & 0xFFFFFFFFL;
            } else if (value == Long.MIN_VALUE) {
                this.hi -= 0x80000000L;
            } else {
                long temp = (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hi -= temp >> 32;
                this.lo -= temp & 0xFFFFFFFFL;
            }
        }
    }

    BigInteger getLongSum() {
        BigInteger biglo = BigInteger.valueOf(this.lo);
        BigInteger bighi = BigInteger.valueOf(this.hi);
        BigInteger result = bighi.multiply(multiplier).add(biglo);
        return result;
    }

    private void addDataPoint(Number x) {
        if (x == null) {
            return;
        }
        double xi = x.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = xi;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long nm1 = this.n - 1L;
        double xsi = this.sk - xi * (double)nm1;
        this.vk += xsi * xsi / (double)this.n / (double)nm1;
        this.sk += xi;
    }

    private Number getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(this.vk / (double)(this.n - 1L))) : new Double(this.vk / (double)this.n);
    }

    private Number getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(Math.sqrt(this.vk / (double)(this.n - 1L)))) : new Double(Math.sqrt(this.vk / (double)this.n));
    }
}

