/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractSelectForSemagraphExpression;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SelectForClassifyExpression
extends AbstractSelectForSemagraphExpression {
    private int clustersCount;
    private NameManager.SimpleName clusterAlias;
    private NameManager.SimpleName setAlias;

    public SelectForClassifyExpression(ParserDQL.CompileContext compileContext) {
        super(compileContext);
    }

    public void setClustersCount(int clustersCount) {
        this.clustersCount = clustersCount;
    }

    public int getClustersCount() {
        return this.clustersCount;
    }

    public void setClusterAlias(NameManager.SimpleName clusterAlias) {
        this.clusterAlias = clusterAlias;
    }

    public NameManager.SimpleName getClusterAlias() {
        return this.clusterAlias;
    }

    public void setSetAlias(NameManager.SimpleName setAlias) {
        this.setAlias = setAlias;
    }

    public NameManager.SimpleName getSetAlias() {
        return this.setAlias;
    }

    public void setResultMetaData() {
        String clusterName = "CLUSTER";
        if (this.clusterAlias != null) {
            clusterName = this.clusterAlias.name;
        }
        String setName = "SET";
        if (this.setAlias != null) {
            setName = this.setAlias.name;
        }
        this.resultMetaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_INTEGER, Type.SQL_ARRAY_ALL_TYPES}, new String[]{clusterName, setName});
    }

    @Override
    public Result getResult(Session session, int maxRows) {
        try (ServiceAccessor accessor = this.createServiceAccessor(session);){
            Result result = Result.newDataResult(this.resultMetaData);
            RowSetNavigatorClient navigator = new RowSetNavigatorClient();
            result.setNavigator(navigator);
            RowSet rowSet = SelectForClassifyExpression.execute(this.joinTerms(session), this.clustersCount, accessor);
            while (rowSet.next()) {
                navigator.add(new Object[]{rowSet.getInt(1), Arrays.asList(rowSet.getString(2).split(",")).toArray(new Object[0])});
            }
            Result result2 = result;
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] execute(Session session, List<String> terms, String tableName, int clustersCount) throws FabricComponentAccessorException, SQLException {
        try (ServiceAccessor accessor = SelectForClassifyExpression.createServiceAccessor(session, tableName, session.currentDataspace.name);){
            String request = "classify '" + terms.stream().collect(Collectors.joining(",")) + "' cluster count " + clustersCount + " labels";
            SLResponse response = accessor.invokeLanguageRequest(request);
            SelectForClassifyExpression.checkResponse(response);
            RowSet rowSet = response.getRowSet();
            int[] result = new int[terms.size()];
            int i = 0;
            while (rowSet.next()) {
                result[i++] = rowSet.getInt(1);
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public static RowSet execute(String terms, int clustersCount, ServiceAccessor accessor) throws FabricComponentAccessorException {
        String request = "classify '" + terms + "' cluster count " + clustersCount;
        SLResponse response = accessor.invokeLanguageRequest(request);
        SelectForClassifyExpression.checkResponse(response);
        return response.getRowSet();
    }
}

