/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;

public class ReferenceExpression
extends Expression {
    private final ExpressionOp expression;
    private Object value;
    private boolean valueSet;

    public ReferenceExpression(ExpressionOp expression) {
        super(1);
        this.expression = expression;
        this.dataType = expression.dataType;
        this.metaResultObject = expression.metaResultObject;
        this.expression.addReferenceExpression(this);
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        this.dataType = this.expression.dataType;
        this.metaResultObject = this.expression.metaResultObject;
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.dataType = this.expression.dataType;
        this.metaResultObject = this.expression.metaResultObject;
    }

    @Override
    public Object getValue(Session session) {
        if (!this.valueSet) {
            this.expression.getValue(session);
        }
        if (this.valueSet) {
            try {
                Object object = this.value;
                return object;
            }
            finally {
                this.value = null;
                this.valueSet = false;
            }
        }
        return null;
    }

    @Override
    public String getSQL() {
        return "VALUE_REFERENCE(" + this.expression.getSQL() + ")";
    }

    public void setValue(Object value) {
        this.value = value;
        this.valueSet = true;
    }
}

