/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.session.Session;
import java.util.concurrent.TimeUnit;

public class ReadTakeExpression
extends Expression {
    private BlockingQueueCollection queue;
    private boolean isRead;
    private String whereClause;
    private long timeout;
    private TimeUnit timeUnit;
    private int takeFor;
    private String batchId;
    private boolean isLast;

    public ReadTakeExpression(BlockingQueueCollection queue, boolean isRead, String whereClause, long timeout, TimeUnit timeUnit, int takeFor, String batchId, boolean isLast) {
        super(1);
        this.queue = queue;
        this.isRead = isRead;
        this.whereClause = whereClause;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.takeFor = takeFor;
        this.batchId = batchId;
        this.isLast = isLast;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.dataType = this.queue.getDataType();
    }

    @Override
    public Object getValue(Session session) {
        try {
            if (this.takeFor != -1) {
                ProcessQueueCollection processQueue = (ProcessQueueCollection)this.queue;
                if (this.takeFor == 600) {
                    return processQueue.takeFor(session, "", this.whereClause, this.timeout, this.timeUnit, ProcessState.LOCKED, this.isLast);
                }
                if (this.takeFor == 1037) {
                    return processQueue.takeFor(session, "", this.whereClause, this.timeout, this.timeUnit, ProcessState.LOCKED_FOR_OFFER, this.isLast);
                }
                if (this.takeFor == 1032) {
                    return processQueue.takeForBatch(session, this.whereClause, this.timeout, this.timeUnit, this.batchId, this.isLast);
                }
                throw new DataspaceException("Invalid takeFor " + this.takeFor);
            }
            if (this.queue instanceof EventQueueCollection) {
                EventQueueCollection eventQueue = (EventQueueCollection)this.queue;
                if (this.isRead) {
                    if (this.timeout != -1L) {
                        return eventQueue.waitToRead(session, this.whereClause, this.timeout, this.timeUnit, this.isLast);
                    }
                    return eventQueue.read(session, this.whereClause, this.isLast);
                }
                return eventQueue.waitToTake(session, this.whereClause, this.timeout, this.timeUnit, this.isLast);
            }
            if (this.isRead) {
                return this.queue.peek(session, this.isLast);
            }
            return this.queue.poll(session, this.timeout, this.timeUnit, this.isLast);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        if (this.isRead) {
            builder.append("read ");
        } else {
            builder.append("take ");
        }
        builder.append("from ").append(this.queue.getObjectName().getSchemaQualifiedStatementName());
        return builder.toString();
    }

    @Override
    public void collectObjectNames(Set set) {
        super.collectObjectNames(set);
        set.add(this.queue.getBaseTable().getObjectName());
    }
}

