/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;

public class RaiseRequestExpression
extends Expression {
    private Expression eventExpression;
    private int replyTimeout;
    private RequestDistributionStrategy distributionStrategy;
    private ReplyMatchStrategy matchStrategy;

    public RaiseRequestExpression(Expression eventExpression, int replyTimeout, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy) {
        super(1);
        this.eventExpression = eventExpression;
        this.replyTimeout = replyTimeout;
        this.distributionStrategy = distributionStrategy;
        this.matchStrategy = matchStrategy;
    }

    @Override
    public Object getValue(Session session) {
        DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
        Object eventObject = this.eventExpression.getValue(session);
        eventObject = OtherTypeWrapper.unwrap(eventObject);
        try {
            return dataspace.raiseRequest((EventDatagram)eventObject, this.distributionStrategy, this.matchStrategy, this.replyTimeout);
        }
        catch (Exception e) {
            throw new DataspaceException("Request raising failed. " + e.getMessage(), e);
        }
    }

    public Expression getEventExpression() {
        return this.eventExpression;
    }
}

