/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.StringComparator;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.navigator.RowSetNavigatorDataTable;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.ExplainComplexity;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionAggregate;
import com.streamscape.ds.parser.expression.ExpressionArrayUnnest;
import com.streamscape.ds.parser.expression.ExpressionClassifyAggregate;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionExpand;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionLogicalFacet;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionOrderBy;
import com.streamscape.ds.parser.expression.ExpressionTable;
import com.streamscape.ds.parser.expression.ExpressionUnfold;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.jfq.IndexJFQ;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.range.RangeVariableResolver;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.AbstractLazyFlobFunctionExpression;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FacetsSchemaObject;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.Type;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QuerySpecification
extends QueryExpression {
    public int resultRangePosition;
    public boolean isValueList;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    public RangeVariable[] rangeVariables;
    public HsqlArrayList rangeVariableList;
    int startInnerRange = -1;
    int endInnerRange = -1;
    public Expression queryCondition;
    public Expression checkQueryCondition;
    private Expression havingCondition;
    Expression rowExpression;
    public Expression[] exprColumns;
    private HsqlArrayList exprColumnList;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int groupByColumnCount;
    private int havingColumnCount;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean isSimpleCount;
    private boolean hasMemoryRow;
    public boolean isUniqueResultRows;
    Type[] columnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    public Index groupIndex;
    protected boolean isVtableResolved = false;
    private Map<String, Map<String, Expression>> vTableParameters = new HashMap<String, Map<String, Expression>>();
    private List<Expression> vtableParamExpressions = new ArrayList<Expression>();

    public QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean isValueList) {
        this(compileContext);
        this.isValueList = isValueList;
        RangeVariable range = new RangeVariable(table, null, null, null, compileContext);
        range.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(range);
        this.isMergeable = false;
        this.resolveReferences(session, RangeVariable.emptyArray);
        this.resolveTypes(session);
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.resultRangePosition = compileContext.getNextRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isMergeable = true;
    }

    public void addRangeVariable(RangeVariable rangeVar) {
        this.rangeVariableList.add(rangeVar);
    }

    private void resolveRangeVariables(Session session, RangeVariable[] outerRanges) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTable(session, this.rangeVariables, i, outerRanges);
            if (this.rangeVariables[i].rangeTable instanceof TableDerived && this.rangeVariables[i].rangeTable.getSubQuery() != null && this.rangeVariables[i].rangeTable.getSubQuery().dataExpression instanceof ExpressionTable && this.rangeVariables[i].rangeTable.getSubQuery().dataExpression.unresolvedExpressions != null) {
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new HsqlArrayList();
                }
                this.unresolvedExpressions.addAll(this.rangeVariables[i].rangeTable.getSubQuery().dataExpression.unresolvedExpressions);
            }
            this.rangeVariables[i].rangePositionInJoin = i;
            if (this.rangeVariables[i].isLeftJoin && this.endInnerRange == -1) {
                this.endInnerRange = i;
            }
            if (!this.rangeVariables[i].isRightJoin) continue;
            this.startInnerRange = i;
        }
        if (this.startInnerRange < 0) {
            this.startInnerRange = 0;
        }
        if (this.endInnerRange < 0) {
            this.endInnerRange = this.rangeVariables.length;
        }
        if (this.startInnerRange > this.endInnerRange) {
            this.endInnerRange = this.rangeVariables.length;
        }
    }

    public void addSelectColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (e.opType == 97 && ((ExpressionColumn)e).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression first = (Expression)this.exprColumnList.get(0);
            if (first.opType == 97 && ((ExpressionColumn)first).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(e);
        ++this.indexLimitVisible;
    }

    public void addQueryCondition(Expression e) {
        this.queryCondition = e;
    }

    public void addGroupByColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(e);
        this.isGrouped = true;
        ++this.groupByColumnCount;
    }

    public void addHavingExpression(Expression e) {
        this.exprColumnList.add(e);
        this.havingCondition = e;
        this.havingColumnCount = 1;
    }

    @Override
    public void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session, RangeVariable[] outerRanges) {
        this.resolveRangeVariables(session, outerRanges);
        this.resolveColumnReferencesForAsterisk(session);
        this.resolveColumnReferencesForUnfold(session);
        this.finaliseColumns();
        this.resolveColumnReferences(session, outerRanges);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.setReferenceableColumns();
    }

    @Override
    public boolean hasReference(RangeVariable range) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    @Override
    public void resolve(Session session, RangeVariable[] outerRanges, Type[] targetTypes) {
        this.resolveVtableParameters(session);
        try {
            ExpressionColumn.addParentQuerySpecification(this);
            super.resolve(session, outerRanges, targetTypes);
        }
        catch (Exception error) {
            if (error instanceof DataspaceException && ((DataspaceException)error).getErrorCode() == -5501) {
                ((DataspaceException)error).setMessage(error.getMessage() + ", query: " + this.getSQL());
            }
            throw error;
        }
        finally {
            ExpressionColumn.removeParentQuerySpecificationLast();
        }
    }

    public void resolveVtableParameters(Session session) {
        if (!this.isVtableResolved) {
            if (this.queryCondition != null && this.checkQueryCondition(session, this.queryCondition)) {
                this.queryCondition = ExpressionLogical.EXPR_TRUE;
            }
            this.isVtableResolved = true;
        }
    }

    private boolean checkQueryCondition(Session session, Expression expr) {
        if (expr instanceof ExpressionLogical && ((ExpressionLogical)expr).nodes != null && ((ExpressionLogical)expr).nodes.length >= 2 && ((ExpressionLogical)expr).opType == 41 && ((ExpressionLogical)expr).nodes[0] instanceof ExpressionColumn) {
            String paramName = ((ExpressionColumn)((ExpressionLogical)expr).nodes[0]).getColumnName();
            if (this.baseTable != null && this.baseTable instanceof VirtualTable) {
                if (((VirtualTable)this.baseTable).hasParameter(paramName)) {
                    this.setVtableParameter(this.baseTable.getObjectName(), paramName, ((ExpressionLogical)expr).nodes[1]);
                    this.vtableParamExpressions.add(((ExpressionLogical)expr).nodes[1]);
                    ((ExpressionLogical)expr).nodes[1].resolveTypes(session, expr);
                    return true;
                }
            } else {
                for (RangeVariable var : this.compileContext.getRangeVariables()) {
                    if (var.getTable() == null || !(var.getTable() instanceof VirtualTable) || !((VirtualTable)var.getTable()).hasParameter(paramName) || ((ExpressionColumn)((ExpressionLogical)expr).nodes[0]).getTableName() != null && ((ExpressionColumn)((ExpressionLogical)expr).nodes[0]).getTableName().length() != 0 && var.getTableAlias() != null && !((ExpressionColumn)((ExpressionLogical)expr).nodes[0]).getTableName().equals(var.getTableAlias().name)) continue;
                    this.setVtableParameter(var.getTable().getObjectName(), paramName, ((ExpressionLogical)expr).nodes[1]);
                    this.vtableParamExpressions.add(((ExpressionLogical)expr).nodes[1]);
                    ((ExpressionLogical)expr).nodes[1].resolveTypes(session, expr);
                    return true;
                }
            }
        }
        if (expr != null && expr.subQuery != null && expr.subQuery.queryExpression != null && expr.subQuery.queryExpression instanceof QuerySpecification) {
            ((QuerySpecification)expr.subQuery.queryExpression).resolveVtableParameters(session);
        }
        if (expr != null && expr.nodes != null) {
            for (int i = 0; i < expr.nodes.length; ++i) {
                if (!this.checkQueryCondition(session, expr.nodes[i])) continue;
                expr.nodes[i] = ExpressionLogical.EXPR_TRUE;
            }
        }
        return false;
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
    }

    @Override
    void resolveTypesPartOne(Session session) {
        this.resolveExpressionTypes(session, this.rowExpression);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int i;
        this.resolveGroups();
        for (i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            if (type == null) {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[i] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[i].setDataType(session, type);
            if (!this.exprColumns[i].dataType.isArrayType() || this.exprColumns[i].dataType.collectionBaseType() != null) continue;
            throw Error.error(5567);
        }
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability();
        if (this.findSelectIntoCollection() != null) {
            for (Expression expression : this.exprColumns) {
                if (!(expression instanceof ExpressionColumn)) continue;
                ((ExpressionColumn)expression).resolveColumnDataTypeInternal(session);
            }
        }
        this.createResultMetaData(session);
        this.createTable(session);
        if (this.isMergeable) {
            this.mergeQuery();
        }
        this.sortAndSlice.setSortIndex(this);
        this.setRangeVariableConditions(session);
        this.setDistinctConditions(session);
        this.setAggregateConditions(session);
        this.sortAndSlice.setSortRange(this);
        this.isResolved = true;
    }

    private void resolveColumnReferences(Session session, RangeVariable[] outerRanges) {
        int i;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            Expression e = this.rangeVariables[i2].getJoinCondition();
            if (e == null) continue;
            this.resolveColumnReferencesAndAllocate(session, e, i2 + 1, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, false);
        for (Expression expr : this.vtableParamExpressions) {
            this.resolveColumnReferencesAndAllocate(session, expr, this.rangeVariables.length, false);
        }
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, this.acceptsSequences);
        }
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            this.exprColumns[i] = this.resolveColumnReferencesInGroupBy(session, this.exprColumns[i]);
        }
        for (i = this.indexStartHaving; i < this.indexStartOrderBy; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, false);
        }
        this.resolveColumnRefernecesInOrderBy(session, outerRanges, this.sortAndSlice);
    }

    void resolveColumnRefernecesInOrderBy(Session session, RangeVariable[] outerRanges, SortAndSlice sortAndSlice) {
        int orderCount = sortAndSlice.getOrderLength();
        for (int i = 0; i < orderCount; ++i) {
            boolean check;
            ExpressionOrderBy e = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(e);
            if (e.getLeftNode().queryTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && e.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            e.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, e, this.rangeVariables.length, false);
            if (!this.isAggregated && !this.isGrouped || (check = e.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            sortAndSlice.limitCondition.resolveColumnReferences(session, outerRanges, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this);
    }

    private boolean resolveColumnReferences(Session session, Expression e, int rangeCount, boolean withSequences) {
        if (e == null) {
            return true;
        }
        int oldSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = e.resolveColumnReferences(session, this.rangeVariables, rangeCount, this.unresolvedExpressions, withSequences);
        int newSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return oldSize == newSize;
    }

    private void resolveColumnReferencesForUnfold(Session session) {
        int pos = 0;
        while (pos < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(pos);
            if (e instanceof ExpressionUnfold) {
                this.exprColumnList.remove(pos);
                Expression facetsColumn = null;
                String tablename = ((ExpressionColumn)e.getLeftNode()).getTableName();
                if (tablename == null) {
                    int i;
                    String facetsColumnName = ((ExpressionColumn)e.getLeftNode()).getColumnName();
                    HsqlArrayList list = new HsqlArrayList();
                    for (i = 0; i < this.rangeVariables.length; ++i) {
                        this.rangeVariables[i].addTableColumns(list);
                    }
                    for (i = 0; i < list.size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)list.get(i);
                        if (!expressionColumn.getColumn().getNameString().equals(facetsColumnName)) continue;
                        facetsColumn = expressionColumn;
                        break;
                    }
                }
                if (facetsColumn.getDataType().typeCode != 1122) {
                    throw new DataspaceException("Invalid column type in UNFOLD expression. Expected FACETS, but encountered " + facetsColumn.getDataType().getDefinition());
                }
                FacetsType facetsType = (FacetsType)facetsColumn.getDataType();
                FacetsSchemaObject facetsSchemaObject = facetsType.getFacetsSchemaObject();
                ArrayList<String> facetsColumnNames = new ArrayList<String>(((ExpressionUnfold)e).getFacetsColumnNames());
                if (facetsColumnNames.size() == 0 && facetsSchemaObject != null) {
                    facetsColumnNames.addAll(facetsSchemaObject.getColumnsMap().keySet());
                }
                int nodesLength = 0;
                if (facetsColumnNames.size() > 0) {
                    for (int i = 0; i < facetsColumnNames.size(); ++i) {
                        ExpressionColumn node = new ExpressionColumn(((ExpressionColumn)facetsColumn).getColumn());
                        node.setSpath("/" + (String)facetsColumnNames.get(i));
                        node.setAlias(NameManager.getSimpleName((String)facetsColumnNames.get(i), false));
                        this.exprColumnList.add(pos, node);
                        ++pos;
                        ++nodesLength;
                    }
                } else {
                    this.exprColumnList.add(pos, e);
                    ++pos;
                    ++nodesLength;
                }
                this.indexLimitVisible += nodesLength - 1;
                continue;
            }
            ++pos;
        }
    }

    private void resolveColumnReferencesForAsterisk(Session session) {
        int pos = 0;
        while (pos < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(pos);
            if (e.getType() == 97) {
                this.exprColumnList.remove(pos);
                String tablename = ((ExpressionColumn)e).getTableName();
                if (tablename == null) {
                    this.addAllJoinedColumns(e);
                } else {
                    int rangeIndex = e.findMatchingRangeVariableIndex(this.rangeVariables);
                    if (rangeIndex == -1) {
                        throw Error.error(5501, tablename);
                    }
                    RangeVariable range = this.rangeVariables[rangeIndex];
                    com.streamscape.ds.lib.HashSet exclude = this.getAllNamedJoinColumns();
                    range.addTableColumns(e, exclude);
                }
                int nodesLength = 0;
                for (int i = 0; i < e.nodes.length; ++i) {
                    ExpressionColumn node = (ExpressionColumn)e.nodes[i];
                    if (!session.getGrantee().isDisclosableSelectField(node.getRangeVariable().getTable(), node.getColumn())) {
                        node.getRangeVariable().usedColumns[node.getRangeVariable().findColumn((ExpressionColumn)node)] = false;
                        continue;
                    }
                    this.exprColumnList.add(pos, node);
                    ++pos;
                    ++nodesLength;
                }
                this.indexLimitVisible += nodesLength - 1;
                continue;
            }
            ++pos;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression, int count, boolean withSequences) {
        if (expression == null) {
            return;
        }
        HsqlList list = expression.resolveColumnReferences(session, this.rangeVariables, count, null, withSequences);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Expression e = (Expression)list.get(i);
                boolean resolved = true;
                if (e.isSelfAggregate()) {
                    for (int j = 0; j < e.nodes.length; ++j) {
                        HsqlList colList = e.nodes[j].resolveColumnReferences(session, this.rangeVariables, count, null, false);
                        resolved &= colList == null;
                    }
                } else {
                    resolved = this.resolveColumnReferences(session, e, count, withSequences);
                }
                if (resolved) {
                    if (e.isSelfAggregate()) {
                        if (this.aggregateSet == null) {
                            this.aggregateSet = new ArrayListIdentity();
                        }
                        this.aggregateSet.add(e);
                        this.isAggregated = true;
                        expression.setAggregate();
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(e);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(e);
            }
        }
    }

    private Expression resolveColumnReferencesInGroupBy(Session session, Expression expression) {
        if (expression == null) {
            return null;
        }
        HsqlList list = expression.resolveColumnReferences(session, this.rangeVariables, this.rangeVariables.length, null, false);
        if (list != null) {
            Expression resolved;
            if (expression.getType() == 2 && (resolved = expression.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible)) != expression) {
                return resolved;
            }
            this.resolveColumnReferencesAndAllocate(session, expression, this.rangeVariables.length, false);
        }
        return expression;
    }

    private com.streamscape.ds.lib.HashSet getAllNamedJoinColumns() {
        com.streamscape.ds.lib.HashSet set = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            if (range.namedJoinColumns == null) continue;
            if (set == null) {
                set = new com.streamscape.ds.lib.HashSet();
            }
            set.addAll(range.namedJoinColumns);
        }
        return set;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet nameSet, RangeVariable rightRange, boolean fullList) {
        com.streamscape.ds.lib.HashSet set = new com.streamscape.ds.lib.HashSet();
        Expression result = null;
        OrderedHashSet joinColumnNames = new OrderedHashSet();
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            HashMappedList columnList = range.rangeTable.columnList;
            for (int j = 0; j < columnList.size(); ++j) {
                boolean repeated;
                ColumnSchema column = (ColumnSchema)columnList.get(j);
                String name = range.getColumnAlias((int)j).name;
                boolean columnInList = nameSet.contains(name);
                boolean namedJoin = range.namedJoinColumns != null && range.namedJoinColumns.contains(name);
                boolean bl = repeated = !namedJoin && !set.add(name);
                if (repeated && (!fullList || columnInList)) {
                    throw Error.error(5578, name);
                }
                if (!columnInList) continue;
                joinColumnNames.add(name);
                int leftPosition = range.rangeTable.getColumnIndex(column.getNameString());
                int rightPosition = rightRange.rangeTable.getColumnIndex(name);
                ExpressionLogical e = new ExpressionLogical(range, leftPosition, rightRange, rightPosition);
                result = ExpressionLogical.andExpressions(result, e);
                ExpressionColumn col = range.getColumnExpression(name);
                if (col == null) {
                    col = new ExpressionColumn(new Expression[]{e.getLeftNode(), e.getRightNode()}, name);
                    range.addNamedJoinColumnExpression(name, col);
                } else {
                    col.nodes = (Expression[])ArrayUtil.resizeArray(col.nodes, col.nodes.length + 1);
                    col.nodes[col.nodes.length - 1] = e.getRightNode();
                }
                rightRange.addNamedJoinColumnExpression(name, col);
            }
        }
        if (fullList && !joinColumnNames.containsAll(nameSet)) {
            throw Error.error(5501);
        }
        rightRange.addNamedJoinColumns(joinColumnNames);
        return result;
    }

    private void addAllJoinedColumns(Expression e) {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(list);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        e.nodes = nodes;
    }

    private void finaliseColumns() {
        int i;
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].queryTableColumnIndex = i;
        }
        if (this.sortAndSlice.hasOrder()) {
            for (i = 0; i < this.sortAndSlice.getOrderLength(); ++i) {
                this.exprColumns[this.indexStartOrderBy + i] = (Expression)this.sortAndSlice.exprList.get(i);
            }
        }
        this.rowExpression = new Expression(25, this.exprColumns);
    }

    private void replaceColumnIndexInOrderBy(Expression orderBy) {
        int i;
        Expression e = orderBy.getLeftNode();
        if (e.getType() != 1) {
            return;
        }
        Type type = e.getDataType();
        if (type != null && type.typeCode == 4 && 0 < (i = ((Integer)e.getValue(null)).intValue()) && i <= this.indexLimitVisible) {
            orderBy.setLeftNode(this.exprColumns[i - 1]);
            return;
        }
        throw Error.error(5576);
    }

    void collectRangeVariables(RangeVariable[] rangeVars, Set set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectRangeVariables(rangeVars, set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectRangeVariables(rangeVars, set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectRangeVariables(rangeVars, set);
        }
    }

    public void resolveExpressionTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            Expression e = this.exprColumns[i];
            e.resolveTypes(session, parent);
            if (e.getType() == 25) {
                throw Error.error(5565);
            }
            if (e.getDataType() == null || e.getDataType().typeCode != 19) continue;
            throw Error.error(5565);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            Expression e = this.rangeVariables[i].getJoinCondition();
            if (e == null) continue;
            e.resolveTypes(session, null);
            if (e.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingCondition != null) {
            this.havingCondition.resolveTypes(session, null);
            if (this.havingCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int i = this.indexStartAggregates;
            int j = 0;
            while (i < this.indexLimitExpressions) {
                Expression e = (Expression)this.tempSet.get(j);
                this.exprColumns[i] = e.duplicate();
                this.exprColumns[i].nodes = e.nodes;
                this.exprColumns[i].dataType = e.dataType;
                ++i;
                ++j;
            }
            this.tempSet.clear();
        }
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeResolver = new RangeVariableResolver(this);
        rangeResolver.processConditions(session);
        this.rangeVariables = rangeResolver.rangeVariables;
    }

    private void setDistinctConditions(Session session) {
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        RangeVariable range = null;
        this.tempSet.clear();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            if (this.exprColumns[i].getType() != 2) {
                return;
            }
            if (i == 0) {
                range = this.exprColumns[i].getRangeVariable();
            } else if (range != this.exprColumns[i].getRangeVariable()) {
                return;
            }
            this.tempSet.add(this.exprColumns[i].getColumn().getObjectName().name);
        }
        if (!range.hasAnyIndexCondition()) {
            int[] colMap = range.rangeTable.getColumnIndexes(this.tempSet);
            Index index = range.rangeTable.getFullIndexForColumns(colMap);
            if (index != null) {
                range.setSortIndex(index, false);
            }
            return;
        }
        int[] colMap = range.rangeTable.getColumnIndexes(this.tempSet);
        range.setDistinctColumnsOnIndex(colMap);
    }

    private void setAggregateConditions(Session session) {
        if (!this.isAggregated) {
            return;
        }
        if (this.isGrouped) {
            this.setGroupedAggregateConditions(session);
        } else if (!this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression e = this.exprColumns[this.indexStartAggregates];
            int opType = e.getType();
            switch (opType) {
                case 73: 
                case 74: {
                    if (e.hasCondition()) break;
                    SortAndSlice slice = new SortAndSlice();
                    slice.isGenerated = true;
                    slice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!slice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = slice;
                    break;
                }
                case 71: {
                    if (e.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null) break;
                    Expression expr = e.getLeftNode();
                    if (expr.getType() == 11) {
                        this.isSimpleCount = true;
                        break;
                    }
                    if (expr.getNullability() != 0) break;
                    if (((ExpressionAggregate)e).isDistinctAggregate) {
                        Table t;
                        if (expr.opType != 2 || (t = expr.getRangeVariable().getTable()).getPrimaryKey().length != 1 || t.getColumn(t.getPrimaryKey()[0]) != expr.getColumn()) break;
                        this.isSimpleCount = true;
                        break;
                    }
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
    }

    private void setGroupedAggregateConditions(Session session) {
    }

    void checkLobUsage() {
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (!this.exprColumns[i].dataType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private void resolveGroups() {
        Expression e;
        int i;
        ExpressionColumn c;
        Expression e2;
        int i2;
        Expression e3;
        int i3;
        int orderCount;
        int i4;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                this.exprColumns[i4].collectAllExpressions(this.tempSet, Expression.aggregateFunctionSet, Expression.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                if (this.exprColumns[i4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, Expression.subqueryAggregateExpressionSet)) continue;
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.tempSet.isEmpty() && !this.resolveForGroupBy(this.tempSet)) {
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        } else if (this.isAggregated) {
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                this.exprColumns[i4].collectAllExpressions(this.tempSet, Expression.columnExpressionSet, Expression.aggregateFunctionSet);
                if (this.tempSet.isEmpty() || this.aggregateSet.size() == 1 && this.aggregateSet.get(0) instanceof ExpressionClassifyAggregate) continue;
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        }
        this.tempSet.clear();
        if (this.havingCondition != null) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.havingCondition.isComposedOf(this.tempSet, Expression.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isAggregate() || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (!this.isAggregated) {
            return;
        }
        OrderedHashSet expressions = new OrderedHashSet();
        OrderedHashSet columnExpressions = new OrderedHashSet();
        for (i2 = this.indexStartAggregates; i2 < this.indexLimitExpressions; ++i2) {
            e2 = this.exprColumns[i2];
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            expressions.add(e2);
            columnExpressions.add(c);
        }
        for (i2 = 0; i2 < this.indexStartHaving; ++i2) {
            if (this.exprColumns[i2].isAggregate() || !expressions.add(e2 = this.exprColumns[i2])) continue;
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            columnExpressions.add(c);
        }
        int orderCount2 = this.sortAndSlice.getOrderLength();
        for (i = 0; i < orderCount2; ++i) {
            e = (Expression)this.sortAndSlice.exprList.get(i);
            if (!e.getLeftNode().isAggregate()) continue;
            e.setAggregate();
        }
        for (i = this.indexStartOrderBy; i < this.indexStartAggregates; ++i) {
            if (!this.exprColumns[i].getLeftNode().isAggregate()) continue;
            this.exprColumns[i].setAggregate();
        }
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            if (!e.isAggregate() && !e.isCorrelated()) continue;
            this.aggregateCheck[i] = true;
            if (!e.isAggregate()) continue;
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        for (i = 0; i < this.aggregateSet.size(); ++i) {
            e = (Expression)this.aggregateSet.get(i);
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (i = 0; i < this.resolvedSubqueryExpressions.size(); ++i) {
                e = (Expression)this.resolvedSubqueryExpressions.get(i);
                e.convertToSimpleColumn(expressions, columnExpressions);
            }
        }
    }

    boolean resolveForGroupBy(HsqlList unresolvedSet) {
        int i;
        for (i = this.indexLimitVisible; i < this.indexLimitVisible + this.groupByColumnCount; ++i) {
            Expression e = this.exprColumns[i];
            if (e.getType() != 2) continue;
            RangeVariable range = e.getRangeVariable();
            int colIndex = e.getColumnIndex();
            range.columnsInGroupBy[colIndex] = true;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            range.hasKeyedColumnInGroupBy = range.rangeTable.getUniqueNotNullColumnGroup(range.columnsInGroupBy) != null;
        }
        OrderedHashSet set = null;
        for (int i2 = 0; i2 < unresolvedSet.size(); ++i2) {
            Expression e = (Expression)unresolvedSet.get(i2);
            set = e.getUnkeyedColumns(set);
        }
        return set == null;
    }

    @Override
    public Result getResult(Session session, int maxrows) {
        for (Map.Entry<String, Map<String, Expression>> tableParam : this.vTableParameters.entrySet()) {
            for (Map.Entry<String, Expression> param : tableParam.getValue().entrySet()) {
                session.sessionContext.setVtableParameter(tableParam.getKey(), param.getKey(), param.getValue());
            }
        }
        OrderedHashSet set = new OrderedHashSet();
        this.getRangeVariables(set);
        com.streamscape.ds.lib.Iterator iter = set.iterator();
        while (iter.hasNext()) {
            RangeVariable range = (RangeVariable)iter.next();
            Table table = range.getTable();
            if (!(table instanceof VirtualTable)) continue;
            ((VirtualTable)table).materialize(session);
        }
        Result r = this.getSingleResult(session, maxrows);
        r.getNavigator().reset();
        return r;
    }

    private Result getSingleResult(Session session, int maxRows) {
        int[] limits = this.sortAndSlice.getLimits(session, this, maxRows);
        Result r = this.buildResult(session, limits);
        RowSetNavigatorData navigator = (RowSetNavigatorData)r.getNavigator();
        if (this.isDistinctSelect) {
            navigator.removeDuplicates(session);
        }
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipFullResult) {
            navigator.sortOrder(session);
        }
        if (limits != SortAndSlice.defaultLimits && !this.sortAndSlice.skipFullResult) {
            navigator.trim(limits[0], limits[1]);
        }
        r = this.unfoldFacets(session, r);
        return r;
    }

    /*
     * WARNING - void declaration
     */
    private Result unfoldFacets(Session session, Result result) {
        void var7_11;
        int i;
        ArrayList<Integer> unfoldColumnIndexes = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.exprColumns.length; ++i2) {
            if (!(this.exprColumns[i2] instanceof ExpressionUnfold) && (!(this.exprColumns[i2] instanceof ExpressionExpand) || !((ExpressionExpand)this.exprColumns[i2]).isWithUnfold())) continue;
            unfoldColumnIndexes.add(i2);
        }
        if (unfoldColumnIndexes.size() == 0) {
            return result;
        }
        ArrayList facetsColumnsSets = new ArrayList();
        for (i = 0; i < unfoldColumnIndexes.size(); ++i) {
            facetsColumnsSets.add(new HashSet());
        }
        result.navigator.beforeFirst();
        while (result.navigator.next()) {
            for (i = 0; i < unfoldColumnIndexes.size(); ++i) {
                int columnIndex = (Integer)unfoldColumnIndexes.get(i);
                if (!(result.navigator.getCurrent()[columnIndex] instanceof Facets)) continue;
                ((HashSet)facetsColumnsSets.get(i)).addAll(((Facets)result.navigator.getCurrent()[columnIndex]).keys());
            }
        }
        int newColumnsCount = 0;
        for (HashSet hashSet : facetsColumnsSets) {
            newColumnsCount += hashSet.size();
        }
        HashMap facetsColumnsListMapToIndex = new HashMap();
        boolean bl = false;
        while (var7_11 < unfoldColumnIndexes.size()) {
            facetsColumnsListMapToIndex.put((Integer)unfoldColumnIndexes.get((int)var7_11), new LinkedHashMap());
            ArrayList facetColumnsList = new ArrayList((Collection)facetsColumnsSets.get((int)var7_11));
            facetColumnsList.sort(new StringComparator());
            for (int j = 0; j < facetColumnsList.size(); ++j) {
                ((Map)facetsColumnsListMapToIndex.get(unfoldColumnIndexes.get((int)var7_11))).put((String)facetColumnsList.get(j), j);
            }
            ++var7_11;
        }
        Type[] typeArray = new Type[newColumnsCount += this.resultMetaData.getColumnCount() - unfoldColumnIndexes.size()];
        ColumnBase[] newColumns = new ColumnBase[newColumnsCount];
        String[] newColumnLabels = new String[newColumnsCount];
        int[] newColumnMap = new int[newColumnsCount];
        HashSet<CallSite> columnNames = new HashSet<CallSite>(Arrays.stream(this.resultMetaData.columnLabels).collect(Collectors.toSet()));
        int offset = 0;
        for (int i4 = 0; i4 < this.resultMetaData.columns.length; ++i4) {
            if (facetsColumnsListMapToIndex.containsKey(i4)) {
                ArrayList facetColumns = new ArrayList(((Map)facetsColumnsListMapToIndex.get(i4)).keySet());
                for (int j = 0; j < facetColumns.size(); ++j) {
                    String newColumnName = this.resultMetaData.columnLabels[i4] + "." + (String)facetColumns.get(j);
                    if (columnNames.contains(newColumnName)) {
                        int index = 1;
                        while (columnNames.contains(newColumnName + "_" + index)) {
                            ++index;
                        }
                        newColumnName = newColumnName + "_" + index;
                    }
                    columnNames.add((CallSite)((Object)newColumnName));
                    newColumnLabels[i4 + offset + j] = newColumnName;
                    typeArray[i4 + offset + j] = Type.STRING;
                    newColumns[i4 + offset + j] = new ColumnBase();
                    if (this.resultMetaData.colIndexes == null) continue;
                    newColumnMap[i4 + offset + j] = this.resultMetaData.colIndexes[i4];
                }
                offset += facetColumns.size() - 1;
                continue;
            }
            newColumnLabels[i4 + offset] = this.resultMetaData.columnLabels[i4];
            typeArray[i4 + offset] = this.resultMetaData.columnTypes[i4];
            newColumns[i4 + offset] = this.resultMetaData.columns[i4];
            if (this.resultMetaData.colIndexes == null) continue;
            newColumnMap[i4 + offset] = this.resultMetaData.colIndexes[i4];
        }
        ResultMetaData newResultMetaData = ResultMetaData.newResultMetaData(typeArray, newColumnMap, newColumnsCount, newColumnsCount);
        newResultMetaData.columnLabels = newColumnLabels;
        newResultMetaData.columnTypes = typeArray;
        newResultMetaData.columns = newColumns;
        RowSetNavigatorData[] navigator = new RowSetNavigatorData[]{new RowSetNavigatorData(session, this)};
        navigator[0].visibleColumnCount += newColumnsCount;
        Result newResult = Result.newResult(navigator[0]);
        newResult.metaData = newResultMetaData;
        result.navigator.beforeFirst();
        while (result.navigator.next()) {
            Object[] data = result.navigator.getCurrent();
            Object[] newData = new Object[newColumnsCount];
            offset = 0;
            for (int i5 = 0; i5 < this.resultMetaData.getColumnCount(); ++i5) {
                if (facetsColumnsListMapToIndex.containsKey(i5)) {
                    Map facetColumns = (Map)facetsColumnsListMapToIndex.get(i5);
                    if (data[i5] instanceof Facets) {
                        for (Map.Entry entries : ((Facets)data[i5]).entrySet()) {
                            newData[i5 + offset + ((Integer)facetColumns.get(entries.getKey())).intValue()] = entries.getValue();
                        }
                    }
                    offset += facetColumns.size() - 1;
                    continue;
                }
                newData[i5 + offset] = data[i5];
            }
            navigator[0].add(newData);
        }
        return newResult;
    }

    private Result buildResult(Session session, int[] limits) {
        int i;
        if (this.rangeVariables.length == 0 && this.exprColumns.length == 1 && this.exprColumns[0] instanceof FunctionCustom && ((FunctionCustom)this.exprColumns[0]).funcType == 160 && this.exprColumns[0].nodes[0] instanceof ExpressionArrayUnnest) {
            Result result = (Result)this.exprColumns[0].getValue(session);
            result.metaData.columnLabels = this.resultMetaData.columnLabels;
            return result;
        }
        RowSetNavigatorData[] navigator = new RowSetNavigatorData[]{new RowSetNavigatorData(session, this)};
        Result result = Result.newResult(navigator[0]);
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        int[] skipCount = new int[1];
        int[] limitCount = new int[]{limits[2]};
        if (this.sortAndSlice.skipFullResult) {
            skipCount[0] = limits[0];
            limitCount[0] = limits[1];
        }
        if (this.isSimpleCount) {
            Object[] data = new Object[this.indexLimitData];
            Table table = this.rangeVariables[0].getTable();
            PersistentStore store = table.getRowStore(session);
            long count = store.elementCount(session);
            data[0] = data[this.indexStartAggregates] = ValuePool.getLong(count);
            navigator[0].add(data);
            return result;
        }
        int fullJoinIndex = 0;
        RangeIterator[] rangeIterators = new RangeIterator[this.rangeVariables.length];
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            rangeIterators[i2] = this.rangeVariables[i2].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        ArrayList<Integer> unnestColumnIndexes = null;
        for (i = 0; i < this.exprColumns.length; ++i) {
            if (!(this.exprColumns[i] instanceof ExpressionArrayUnnest)) continue;
            if (unnestColumnIndexes == null) {
                unnestColumnIndexes = new ArrayList<Integer>();
            }
            unnestColumnIndexes.add(i);
        }
        if (this.rangeVariables.length == 0 && this.exprColumns != null) {
            session.sessionData.startRowProcessing();
            Object[] data = new Object[this.exprColumns.length];
            for (int i3 = 0; i3 < data.length; ++i3) {
                data[i3] = this.exprColumns[i3].getValue(session);
                if (data[i3] instanceof AbstractLazyFlobFunctionExpression) {
                    data[i3] = ((AbstractLazyFlobFunctionExpression)data[i3]).getLazyFlobData(session);
                }
                if (!(data[i3] instanceof FlobData) || !(this.exprColumns[i3].getDataType() instanceof FlobType)) continue;
                ((FlobType)this.exprColumns[i3].getDataType()).setAutotag(((FlobData)data[i3]).getAutotag());
                ((FlobType)this.exprColumns[i3].getDataType()).setLocation(((FlobData)data[i3]).getLocation());
                ((FlobType)this.exprColumns[i3].getDataType()).setCharset(((FlobData)data[i3]).getCharset());
            }
            this.processUnnestedColumns(data, unnestColumnIndexes, d -> {
                navigator[0].add((Object[])d);
                if (navigator[0].getSize() >= limitCount[0]) {
                    return false;
                }
                return true;
            });
            return result;
        }
        int currentIndex = 0;
        while (true) {
            int i4;
            RangeIterator it;
            Session.checkIfThreadIsInterrupted();
            if (session.getSLSessionName() != null && session.dataspaceStore.queryMemoryMonitor != null && navigator[0].getSize() > session.dataspaceStore.queryMemoryMonitor.getChkRowsStart() && navigator[0].getSize() % session.dataspaceStore.queryMemoryMonitor.getChkRowsInterval() == 0 && session.dataspaceStore.queryMemoryMonitor != null && session.dataspaceStore.queryMemoryMonitor.isExceeded()) {
                System.gc();
                throw new DataspaceException("Result too big to fit in memory. Consider setting SESSION RESULT MEMORY ROWS parameter, or configure dtspace.query_mem_limit* parameters to set memory limit or selecting a smaller result set.");
            }
            if (currentIndex < fullJoinIndex) {
                boolean end = true;
                for (int i5 = fullJoinIndex + 1; i5 < this.rangeVariables.length; ++i5) {
                    if (!this.rangeVariables[i5].isRightJoin) continue;
                    fullJoinIndex = i5;
                    currentIndex = i5;
                    end = false;
                    ((RangeVariable.RangeIteratorRight)rangeIterators[i5]).setOnOuterRows();
                    break;
                }
                if (end) break;
            }
            if ((it = rangeIterators[currentIndex]) instanceof RangeVariable.RangeIteratorMain && ((RangeVariable.RangeIteratorMain)it).it instanceof IndexJFQ.RowIteratorJFQ) {
                ((IndexJFQ.RowIteratorJFQ)((RangeVariable.RangeIteratorMain)it).it).setSkip(false);
                if (this.isAggregated && this.indexLimitVisible <= this.indexLimitRowId) {
                    ((IndexJFQ.RowIteratorJFQ)((RangeVariable.RangeIteratorMain)it).it).setSkip(true);
                }
            }
            if (it.next()) {
                if (currentIndex < this.rangeVariables.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                it.reset();
                --currentIndex;
                continue;
            }
            if (limitCount[0] == 0) break;
            session.sessionData.startRowProcessing();
            Object[] data = new Object[this.indexLimitData];
            for (i4 = 0; i4 < this.indexStartAggregates; ++i4) {
                if (this.isAggregated && this.aggregateCheck[i4]) continue;
                data[i4] = this.exprColumns[i4].getValue(session);
                if (!(data[i4] instanceof ExpressionExpand.FacetsExpand) || !(it instanceof RangeVariable.RangeIteratorMain) || ((RangeVariable.RangeIteratorMain)it).joinConditions == null || ((RangeVariable.RangeIteratorMain)it).joinConditions.length <= 0 || !(((RangeVariable.RangeIteratorMain)it).joinConditions[0].nonIndexCondition instanceof ExpressionLogicalFacet)) continue;
                data[i4] = ((ExpressionLogicalFacet)((RangeVariable.RangeIteratorMain)it).joinConditions[0].nonIndexCondition).makeFacet(((ExpressionExpand.FacetsExpand)data[i4]).left, ((ExpressionExpand.FacetsExpand)data[i4]).right);
            }
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitRowId; ++i4) {
                data[i4] = i4 == this.indexLimitVisible ? it.getRowidObject() : it.getCurrentRow();
            }
            this.processUnnestedColumns(data, unnestColumnIndexes, d -> {
                ++session.sessionContext.rownum;
                if (skipCount[0] > 0) {
                    skipCount[0] = skipCount[0] - 1;
                    return true;
                }
                Object[] groupData = null;
                if (!(!this.isAggregated && !this.isGrouped || this.aggregateSet != null && this.aggregateSet.size() == 1 && this.aggregateSet.get(0) instanceof ExpressionClassifyAggregate || (groupData = navigator[0].getGroupData((Object[])d)) == null)) {
                    d = groupData;
                }
                for (int i = this.indexStartAggregates; i < this.indexLimitExpressions; ++i) {
                    d[i] = this.exprColumns[i].updateAggregatingValue(session, d[i]);
                }
                if (groupData == null) {
                    navigator[0].add((Object[])d);
                } else if (this.isAggregated) {
                    navigator[0].update(groupData, (Object[])d);
                }
                int rowCount = navigator[0].getSize();
                if (rowCount == session.getResultMemoryRowCount() && !this.isAggregated && !this.hasMemoryRow) {
                    navigator[0] = new RowSetNavigatorDataTable(session, this, navigator[0]);
                    result.setNavigator(navigator[0]);
                }
                if ((this.isAggregated || this.isGrouped) && !this.sortAndSlice.isGenerated) {
                    return true;
                }
                if (rowCount >= limitCount[0]) {
                    return false;
                }
                return true;
            });
            if (navigator[0].getSize() >= limitCount[0]) break;
        }
        navigator[0].reset();
        for (i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i].reset();
        }
        if (!this.isGrouped && !this.isAggregated) {
            return result;
        }
        if (this.isAggregated) {
            if (!this.isGrouped && navigator[0].getSize() == 0) {
                Object[] data = new Object[this.exprColumns.length];
                for (int i6 = 0; i6 < this.indexStartAggregates; ++i6) {
                    if (this.aggregateCheck[i6]) continue;
                    data[i6] = this.exprColumns[i6].getValue(session);
                }
                navigator[0].add(data);
            }
            navigator[0].reset();
            session.sessionContext.setRangeIterator(navigator[0]);
            while (navigator[0].next()) {
                int i7;
                Object[] data = navigator[0].getCurrent();
                for (i7 = this.indexStartAggregates; i7 < this.indexLimitExpressions; ++i7) {
                    data[i7] = this.exprColumns[i7].getAggregatedValue(session, data[i7]);
                }
                for (i7 = 0; i7 < this.indexStartAggregates; ++i7) {
                    if (!this.aggregateCheck[i7]) continue;
                    data[i7] = this.exprColumns[i7].getValue(session);
                }
            }
        }
        navigator[0].reset();
        if (this.havingCondition != null) {
            while (navigator[0].hasNext()) {
                Object[] data = navigator[0].getNext();
                if (Boolean.TRUE.equals(data[this.indexLimitVisible + this.groupByColumnCount])) continue;
                navigator[0].remove();
            }
            navigator[0].reset();
        }
        return result;
    }

    private void processUnnestedColumns(Object[] data, List<Integer> unnestColumnIndexes, Function<Object[], Boolean> consumer) {
        Object[] unnestedRowData;
        boolean wasChanged;
        if (unnestColumnIndexes == null) {
            consumer.apply(data);
            return;
        }
        int[] unnestRowsCounter = new int[unnestColumnIndexes.size()];
        Iterator[] unnestIterators = new Iterator[unnestColumnIndexes.size()];
        do {
            wasChanged = false;
            unnestedRowData = Arrays.copyOf(data, data.length);
            for (int i = 0; i < unnestColumnIndexes.size(); ++i) {
                int length;
                int columnIndex = unnestColumnIndexes.get(i);
                if (unnestedRowData[columnIndex] == null) continue;
                if (unnestedRowData[columnIndex] instanceof Object[]) {
                    length = ((Object[])unnestedRowData[columnIndex]).length;
                    if (unnestRowsCounter[i] < length) {
                        wasChanged = true;
                        unnestedRowData[columnIndex] = ((Object[])unnestedRowData[columnIndex])[unnestRowsCounter[i] % length];
                        int n = i;
                        unnestRowsCounter[n] = unnestRowsCounter[n] + 1;
                        continue;
                    }
                    unnestedRowData[columnIndex] = null;
                    continue;
                }
                if (unnestedRowData[columnIndex] instanceof Collection) {
                    if (unnestIterators[i] == null) {
                        unnestIterators[i] = ((Collection)unnestedRowData[columnIndex]).iterator();
                    }
                    if (unnestRowsCounter[i] < (length = ((Collection)unnestedRowData[columnIndex]).size()) && unnestIterators[i].hasNext()) {
                        wasChanged = true;
                        unnestedRowData[columnIndex] = unnestIterators[i].next();
                        int n = i;
                        unnestRowsCounter[n] = unnestRowsCounter[n] + 1;
                        continue;
                    }
                    unnestedRowData[columnIndex] = null;
                    continue;
                }
                throw new DataspaceException("Unsupported data of type '" + String.valueOf(unnestedRowData[columnIndex].getClass()) + "' passed to unnest statement. Should be array or collection.");
            }
        } while (wasChanged && consumer.apply(unnestedRowData).booleanValue());
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap aliases = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String alias = expression.getAlias();
            if (alias.length() == 0) {
                NameManager.ObjectName name = NameManager.getAutoColumnName(i);
                expression.setAlias(name);
                continue;
            }
            int index = aliases.get((Object)alias, -1);
            if (index == -1) {
                aliases.put(alias, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[index] = false;
        }
    }

    void setColumnAliases(NameManager.SimpleName[] names) {
        if (names.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(names[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createResultMetaData(Session session) {
        Expression e;
        int i;
        this.columnTypes = new Type[this.indexLimitData];
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        for (i = this.indexLimitVisible; i < this.indexLimitRowId; ++i) {
            this.columnTypes[i] = i == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (i = this.indexLimitRowId; i < this.indexLimitData; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        this.resultMetaData = ResultMetaData.newResultMetaData(this.columnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        i = 0;
        while (true) {
            block10: {
                if (i >= this.indexLimitVisible) {
                    return;
                }
                byte nullability = 2;
                Expression e2 = this.exprColumns[i];
                ColumnSchema tableColumn = null;
                this.resultMetaData.columnTypes[i] = e2.getDataType();
                switch (e2.getType()) {
                    case 2: {
                        RangeVariable range;
                        tableColumn = e2.getColumn();
                        if (tableColumn == null || (range = e2.getRangeVariable()) == null || range.rangePositionInJoin < this.startInnerRange || range.rangePositionInJoin >= this.endInnerRange) break;
                        this.resultMetaData.columns[i] = tableColumn;
                        this.resultMetaData.columnLabels[i] = e2.getAlias();
                        break block10;
                    }
                    case 3: 
                    case 12: 
                    case 14: {
                        nullability = 0;
                        break;
                    }
                    case 1: {
                        nullability = e2.valueData == null ? (byte)1 : 0;
                    }
                }
                ColumnBase column = tableColumn == null ? new ColumnBase() : new ColumnBase(session.dataspaceStore.getCatalogName().name, tableColumn.getSchemaNameString(), tableColumn.getTableNameString(), tableColumn.getNameString());
                column.setType(e2.getDataType());
                column.setNullability(nullability);
                this.resultMetaData.columns[i] = column;
                this.resultMetaData.columnLabels[i] = e2.getAlias();
            }
            ++i;
        }
    }

    @Override
    public void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            int[] groupCols = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                groupCols[i] = this.indexLimitVisible + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(null, groupCols, null, null, false, false, false, null);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            int[] idCols = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(null, idCols, null, null, false, false, false, null);
        }
    }

    void createFullIndex(Session session) {
        int[] fullCols = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(null, fullCols, null, null, false, false, false, null);
    }

    @Override
    void createResultTable(Session session) {
        NameManager.ObjectName tableName = session.dataspaceStore.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 21 ? 2 : 10;
        HashMappedList columnList = new HashMappedList();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression e = this.exprColumns[i];
            NameManager.SimpleName simpleName = e.getSimpleName();
            String nameString = simpleName.name;
            NameManager.ObjectName name = session.dataspaceStore.nameManager.newColumnSchemaHsqlName(tableName, simpleName);
            if (!this.accessibleColumns[i]) {
                nameString = NameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema column = new ColumnSchema(name, e.dataType, true, false, null);
            columnList.add(nameString, column);
        }
        try {
            this.resultTable = new TableDerived(session.dataspaceStore, tableName, tableType, this.columnTypes, columnList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSQL() {
        String whereClause;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        int limit = this.indexLimitVisible;
        for (i = 0; i < limit; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exprColumns[i].getSQL());
            if (this.exprColumns[i].alias == null) continue;
            sb.append(" as ").append(this.exprColumns[i].getAlias());
        }
        limit = this.rangeVariables.length;
        if (limit > 0) {
            sb.append(" ").append("FROM").append(" ");
        }
        for (i = 0; i < limit; ++i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            if (i > 0) {
                if (rangeVar.isLeftJoin && rangeVar.isRightJoin) {
                    sb.append("FULL").append(' ');
                } else if (rangeVar.isLeftJoin) {
                    sb.append("LEFT").append(' ');
                } else if (rangeVar.isRightJoin) {
                    sb.append("RIGHT").append(' ');
                }
                sb.append("JOIN").append(' ');
            }
            sb.append(rangeVar.getTable().getObjectName().statementName).append(' ');
            if (rangeVar.tableAlias != null) {
                sb.append(rangeVar.tableAlias.name).append(' ');
            }
            if (rangeVar.getJoinCondition() == null) continue;
            sb.append(" ON ").append(rangeVar.getJoinCondition().getSQL());
        }
        if (this.isGrouped) {
            sb.append(' ').append("GROUP").append(' ').append("BY").append(' ');
            limit = this.indexLimitVisible + this.groupByColumnCount;
            for (i = this.indexLimitVisible; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.queryCondition != null && (whereClause = this.queryCondition.getSQL()) != null && whereClause.length() > 0) {
            if (this.rangeVariables.length > 1) {
                sb.append(" ON ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(whereClause);
        }
        if (this.havingCondition != null) {
            sb.append(' ').append("HAVING").append(' ');
            sb.append(this.havingCondition.getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            limit = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            sb.append(' ').append("ORDER").append("BY").append(' ');
            for (int i2 = this.indexStartOrderBy; i2 < limit; ++i2) {
                sb.append(this.exprColumns[i2].getSQL());
                if (i2 >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            sb.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return sb.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        int i;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("isDistinctSelect", this.isDistinctSelect);
        result.put("isGrouped", this.isGrouped);
        result.put("isAggregated", this.isAggregated);
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            int index = i2;
            if (this.exprColumns[i2].getType() == 5) {
                index = this.exprColumns[i2].columnIndex;
            }
            columns.add(this.exprColumns[index].describeJson(session));
        }
        result.put("columns", columns);
        ArrayList<Map<String, Object>> rangeVariablesExplained = new ArrayList<Map<String, Object>>();
        for (int i3 = 0; i3 < this.rangeVariables.length; ++i3) {
            rangeVariablesExplained.add(this.rangeVariables[i3].describeJson(session));
        }
        result.put("rangeVariables", rangeVariablesExplained);
        ExplainComplexity explainComplexity = new ExplainComplexity(this.rangeVariables, session.dataspaceStore);
        explainComplexity.init();
        result.put("complexity", explainComplexity.getComplexity());
        result.put("iterationsCount", (long)explainComplexity.getIterationsCount());
        result.put("durationMs", explainComplexity.getEstimatedDurationMs());
        result.put("duration", explainComplexity.getEstimatedDurationString());
        result.put("queryCondition", this.queryCondition == null ? null : this.queryCondition.describeJson(session));
        if (this.isGrouped) {
            ArrayList<Map<String, Object>> groupedColumns = new ArrayList<Map<String, Object>>();
            for (i = this.indexLimitRowId; i < this.indexLimitRowId + this.groupByColumnCount; ++i) {
                int index = i;
                if (this.exprColumns[i].getType() == 5) {
                    index = this.exprColumns[i].columnIndex;
                }
                groupedColumns.add(this.exprColumns[index].describeJson(session));
            }
            result.put("groupColumns", groupedColumns);
        }
        if (this.havingCondition != null) {
            result.put("havingCondition", this.havingCondition.describeJson(session));
        }
        if (this.sortAndSlice.hasOrder()) {
            ArrayList<Map<String, Object>> orderBy = new ArrayList<Map<String, Object>>();
            for (i = 0; i < this.sortAndSlice.exprList.size(); ++i) {
                orderBy.add(((Expression)this.sortAndSlice.exprList.get(i)).describeJson(session));
            }
            result.put("orderBy", orderBy);
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                result.put("offset", this.sortAndSlice.limitCondition.getLeftNode().describeJson(session));
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                result.put("limit", this.sortAndSlice.limitCondition.getRightNode().describeJson(session));
            }
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        int i;
        String temp;
        int i2;
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        sb.append(b).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append(b).append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append(b).append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append(b).append("columns=[");
        for (i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            int index = i2;
            if (this.exprColumns[i2].getType() == 5) {
                index = this.exprColumns[i2].columnIndex;
            }
            sb.append(b).append(this.exprColumns[index].describe(session, 2));
            if (this.resultMetaData.columns[i2].getNullability() == 0) {
                sb.append(" not nullable");
                continue;
            }
            sb.append(" nullable");
        }
        sb.append("\n");
        sb.append(b).append("]\n");
        for (i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            sb.append(b).append("[");
            sb.append("range variable ").append(i2 + 1).append("\n");
            sb.append(this.rangeVariables[i2].describe(session, blanks + 2));
            sb.append(b).append("]");
        }
        sb.append(b).append("]\n");
        ExplainComplexity explainComplexity = new ExplainComplexity(this.rangeVariables, session.dataspaceStore);
        explainComplexity.init();
        sb.append("complexity=").append(explainComplexity.getComplexity()).append("\n");
        sb.append("iterations count=").append((long)explainComplexity.getIterationsCount()).append("\n");
        sb.append("durationMs=").append(explainComplexity.getEstimatedDurationMs()).append("\n");
        sb.append("duration=").append(explainComplexity.getEstimatedDurationString()).append("\n");
        String string = temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session, blanks);
        if (this.isGrouped) {
            sb.append(b).append("groupColumns=[");
            for (i = this.indexLimitRowId; i < this.indexLimitRowId + this.groupByColumnCount; ++i) {
                int index = i;
                if (this.exprColumns[i].getType() == 5) {
                    index = this.exprColumns[i].columnIndex;
                }
                sb.append(this.exprColumns[index].describe(session, blanks));
            }
            sb.append(b).append("]\n");
        }
        if (this.havingCondition != null) {
            temp = this.havingCondition.describe(session, blanks);
            sb.append(b).append("havingCondition=[").append(temp).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            sb.append(b).append("order by=[\n");
            for (i = 0; i < this.sortAndSlice.exprList.size(); ++i) {
                sb.append(b).append(((Expression)this.sortAndSlice.exprList.get(i)).describe(session, blanks));
            }
            sb.append(b).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                sb.append(b).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, 0)).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                sb.append(b).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, 0)).append("]\n");
            }
        }
        return sb.toString();
    }

    void setMergeability() {
        if (this.isGrouped || this.isDistinctSelect) {
            this.isMergeable = false;
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            this.isMergeable = false;
            return;
        }
        if (this.rangeVariables.length != 1) {
            this.isMergeable = false;
            return;
        }
    }

    void setUpdatability() {
        String name;
        Expression expression;
        int i;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (!this.isMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            return;
        }
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Table baseTable = table.getBaseTable();
        if (baseTable == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap columns = new IntValueHashMap();
        int[] baseColumnMap = table.getBaseTableColumnMap();
        int[] columnMap = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getObjectName()) || this.tempSet.contains(baseTable.getObjectName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            expression = this.exprColumns[i];
            if (expression.getType() == 2) {
                name = expression.getColumn().getObjectName().name;
                if (columns.containsKey(name)) {
                    columns.put(name, 1);
                    continue;
                }
                columns.put(name, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, expression);
            if (!this.tempSet.contains(table.getObjectName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (i = 0; i < this.indexLimitVisible; ++i) {
            if (this.accessibleColumns[i] && (expression = this.exprColumns[i]).getType() == 2 && columns.get(name = expression.getColumn().getObjectName().name) == 0) {
                int index = table.findColumn(name);
                columnMap[i] = baseColumnMap[index];
                if (columnMap[i] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            columnMap[i] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] checkList = baseTable.getColumnCheckList(columnMap);
            for (i = 0; i < checkList.length; ++i) {
                ColumnSchema column;
                if (checkList[i] || (column = baseTable.getColumn(i)).isIdentity() || column.isGenerated() || column.hasDefault() || column.isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = columnMap;
            this.baseTable = baseTable;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            if (!baseTable.isFileBased()) {
                ++this.indexLimitRowId;
                this.hasMemoryRow = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery() {
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Expression localQueryCondition = this.queryCondition;
        if (table instanceof TableDerived) {
            QueryExpression baseQueryExpression = ((TableDerived)table).getQueryExpression();
            if (baseQueryExpression == null || !baseQueryExpression.isMergeable) {
                this.isMergeable = false;
                return;
            }
            QuerySpecification baseSelect = baseQueryExpression.getMainSelect();
            if (baseSelect.rangeVariables.length != 1) {
                this.isMergeable = false;
                return;
            }
            if (baseQueryExpression.view == null) {
                this.rangeVariables[0] = baseSelect.rangeVariables[0];
                this.rangeVariables[0].resetConditions();
                Expression[] newExprColumns = new Expression[this.indexLimitData];
                for (int i = 0; i < this.indexLimitData; ++i) {
                    Expression e = this.exprColumns[i];
                    newExprColumns[i] = e.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
                }
                this.exprColumns = newExprColumns;
                if (localQueryCondition != null) {
                    localQueryCondition = localQueryCondition.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
                }
                Expression baseQueryCondition = baseSelect.queryCondition;
                this.checkQueryCondition = baseSelect.checkQueryCondition;
                this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
            } else {
                Expression e;
                int i;
                RangeVariable[] newRangeVariables = new RangeVariable[]{baseSelect.rangeVariables[0].duplicate()};
                newRangeVariables[0].rangePosition = this.rangeVariables[0].rangePosition;
                Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
                for (i = 0; i < baseSelect.indexLimitData; ++i) {
                    newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                    e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                for (i = 0; i < this.indexLimitData; ++i) {
                    e = this.exprColumns[i];
                    this.exprColumns[i] = e.replaceColumnReferences(rangeVar, newBaseExprColumns);
                }
                Expression baseQueryCondition = baseSelect.queryCondition;
                if (baseQueryCondition != null) {
                    baseQueryCondition = baseQueryCondition.duplicate();
                    baseQueryCondition.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                if (localQueryCondition != null) {
                    localQueryCondition = localQueryCondition.replaceColumnReferences(rangeVar, newBaseExprColumns);
                }
                this.checkQueryCondition = baseSelect.checkQueryCondition;
                if (this.checkQueryCondition != null) {
                    this.checkQueryCondition = this.checkQueryCondition.duplicate();
                    this.checkQueryCondition.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
                this.rangeVariables = newRangeVariables;
            }
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = localQueryCondition;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet set, Expression expression) {
        expression.collectAllExpressions(set, Expression.subqueryExpressionSet, Expression.emptyExpressionSet);
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            Expression e = (Expression)set.get(i);
            e.collectObjectNames(set);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int i;
        OrderedHashSet set = null;
        for (i = 0; i < this.indexLimitExpressions; ++i) {
            set = this.exprColumns[i].collectAllSubqueries(set);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllSubqueries(set);
        }
        if (this.havingCondition != null) {
            set = this.havingCondition.collectAllSubqueries(set);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            OrderedHashSet temp = this.rangeVariables[i].getSubqueries();
            set = OrderedHashSet.addAll(set, temp);
        }
        return set;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectAllSubqueries(OrderedHashSet set) {
        return set;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            set = this.exprColumns[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (this.havingCondition != null) {
            set = this.havingCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    @Override
    public void collectObjectNames(Set set) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectObjectNames(set);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            NameManager.ObjectName name = this.rangeVariables[i].getTable().getObjectName();
            set.add(name);
        }
    }

    @Override
    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].replaceColumnReferences(range, list);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceColumnReferences(range, list);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceColumnReferences(range, list);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].replaceRangeVariables(ranges, newRanges);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(ranges, newRanges);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceRangeVariables(ranges, newRanges);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            this.rangeVariables[i].getSubqueries();
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] names = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            names[i] = this.exprColumns[i].getAlias();
        }
        return names;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.columnTypes.length == this.indexLimitVisible) {
            return this.columnTypes;
        }
        Type[] types = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.columnTypes, types, types.length);
        return types;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    public void getBaseTableNames(OrderedHashSet set) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            NameManager.ObjectName name = rangeTable.getObjectName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            set.add(name);
        }
    }

    @Override
    public void getRangeVariables(OrderedHashSet set) {
        set.addAll(this.rangeVariables);
    }

    @Override
    boolean isEquivalent(QueryExpression other) {
        if (!(other instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification otherSpec = (QuerySpecification)other;
        if (!Expression.equals(this.exprColumns, otherSpec.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, otherSpec.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != otherSpec.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == otherSpec.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }

    public void setVtableParameter(NameManager.ObjectName table, String parameter, Expression expr) {
        Map<String, Expression> params = this.vTableParameters.get(table.getSchemaQualifiedStatementName());
        if (params == null) {
            params = new HashMap<String, Expression>();
            this.vTableParameters.put(table.getSchemaQualifiedStatementName(), params);
        }
        params.put(parameter, expr);
    }

    public void replaceExpressions(Map<Expression, Expression> replaceMap) {
        if (this.exprColumns != null) {
            for (int i = 0; i < this.exprColumns.length; ++i) {
                Expression value = replaceMap.get(this.exprColumns[i]);
                if (value != null) {
                    this.exprColumns[i] = value;
                    continue;
                }
                this.replaceInExpresion(this.exprColumns[i], replaceMap);
            }
        }
        if (this.queryCondition != null) {
            if (replaceMap.containsKey(this.queryCondition)) {
                this.queryCondition = replaceMap.get(this.queryCondition);
            } else {
                this.replaceInExpresion(this.queryCondition, replaceMap);
            }
        }
        for (RangeVariable rangeVar : this.rangeVariables) {
            if (rangeVar.getJoinCondition() == null) continue;
            if (replaceMap.containsKey(rangeVar.getJoinCondition())) {
                rangeVar.setJoinCondition(replaceMap.get(rangeVar.getJoinCondition()));
                continue;
            }
            this.replaceInExpresion(rangeVar.getJoinCondition(), replaceMap);
        }
        if (this.havingCondition != null) {
            if (replaceMap.containsKey(this.havingCondition)) {
                this.havingCondition = replaceMap.get(this.havingCondition);
            } else {
                this.replaceInExpresion(this.havingCondition, replaceMap);
            }
        }
        if (this.sortAndSlice != null && this.sortAndSlice.limitCondition != null && this.sortAndSlice.limitCondition.getLeftNode() != null) {
            if (replaceMap.containsKey(this.sortAndSlice.limitCondition.getLeftNode())) {
                this.sortAndSlice.limitCondition.setLeftNode(replaceMap.get(this.sortAndSlice.limitCondition.getLeftNode()));
            } else {
                this.replaceInExpresion(this.sortAndSlice.limitCondition.getLeftNode(), replaceMap);
            }
        }
    }

    private void replaceInExpresion(Expression expression, Map<Expression, Expression> replaceMap) {
        if (expression.nodes == null) {
            return;
        }
        for (int i = 0; i < expression.nodes.length; ++i) {
            Expression node = expression.nodes[i];
            if (node == null) continue;
            Expression value = replaceMap.get(node);
            if (value != null) {
                expression.nodes[i] = value;
                continue;
            }
            this.replaceInExpresion(node, replaceMap);
        }
    }

    @Override
    protected String getStatementForCardinalityError() {
        return this.getSQL();
    }
}

