/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.navigator.RowSetNavigatorDataTable;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryExpression {
    public static final int NOUNION = 0;
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT_ALL = 5;
    public static final int EXCEPT = 6;
    public static final int UNION_TERM = 7;
    int columnCount;
    private QueryExpression leftQueryExpression;
    private QueryExpression rightQueryExpression;
    public SortAndSlice sortAndSlice;
    private int unionType;
    private boolean unionCorresponding;
    private OrderedHashSet unionCorrespondingColumns;
    int[] unionColumnMap;
    Type[] unionColumnTypes;
    boolean isFullOrder;
    public HsqlList unresolvedExpressions;
    boolean isResolved;
    int persistenceScope = 21;
    protected ResultMetaData resultMetaData;
    boolean[] accessibleColumns;
    View view;
    boolean isMergeable;
    public boolean isUpdatable;
    boolean isInsertable;
    boolean isCheckable;
    boolean isTopLevel;
    boolean acceptsSequences;
    public TableBase resultTable;
    public Index mainIndex;
    public Index fullIndex;
    public Index orderIndex;
    public Index idIndex;
    public ParserDQL.CompileContext compileContext;
    private Collection selectIntoCollection = null;

    protected QueryExpression(ParserDQL.CompileContext compileContext) {
        this.compileContext = compileContext;
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QueryExpression(ParserDQL.CompileContext compileContext, QueryExpression leftQueryExpression) {
        this(compileContext);
        this.sortAndSlice = SortAndSlice.noSort;
        this.leftQueryExpression = leftQueryExpression;
    }

    public void addUnion(QueryExpression queryExpression, int unionType) {
        this.sortAndSlice = SortAndSlice.noSort;
        this.rightQueryExpression = queryExpression;
        this.unionType = unionType;
        this.setFullOrder();
    }

    public void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
        sortAndSlice.sortUnion = true;
    }

    public void setUnionCorresoponding() {
        this.unionCorresponding = true;
    }

    public void setUnionCorrespondingColumns(OrderedHashSet names) {
        this.unionCorrespondingColumns = names;
    }

    public void setFullOrder() {
        this.isFullOrder = true;
        if (this.leftQueryExpression == null) {
            if (this.isResolved) {
                ((QuerySpecification)this).createFullIndex(null);
            }
            return;
        }
        this.leftQueryExpression.setFullOrder();
        this.rightQueryExpression.setFullOrder();
    }

    public void resolve(Session session) {
        this.resolveReferences(session, RangeVariable.emptyArray);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypes(session);
    }

    public void resolve(Session session, RangeVariable[] outerRanges, Type[] targetTypes) {
        int i;
        this.resolveReferences(session, outerRanges);
        if (this.unresolvedExpressions != null) {
            for (i = 0; i < this.unresolvedExpressions.size(); ++i) {
                Expression e = (Expression)this.unresolvedExpressions.get(i);
                HsqlList list = e.resolveColumnReferences(session, outerRanges, null);
                ExpressionColumn.checkColumnsResolved(list);
            }
        }
        this.resolveTypesPartOne(session);
        if (targetTypes != null) {
            for (i = 0; i < this.unionColumnTypes.length && i < targetTypes.length; ++i) {
                if (this.unionColumnTypes[i] != null) continue;
                this.unionColumnTypes[i] = targetTypes[i];
            }
        }
        this.resolveTypesPartTwo(session);
    }

    public void resolveReferences(Session session, RangeVariable[] outerRanges) {
        this.leftQueryExpression.resolveReferences(session, outerRanges);
        this.rightQueryExpression.resolveReferences(session, outerRanges);
        this.addUnresolvedExpressions(this.leftQueryExpression.unresolvedExpressions);
        this.addUnresolvedExpressions(this.rightQueryExpression.unresolvedExpressions);
        if (!this.unionCorresponding) {
            this.columnCount = this.leftQueryExpression.getColumnCount();
            int rightCount = this.rightQueryExpression.getColumnCount();
            if (this.columnCount != rightCount) {
                throw Error.error(5594);
            }
            this.unionColumnTypes = new Type[this.columnCount];
            this.leftQueryExpression.unionColumnMap = this.rightQueryExpression.unionColumnMap = new int[this.columnCount];
            ArrayUtil.fillSequence(this.leftQueryExpression.unionColumnMap);
            this.resolveColumnRefernecesInUnionOrderBy();
            this.accessibleColumns = this.leftQueryExpression.accessibleColumns;
            return;
        }
        Object[] leftNames = this.leftQueryExpression.getColumnNames();
        Object[] rightNames = this.rightQueryExpression.getColumnNames();
        if (this.unionCorrespondingColumns == null) {
            this.unionCorrespondingColumns = new OrderedHashSet();
            OrderedIntHashSet leftColumns = new OrderedIntHashSet();
            OrderedIntHashSet rightColumns = new OrderedIntHashSet();
            for (int i = 0; i < leftNames.length; ++i) {
                String name = leftNames[i];
                int index = ArrayUtil.find(rightNames, name);
                if (name.length() <= 0 || index == -1) continue;
                if (!this.leftQueryExpression.accessibleColumns[i]) {
                    throw Error.error(5578);
                }
                if (!this.rightQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                leftColumns.add(i);
                rightColumns.add(index);
                this.unionCorrespondingColumns.add(name);
            }
            if (this.unionCorrespondingColumns.isEmpty()) {
                throw Error.error(5578);
            }
            this.leftQueryExpression.unionColumnMap = leftColumns.toArray();
            this.rightQueryExpression.unionColumnMap = rightColumns.toArray();
        } else {
            this.leftQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            this.rightQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            for (int i = 0; i < this.unionCorrespondingColumns.size(); ++i) {
                String name = (String)this.unionCorrespondingColumns.get(i);
                int index = ArrayUtil.find(leftNames, name);
                if (index == -1) {
                    throw Error.error(5501);
                }
                if (!this.leftQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                this.leftQueryExpression.unionColumnMap[i] = index;
                index = ArrayUtil.find(rightNames, name);
                if (index == -1) {
                    throw Error.error(5501);
                }
                if (!this.rightQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                this.rightQueryExpression.unionColumnMap[i] = index;
            }
        }
        this.columnCount = this.unionCorrespondingColumns.size();
        this.unionColumnTypes = new Type[this.columnCount];
        this.resolveColumnRefernecesInUnionOrderBy();
        this.accessibleColumns = new boolean[this.columnCount];
        ArrayUtil.fillArray(this.accessibleColumns, true);
    }

    void resolveColumnRefernecesInUnionOrderBy() {
        int orderCount = this.sortAndSlice.getOrderLength();
        if (orderCount == 0) {
            return;
        }
        Object[] unionColumnNames = this.getColumnNames();
        for (int i = 0; i < orderCount; ++i) {
            int index;
            Expression sort = (Expression)this.sortAndSlice.exprList.get(i);
            Expression e = sort.getLeftNode();
            if (e.getType() == 1) {
                if (e.getDataType().typeCode == 4 && 0 < (index = ((Integer)e.getValue(null)).intValue()) && index <= unionColumnNames.length) {
                    sort.getLeftNode().queryTableColumnIndex = index - 1;
                    continue;
                }
            } else if (e.getType() == 2 && (index = ArrayUtil.find(unionColumnNames, e.getColumnName())) >= 0) {
                sort.getLeftNode().queryTableColumnIndex = index;
                continue;
            }
            throw Error.error(5576);
        }
        this.sortAndSlice.prepare(null);
    }

    private void addUnresolvedExpressions(HsqlList expressions) {
        if (expressions == null) {
            return;
        }
        if (this.unresolvedExpressions == null) {
            this.unresolvedExpressions = new ArrayListIdentity();
        }
        this.unresolvedExpressions.addAll(expressions);
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.isResolved = true;
    }

    void resolveTypesPartOne(Session session) {
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
    }

    void resolveTypesPartTwo(Session session) {
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartTwo(session);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartTwo(session);
        ResultMetaData leftMeta = this.leftQueryExpression.getMetaData();
        ResultMetaData rightMeta = this.rightQueryExpression.getMetaData();
        for (int i = 0; i < this.leftQueryExpression.unionColumnMap.length; ++i) {
            int leftIndex = this.leftQueryExpression.unionColumnMap[i];
            int rightIndex = this.rightQueryExpression.unionColumnMap[i];
            ColumnBase column = leftMeta.columns[leftIndex];
            byte leftNullability = leftMeta.columns[leftIndex].getNullability();
            byte rightNullability = rightMeta.columns[rightIndex].getNullability();
            if (column instanceof ColumnSchema && rightMeta.columns[rightIndex] instanceof ColumnBase) {
                column = new ColumnBase();
                column.setType(this.leftQueryExpression.unionColumnTypes[i]);
                column.setNullability(leftNullability);
                leftMeta.columns[leftIndex] = column;
            }
            if (rightNullability != 1 && (rightNullability != 2 || leftNullability != 0)) continue;
            if (column instanceof ColumnSchema) {
                column = new ColumnBase();
                column.setType(this.leftQueryExpression.unionColumnTypes[i]);
                leftMeta.columns[leftIndex] = column;
            }
            column.setNullability(rightNullability);
        }
        if (this.unionCorresponding) {
            this.resultMetaData = this.leftQueryExpression.getMetaData().getNewMetaData(this.leftQueryExpression.unionColumnMap);
            this.createTable(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            QueryExpression queryExpression = this;
            while (true) {
                if (queryExpression.leftQueryExpression == null || queryExpression.unionCorresponding) {
                    this.sortAndSlice.setIndex(session, queryExpression.resultTable);
                    break;
                }
                queryExpression = queryExpression.leftQueryExpression;
            }
        }
    }

    public Object[] getValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return new Object[r.metaData.getColumnCount()];
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201, new Object[]{this.getStatementForCardinalityError()});
    }

    protected String getStatementForCardinalityError() {
        return "n/a";
    }

    public Object[] getSingleRowValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201, new Object[]{this.getStatementForCardinalityError()});
    }

    public Object getValue(Session session) {
        Object[] values = this.getValues(session);
        return values[0];
    }

    public Result getResult(Session session, int maxRows) {
        int currentMaxRows = this.unionType == 2 ? maxRows : 0;
        Result first = this.leftQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData navigator = (RowSetNavigatorData)first.getNavigator();
        Result second = this.rightQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData rightNavigator = (RowSetNavigatorData)second.getNavigator();
        if (this.unionCorresponding) {
            boolean memory = session.getResultMemoryRowCount() == 0 || navigator.getSize() < session.getResultMemoryRowCount() && rightNavigator.getSize() < session.getResultMemoryRowCount();
            RowSetNavigatorData rowSet = memory ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSet.copy(navigator, this.leftQueryExpression.unionColumnMap);
            navigator.release();
            navigator = rowSet;
            first.setNavigator(navigator);
            first.metaData = this.getMetaData();
            rowSet = memory ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSet.copy(rightNavigator, this.rightQueryExpression.unionColumnMap);
            rightNavigator.release();
            rightNavigator = rowSet;
        }
        switch (this.unionType) {
            case 1: {
                navigator.union(session, rightNavigator);
                break;
            }
            case 2: {
                navigator.unionAll(session, rightNavigator);
                break;
            }
            case 3: {
                navigator.intersect(session, rightNavigator);
                break;
            }
            case 4: {
                navigator.intersectAll(session, rightNavigator);
                break;
            }
            case 6: {
                navigator.except(session, rightNavigator);
                break;
            }
            case 5: {
                navigator.exceptAll(session, rightNavigator);
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        if (this.sortAndSlice.hasOrder()) {
            navigator.sortOrderUnion(session, this.sortAndSlice);
        }
        if (this.sortAndSlice.hasLimit()) {
            int[] limits = this.sortAndSlice.getLimits(session, this, maxRows);
            navigator.trim(limits[0], limits[1]);
        }
        navigator.reset();
        return first;
    }

    Result getResultRecursive(Session session, TableDerived table) {
        Result tempResult;
        RowSetNavigatorData tempNavigator;
        RowSetNavigatorData rowSet = new RowSetNavigatorData(session, this);
        Result result = Result.newResult(rowSet);
        rowSet.copy(table.getSubQuery().getNavigator(session), this.unionColumnMap);
        result.metaData = this.resultMetaData;
        int round = 0;
        while (!(tempNavigator = (RowSetNavigatorData)(tempResult = this.rightQueryExpression.getResult(session, 0)).getNavigator()).isEmpty()) {
            switch (this.unionType) {
                case 1: {
                    rowSet.union(session, tempNavigator);
                    break;
                }
                case 2: {
                    rowSet.unionAll(session, tempNavigator);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "QueryExpression");
                }
            }
            table.clearAllData(session);
            tempNavigator.reset();
            table.insertIntoTable(session, tempResult);
            if (round > 256) {
                throw Error.error(458);
            }
            ++round;
        }
        table.clearAllData(session);
        rowSet.reset();
        return result;
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet subqueries = this.leftQueryExpression.getSubqueries();
        return OrderedHashSet.addAll(subqueries, this.rightQueryExpression.getSubqueries());
    }

    public boolean isSingleColumn() {
        return this.leftQueryExpression.isSingleColumn();
    }

    public ResultMetaData getMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        return this.leftQueryExpression.getMetaData();
    }

    public QuerySpecification getMainSelect() {
        if (this.leftQueryExpression == null) {
            return (QuerySpecification)this;
        }
        return this.leftQueryExpression.getMainSelect();
    }

    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String joinName = null;
        switch (this.unionType) {
            case 1: {
                joinName = "UNION";
                break;
            }
            case 2: {
                joinName = "UNION ALL";
                break;
            }
            case 3: {
                joinName = "INTERSECT";
                break;
            }
            case 4: {
                joinName = "INTERSECT ALL";
                break;
            }
            case 6: {
                joinName = "EXCEPT";
                break;
            }
            case 5: {
                joinName = "EXCEPT ALL";
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        result.put("joinName", joinName);
        result.put("leftQuery", this.leftQueryExpression.describeJson(session));
        result.put("rightQuery", this.rightQueryExpression.describeJson(session));
        return result;
    }

    public String describe(Session session, int blanks) {
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        sb.append(b).append(switch (this.unionType) {
            case 1 -> "UNION";
            case 2 -> "UNION ALL";
            case 3 -> "INTERSECT";
            case 4 -> "INTERSECT ALL";
            case 6 -> "EXCEPT";
            case 5 -> "EXCEPT ALL";
            default -> throw Error.runtimeError(201, "QueryExpression");
        }).append("\n");
        sb.append(b).append("Left Query=[\n");
        sb.append(b).append(this.leftQueryExpression.describe(session, blanks + 2));
        sb.append(b).append("]\n");
        sb.append(b).append("Right Query=[\n");
        sb.append(b).append(this.rightQueryExpression.describe(session, blanks + 2));
        sb.append(b).append("]\n");
        return sb.toString();
    }

    public HsqlList getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    String[] getColumnNames() {
        if (this.unionCorrespondingColumns == null) {
            return this.leftQueryExpression.getColumnNames();
        }
        Object[] names = new String[this.unionCorrespondingColumns.size()];
        this.unionCorrespondingColumns.toArray(names);
        return names;
    }

    public Type[] getColumnTypes() {
        return this.unionColumnTypes;
    }

    public int getColumnCount() {
        if (this.unionCorrespondingColumns == null) {
            int right;
            int left = this.leftQueryExpression.getColumnCount();
            if (left != (right = this.rightQueryExpression.getColumnCount())) {
                throw Error.error(5594);
            }
            return left;
        }
        return this.unionCorrespondingColumns.size();
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        set = this.leftQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        if (this.rightQueryExpression != null) {
            set = this.rightQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    public void collectObjectNames(Set set) {
        this.leftQueryExpression.collectObjectNames(set);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectObjectNames(set);
        }
    }

    public HashMappedList getColumns() {
        this.getResultTable();
        return ((TableDerived)this.getResultTable()).columnList;
    }

    public void setView(View view) {
        this.isUpdatable = true;
        this.view = view;
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    public void setTableColumnNames(HashMappedList list) {
        if (this.resultTable != null) {
            ((TableDerived)this.resultTable).columnList = list;
            return;
        }
        this.leftQueryExpression.setTableColumnNames(list);
    }

    public void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        int[] fullCols = new int[this.columnCount];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(null, fullCols, null, null, false, false, false, null);
    }

    void createResultTable(Session session) {
        NameManager.ObjectName tableName = session.dataspaceStore.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 21 ? 2 : 10;
        HashMappedList columnList = this.leftQueryExpression.getUnionColumns();
        try {
            this.resultTable = new TableDerived(session.dataspaceStore, tableName, tableType, this.unionColumnTypes, columnList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColumnsDefined() {
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setColumnsDefined();
        }
    }

    public void setReturningResult() {
        if (this.compileContext.getSequences().length > 0) {
            throw Error.error(5598);
        }
        this.isTopLevel = true;
        this.setReturningResultSet();
    }

    void setReturningResultSet() {
        if (this.unionCorresponding) {
            this.persistenceScope = 23;
            return;
        }
        this.leftQueryExpression.setReturningResultSet();
    }

    private HashMappedList getUnionColumns() {
        if (this.unionCorresponding || this.leftQueryExpression == null) {
            HashMappedList columns = ((TableDerived)this.resultTable).columnList;
            HashMappedList list = new HashMappedList();
            for (int i = 0; i < this.unionColumnMap.length; ++i) {
                ColumnSchema column = (ColumnSchema)columns.get(this.unionColumnMap[i]);
                list.add(column.getObjectName().name, column);
            }
            return list;
        }
        return this.leftQueryExpression.getUnionColumns();
    }

    public NameManager.ObjectName[] getResultColumnNames() {
        if (this.resultTable == null) {
            return this.leftQueryExpression.getResultColumnNames();
        }
        HashMappedList list = ((TableDerived)this.resultTable).columnList;
        NameManager.ObjectName[] resultColumnNames = new NameManager.ObjectName[list.size()];
        for (int i = 0; i < resultColumnNames.length; ++i) {
            resultColumnNames[i] = ((ColumnSchema)list.get(i)).getObjectName();
        }
        return resultColumnNames;
    }

    public TableBase getResultTable() {
        if (this.resultTable != null) {
            return this.resultTable;
        }
        if (this.leftQueryExpression != null) {
            return this.leftQueryExpression.getResultTable();
        }
        return null;
    }

    public Table getBaseTable() {
        return null;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public int[] getBaseTableColumnMap() {
        return null;
    }

    public Expression getCheckCondition() {
        return null;
    }

    public boolean hasReference(RangeVariable range) {
        if (this.leftQueryExpression.hasReference(range)) {
            return true;
        }
        return this.rightQueryExpression.hasReference(range);
    }

    public void getBaseTableNames(OrderedHashSet set) {
        this.leftQueryExpression.getBaseTableNames(set);
        this.rightQueryExpression.getBaseTableNames(set);
    }

    public void getRangeVariables(OrderedHashSet set) {
        this.leftQueryExpression.getRangeVariables(set);
        this.rightQueryExpression.getRangeVariables(set);
    }

    boolean isEquivalent(QueryExpression other) {
        return this.leftQueryExpression.isEquivalent(other.leftQueryExpression) && this.unionType == other.unionType && (this.rightQueryExpression == null ? other.rightQueryExpression == null : this.rightQueryExpression.isEquivalent(other.rightQueryExpression));
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        this.leftQueryExpression.replaceColumnReference(range, list);
        this.rightQueryExpression.replaceColumnReference(range, list);
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        this.leftQueryExpression.replaceRangeVariables(ranges, newRanges);
        this.rightQueryExpression.replaceRangeVariables(ranges, newRanges);
    }

    public void setSelectIntoCollection(Collection collection) {
        this.selectIntoCollection = collection;
    }

    public Collection getSelectIntoCollection() {
        return this.selectIntoCollection;
    }

    public QueryExpression getLeftQueryExpression() {
        return this.leftQueryExpression;
    }

    public QueryExpression getRightQueryExpression() {
        return this.rightQueryExpression;
    }

    public Collection findSelectIntoCollection() {
        Collection result = this.getSelectIntoCollection();
        if (result == null && this.leftQueryExpression != null) {
            result = this.leftQueryExpression.findSelectIntoCollection();
        }
        if (result == null && this.rightQueryExpression != null) {
            result = this.rightQueryExpression.findSelectIntoCollection();
        }
        return result;
    }
}

