/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.persist.fulltext.FullTextSearchResult;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.util.List;
import java.util.Map;

public class FindTextExpression
extends Expression {
    private final String queryString;
    private final Map<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>> tableColumnsMap;
    private final List<FullTextIndex> indexList;
    private final FullTextQuery.ReturnType returnType;
    private final List<FullTextTuple> returnColumns;
    private final FullTextQuery.SearchType searchType;
    private final FullTextQuery.OrderType orderType;
    private final boolean enableTfFactor;
    private final boolean enableIdfFactor;
    private final boolean enableLengthNormFactor;
    private final int top;

    public FindTextExpression(String queryString, Map<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>> tableColumnsMap, List<FullTextIndex> indexList, FullTextQuery.ReturnType returnType, List<FullTextTuple> returnColumns, FullTextQuery.SearchType searchType, FullTextQuery.OrderType orderType, boolean enableTfFactor, boolean enableIdfFactor, boolean enableLengthNormFactor, int top) {
        super(1);
        this.queryString = queryString;
        this.tableColumnsMap = tableColumnsMap;
        this.indexList = indexList;
        this.returnType = returnType;
        this.returnColumns = returnColumns;
        this.searchType = searchType;
        this.orderType = orderType;
        this.enableTfFactor = enableTfFactor;
        this.enableIdfFactor = enableIdfFactor;
        this.enableLengthNormFactor = enableLengthNormFactor;
        this.top = top;
    }

    private FullTextSearchResult getSearchResult(Session session) {
        FullTextQuery query = new FullTextQuery(this.queryString, this.tableColumnsMap, this.indexList, this.returnType, this.returnColumns, this.searchType, this.orderType, this.enableTfFactor, this.enableIdfFactor, this.enableLengthNormFactor, this.top);
        return session.dataspaceStore.getFullTextManager().search(query, session);
    }

    @Override
    public Object getValue(Session session) {
        try {
            return this.getSearchResult(session).toRowSet();
        }
        catch (Exception e) {
            throw new DataspaceException(e.getMessage(), e);
        }
    }

    public Result getResultValue(Session session) {
        try {
            return this.getSearchResult(session).toResult();
        }
        catch (Exception e) {
            throw new DataspaceException(e.getMessage(), e);
        }
    }
}

