/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import java.util.Arrays;
import java.util.Comparator;

public class FacetAspectJoinUtils {
    public static Comparator<Object> createValuesComparator(MatchOn matchOn) {
        switch (matchOn.ordinal()) {
            case 1: {
                return Comparator.comparing(String::valueOf);
            }
            case 2: {
                return (left, right) -> {
                    Double leftNumber = FacetAspectJoinUtils.parserDouble(left);
                    Double rightNumber = FacetAspectJoinUtils.parserDouble(right);
                    if (leftNumber != null && rightNumber != null) {
                        return leftNumber >= rightNumber ? 0 : -1;
                    }
                    if (leftNumber == null) {
                        return -1;
                    }
                    if (rightNumber == null) {
                        return 0;
                    }
                    return FacetAspectJoinUtils.parserString(left).compareTo(FacetAspectJoinUtils.parserString(right)) >= 0 ? 0 : -1;
                };
            }
            case 3: {
                return (left, right) -> {
                    Double leftNumber = FacetAspectJoinUtils.parserDouble(left);
                    Double rightNumber = FacetAspectJoinUtils.parserDouble(right);
                    if (leftNumber != null && rightNumber != null) {
                        return leftNumber <= rightNumber ? 0 : -1;
                    }
                    if (leftNumber == null) {
                        return 0;
                    }
                    if (rightNumber == null) {
                        return -1;
                    }
                    return FacetAspectJoinUtils.parserString(left).compareTo(FacetAspectJoinUtils.parserString(right)) <= 0 ? 0 : -1;
                };
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (left, right) -> {
                    String leftString = FacetAspectJoinUtils.parserString(left);
                    String rightString = FacetAspectJoinUtils.parserString(right);
                    String leftFirstWord = Arrays.stream(leftString.split(" ")).findFirst().orElse("");
                    switch (matchOn.ordinal()) {
                        case 4: {
                            return rightString.startsWith(leftFirstWord) ? 0 : -1;
                        }
                        case 5: {
                            return rightString.endsWith(leftFirstWord) ? 0 : -1;
                        }
                        case 6: {
                            return rightString.contains(leftFirstWord) ? 0 : -1;
                        }
                        case 7: {
                            return rightString.contains(leftFirstWord) ? 0 : -1;
                        }
                    }
                    return -1;
                };
            }
        }
        throw new DataspaceException("Invalid match on for comparator: " + String.valueOf((Object)matchOn));
    }

    public static Double parserDouble(Object s) {
        if (s == null) {
            return null;
        }
        if (s instanceof Number) {
            return ((Number)s).doubleValue();
        }
        try {
            return Double.valueOf(String.valueOf(s));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String parserString(Object o) {
        return String.valueOf(o);
    }

    public static boolean compareFacetValues(Object left, Object right) {
        return FacetAspectJoinUtils.parserString(left).equals(FacetAspectJoinUtils.parserString(right));
    }

    public static enum MatchOn {
        KEYS("keys"),
        VALUES("values"),
        VALUES_GT("gt values"),
        VALUES_LT("lt values"),
        VALUES_STARTS_WITH("starts with values"),
        VALUES_ENDS_WITH("ends with values"),
        VALUES_CONTAINS("contains values"),
        VALUES_SOUNDEX("soundex values");

        private String syntax;

        private MatchOn(String syntax) {
            this.syntax = syntax;
        }

        public String getSyntax() {
            return this.syntax;
        }

        public static MatchOn parse(String sql) {
            for (MatchOn value : MatchOn.values()) {
                if (!sql.startsWith(value.syntax)) continue;
                return value;
            }
            throw new RuntimeException("Invalid MatchOn syntax: " + sql);
        }
    }

    public static enum MatchLevel {
        ALL,
        ANY,
        DEGREE,
        NONE,
        EQ;

    }
}

