/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.StatementSet;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.server.QueryableServer;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.slex.SLSessionData;
import java.util.List;

public class ExternalExecutionExpression
extends Expression {
    private ExecutionStatement executionStatement;
    private QueryableServer serverObject;
    private StatementSet parentSetStatement;

    public ExternalExecutionExpression(ExecutionStatement executionStatement, QueryableServer serverObject) {
        super(1);
        this.executionStatement = executionStatement;
        this.serverObject = serverObject;
    }

    public void setParentSetStatement(StatementSet parentSetStatement) {
        this.parentSetStatement = parentSetStatement;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        List<Object> expressions = this.executionStatement.getExternalExpressions();
        for (Object expression : expressions) {
            unresolvedSet = ((Expression)expression).resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        List<Object> expressions = this.executionStatement.getExternalExpressions();
        for (Object expression : expressions) {
            ((Expression)expression).resolveTypes(session, parent);
        }
        Class<?> clazz = this.executionStatement.resolveType(new ExternalExecutionContextImpl(session, this.serverObject));
        this.dataType = Types.getParameterSQLType(session, clazz);
        if (this.dataType == null) {
            this.dataType = Types.getParameterSQLType(session, Object.class);
        }
    }

    @Override
    public Object getValue(Session session) {
        if (!((ServerObject)((Object)this.serverObject)).isRunning()) {
            throw new DataspaceException("Server is not running.");
        }
        Class<?> targetClass = null;
        if (this.parentSetStatement instanceof StatementSet && this.parentSetStatement.targets != null && this.parentSetStatement.targets.length == 1) {
            Expression target = this.parentSetStatement.targets[0];
            if (target.dataType != null) {
                targetClass = target.dataType.getInternalClass(session);
            }
        }
        try {
            return this.executionStatement.execute(new ExternalExecutionContextImpl(session, this.serverObject), targetClass);
        }
        catch (Exception exception) {
            throw new DataspaceException(exception);
        }
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append(((ServerObject)((Object)this.serverObject)).getObjectName().name).append(".query(").append(this.executionStatement.toString()).append(")");
        return builder.toString();
    }

    @Override
    public void collectObjectNames(Set set) {
        super.collectObjectNames(set);
        set.add(((ServerObject)((Object)this.serverObject)).getObjectName());
    }

    public static class ExternalExecutionContextImpl
    implements ExternalExecutionContext {
        private Session session;
        private QueryableServer serverObject;

        public ExternalExecutionContextImpl(Session session, QueryableServer serverObject) {
            this.session = session;
            this.serverObject = serverObject;
        }

        @Override
        public Class<?> resolveType(Object expression) {
            Type type = ((Expression)expression).getDataType();
            if (type != null) {
                return type.getInternalClass(this.session);
            }
            return Object.class;
        }

        @Override
        public Object getCallable() {
            return this.serverObject.getConnectionService();
        }

        @Override
        public Object getValue(Object expression) {
            Object result = ((Expression)expression).getValue(this.session);
            if (result instanceof OtherTypeWrapper) {
                result = ((OtherTypeWrapper)result).getObject();
            }
            return result;
        }

        @Override
        public ClassLoader getClassLoader() {
            DataspaceSchema schema = this.session.dataspaceStore.schemaManager.findSchema(this.session.getSchemaName(null));
            return schema == null ? null : schema.getPackageManifestManager().getManifestClassLoader();
        }

        @Override
        public int getFetchSize() {
            return this.session.getFetchSize();
        }

        @Override
        public SLSessionData getSLSessionData() {
            return this.session.getSLSessionData();
        }
    }
}

