/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class ExpressionValueProducer
extends Expression {
    private final Function<Session, Object> valueProducer;
    private final String valueProducerName;
    private final boolean nullable;

    public ExpressionValueProducer(Function<Session, Object> valueProducer, String valueProducerName, Type datatype, boolean nullable) {
        super(1);
        this.valueProducer = valueProducer;
        this.valueProducerName = valueProducerName;
        this.nullable = nullable;
        this.nodes = Expression.emptyArray;
        this.dataType = datatype;
    }

    @Override
    public byte getNullability() {
        return this.nullable ? (byte)1 : 0;
    }

    @Override
    public String getSQL() {
        return this.valueProducerName;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("value", this.valueProducerName);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionValue");
            }
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueProducerName).append("\n");
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Object getValue(Session session, Type type) {
        return type.convertToType(session, this.getValue(session), this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        return this.valueProducer.apply(session);
    }

    @Override
    public void setDataType(Session session, Type type) {
        this.dataType = type;
    }

    @Override
    public boolean equals(Expression other) {
        return other instanceof ExpressionValueProducer && other.dataType == this.dataType;
    }
}

