/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionValue
extends Expression {
    public ExpressionValue(Object o, Type datatype) {
        super(1);
        this.nodes = Expression.emptyArray;
        this.dataType = datatype;
        this.valueData = o;
    }

    @Override
    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.valueData instanceof OtherTypeWrapper && ((OtherTypeWrapper)this.valueData).getObject() instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)((OtherTypeWrapper)this.valueData).getObject();
                    return arrayType.getSQL();
                }
                try {
                    if (OtherTypeWrapper.unwrap(this.valueData) instanceof OtherType) {
                        return ((OtherType)OtherTypeWrapper.unwrap(this.valueData)).getTypeDefinition();
                    }
                    return this.dataType.convertToSQLString(this.valueData);
                }
                catch (Throwable error) {
                    return "VALUE";
                }
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("value", this.valueData);
                result.put("type", this.dataType.getNameString());
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionValue");
            }
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }
}

