/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionUnfold
extends Expression {
    private List<String> facetsColumnNames;

    public ExpressionUnfold(Expression expression, List<String> facetsColumnNames) {
        super(26);
        this.facetsColumnNames = facetsColumnNames;
        this.nodes = new Expression[]{expression};
    }

    @Override
    public Object getValue(Session session) {
        return OtherTypeWrapper.unwrap(this.nodes[0].getValue(session));
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("UNFOLD").append("(").append(this.nodes[0].getSQL());
        for (String column : this.facetsColumnNames) {
            builder.append(", ").append(NameManager.quoteNameIfNeeded(column));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "UNFOLD");
        result.put("facets", this.nodes[0].describeJson(session));
        result.put("facetsColumnNames", new ArrayList<String>(this.facetsColumnNames));
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder(64);
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("UNFOLD");
        builder.append(" facets=[");
        builder.append(this.nodes[0].describe(session, blanks + 1));
        for (String column : this.facetsColumnNames) {
            builder.append(", ").append(NameManager.quoteNameIfNeeded(column));
        }
        builder.append(']');
        return builder.toString();
    }

    public List<String> getFacetsColumnNames() {
        return this.facetsColumnNames;
    }
}

