/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.RowType;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    public ExpressionTable(Expression[] e, SubQuery sq, boolean ordinality) {
        super(30);
        this.nodes = e;
        this.subQuery = sq;
        this.ordinality = ordinality;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.isTable) {
            result.put("opType", "TABLE");
        } else {
            result.put("opType", "UNNEST");
        }
        result.put("node", this.describeJson(session));
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        if (this.isTable) {
            sb.append("TABLE").append(' ');
        } else {
            sb.append("UNNEST").append(' ');
        }
        sb.append(this.nodes[0].describe(session, blanks));
        return sb.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes.length == 1 && this.nodes[0].dataType.isRowType()) {
            if (this.ordinality) {
                throw Error.error(5581, "ORDINALITY");
            }
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.subQuery.prepareTable(session);
            this.subQuery.getTable().columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
            this.isTable = true;
            return;
        }
        Type[] resolvedTypes = new Type[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            resolvedTypes[i] = this.nodes[i].dataType;
            if (!resolvedTypes[i].isArrayType() && !resolvedTypes[i].isCollectionType() && this.nodes[i] instanceof ExpressionColumn && ((ExpressionColumn)this.nodes[i]).getSpath() != null) {
                resolvedTypes[i] = (Type)ExpressionColumn.resolveColumnDataTypeInternalStatic(session, ((ExpressionColumn)this.nodes[i]).getSpath(), this.nodes[i].getColumn())[0];
            }
            if (resolvedTypes[i] != null && (resolvedTypes[i].isArrayType() || resolvedTypes[i].isCollectionType())) continue;
            throw Error.error(5563, "UNNEST");
        }
        int columnCount = this.ordinality ? this.nodes.length + 1 : this.nodes.length;
        this.nodeDataTypes = new Type[columnCount];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodeDataTypes[i] = resolvedTypes[i].collectionBaseType();
            if (this.nodeDataTypes[i] == null || resolvedTypes[i].isCollectionType()) {
                this.nodeDataTypes[i] = new OtherType();
            }
            if (this.nodeDataTypes[i] != null && this.nodeDataTypes[i] != Type.SQL_ALL_TYPES) continue;
            throw Error.error(5567, "UNNEST");
        }
        if (this.ordinality) {
            this.nodeDataTypes[this.nodes.length] = Type.SQL_INTEGER;
        }
        this.subQuery.prepareTable(session);
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData navigator = this.subQuery.getNavigator(session);
                Result result = Result.newResult(navigator);
                result.metaData = this.subQuery.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] value = this.subQuery.getValues(session);
                if (value.length == 1) {
                    return value[0];
                }
                return value;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        if (this.isTable) {
            this.insertTableValues(session, store);
        } else {
            this.insertArrayValues(session, store);
        }
    }

    private void insertTableValues(Session session, PersistentStore store) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator nav = result.navigator;
        int size = nav.getSize();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
            }
            catch (DataspaceException dataspaceException) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore store) {
        Object[] data;
        int i;
        Object[][] array = new Object[this.nodes.length][];
        for (i = 0; i < array.length; ++i) {
            Object elements = OtherTypeWrapper.unwrap(this.nodes[i].getValue(session));
            Object[] objectArray = data = this.nodeDataTypes[i] instanceof OtherType || elements == null || !elements.getClass().isArray() ? (Object[])new ArrayType(new OtherType(), -1).convertToType(session, elements, new OtherType()) : (Object[])elements;
            if (data == null) {
                data = ValuePool.emptyObjectArray;
            }
            array[i] = data;
        }
        i = 0;
        while (true) {
            boolean isRow = false;
            data = new Object[this.nodeDataTypes.length];
            for (int arrayIndex = 0; arrayIndex < array.length; ++arrayIndex) {
                if (i >= array[arrayIndex].length) continue;
                data[arrayIndex] = array[arrayIndex][i];
                isRow = true;
            }
            if (!isRow) break;
            if (this.ordinality) {
                data[this.nodes.length] = ValuePool.getInt(i + 1);
            }
            Row row = (Row)store.getNewCachedObject(session, data, false);
            store.indexRow(session, row);
            ++i;
        }
    }
}

