/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.dataspace.DataspaceManager;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionSpathAccessor
extends Expression {
    private String spath = null;

    public ExpressionSpathAccessor(Expression left) {
        super(113);
        this.nodes = new Expression[]{left};
    }

    public void setSpath(String spath) {
        this.spath = spath;
    }

    @Override
    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        block8: {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
            if (this.nodes[0].dataType == null) {
                throw Error.error(5567);
            }
            this.dataType = this.nodes[0].getDataType();
            if (this.dataType instanceof OtherType && ((OtherType)this.dataType).userTypeModifier != null) {
                try {
                    String semanticType = this.dataType.getObjectName().name;
                    String className = session.sessionContext.typeAnalyzer.getSemanticTypeCache().resolveSemanticType(semanticType);
                    Class objectClass = ClassUtils.loadClass(className, DataspaceManager.getContext().getSystemClassLoaderChain());
                    String elementClassName = session.sessionContext.typeAnalyzer.getFieldTypeAsString(objectClass, "/" + this.spath);
                    this.dataType = Types.getParameterSQLType(session, elementClassName);
                    if (this.dataType != null) break block8;
                    Class elementClass = ClassUtils.loadClass(elementClassName, DataspaceManager.getContext().getSystemClassLoaderChain());
                    if (elementClass.isArray() && elementClass.getComponentType() != Byte.TYPE && elementClass.getComponentType() != Byte.class) {
                        Type elementType = Types.getParameterSQLType(session, elementClass.getComponentType());
                        this.dataType = new ArrayType(elementType, Integer.MAX_VALUE);
                        break block8;
                    }
                    this.dataType = Types.getParameterSQLType(session, elementClass);
                }
                catch (Exception error) {
                    if (this.dataType == null) {
                        this.dataType = Type.OTHER;
                    }
                    break block8;
                }
            }
            if (!session.isCompleteMode()) {
                this.dataType = new OtherType();
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        Object value = this.nodes[0].getValue(session);
        if (value == null) {
            return null;
        }
        value = OtherTypeWrapper.unwrap(value);
        try {
            if (this.spath != null) {
                if (this.spath.equals("/length")) {
                    return ExpressionColumn.getLength(session, value);
                }
                if (this.spath.endsWith("/length")) {
                    int dotIndex = this.spath.lastIndexOf(47);
                    try {
                        value = session.sessionContext.sdrManager.getValueAtPath("/" + this.spath.substring(0, dotIndex), value);
                        return ExpressionColumn.getLength(session, value);
                    }
                    catch (Exception error) {
                        throw new DataspaceException(error.getMessage());
                    }
                }
                value = session.sessionContext.sdrManager.getValueAtPath("/" + this.spath, value);
            }
        }
        catch (Exception error) {
            Trace.logError(this, error.getMessage());
        }
        if (this.dataType instanceof OtherType && !(value instanceof OtherTypeWrapper)) {
            value = new OtherTypeWrapper(value);
        }
        return value;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionSpathAccessor.getContextSQL(this.nodes[0]);
        sb.append(left);
        if (this.spath != null && this.spath.length() > 0) {
            sb.append(this.spath.substring(1));
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "SPATH ACCESS");
        if (this.getLeftNode() != null) {
            result.put("object", this.nodes[0].describeJson(session));
        }
        result.put("spath", this.spath);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("SPATH ACCESS");
        if (this.getLeftNode() != null) {
            sb.append(" object=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" spath=[");
            sb.append(this.spath);
            sb.append(']');
        }
        return sb.toString();
    }
}

