/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionColumnAccessor;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.ReferenceExpression;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.DataspaceCollectionType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.ServerTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.scheduler.Metaset;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class ExpressionOp
extends Expression {
    List<Expression> parameters = null;
    String methodName = null;
    boolean isArray = false;
    Method methodToCall = null;
    Type[] conversionTable = null;
    private List<ReferenceExpression> referenceExpressions;
    static final ExpressionOp limitOneExpression = new ExpressionOp(95, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER));
    private static Map<Class<?>, Class<?>> defaultImplementations = new HashMap();

    public ExpressionOp(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 37: 
            case 92: 
            case 93: 
            case 95: 
            case 96: {
                return;
            }
            case 84: {
                this.dataType = left.dataType;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    public ExpressionOp(Expression e, Type dataType) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        this.dataType = dataType;
        this.alias = e.alias;
    }

    public ExpressionOp(Expression e, List<Expression> params) {
        super(103);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        this.parameters = params;
        this.dataType = Type.OTHER;
    }

    public ExpressionOp(Expression e, boolean newEvent) {
        super(newEvent ? 102 : 101);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        if (newEvent) {
            this.dataType = new EventType();
        }
    }

    ExpressionOp(Expression e) {
        super(e.dataType.isDateTimeTypeWithZone() ? 91 : 92);
        switch (e.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, e.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, e.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, e.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, e.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        this.alias = e.alias;
    }

    public void setParameters(List<Expression> exprs) {
        this.parameters = exprs;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setIsArray(boolean value) {
        this.isArray = value;
    }

    public static Expression getCastExpression(Session session, Expression e, Type dataType) {
        if (e.getType() == 1) {
            Object value = dataType.castToType(session, e.getValue(session), e.getDataType());
            return new ExpressionValue(value, dataType);
        }
        return new ExpressionOp(e, dataType);
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 101: {
                sb.append("NEW").append(' ').append(this.nodes[0].getSQL());
                sb.append("(");
                if (this.parameters != null && this.parameters.size() > 0) {
                    boolean first = true;
                    for (Expression expr : this.parameters) {
                        if (!first) {
                            sb.append(",");
                        } else {
                            first = false;
                        }
                        sb.append(expr.getSQL());
                    }
                }
                sb.append(")");
                return sb.toString();
            }
            case 102: {
                sb.append("NEW").append(' ').append('[').append(this.nodes[0].getSQL()).append(']');
                return sb.toString();
            }
            case 103: {
                sb.append(this.nodes[0].getSQL()).append(".").append(this.methodName).append("(");
                if (this.parameters != null) {
                    boolean first = true;
                    for (Expression expr : this.parameters) {
                        if (!first) {
                            sb.append(",");
                        } else {
                            first = false;
                        }
                        sb.append(expr.getSQL());
                    }
                }
                sb.append(")");
                return sb.toString();
            }
        }
        String left = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 37: {
                sb.append(' ').append("LIKE").append(' ');
                sb.append(left).append(' ').append(right).append(' ');
            }
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                return sb.toString();
            }
            case 93: {
                sb.append(' ').append("EVAL").append('(');
                sb.append(left).append(',').append(right).append(')');
                return sb.toString();
            }
            case 96: {
                sb.append(left).append(',').append(right);
                return sb.toString();
            }
            case 95: {
                if (left != null) {
                    sb.append(' ').append("OFFSET").append(' ');
                    sb.append(left).append(' ');
                }
                if (right == null) break;
                sb.append(' ').append("FETCH").append(' ');
                sb.append("FIRST");
                sb.append(right).append(' ').append(right).append(' ');
                sb.append("ROWS").append(' ').append("ONLY");
                sb.append(' ');
                break;
            }
            case 92: {
                sb.append(left).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    sb.append("LOCAL").append(' ');
                    break;
                }
                sb.append("TIME").append(' ').append("ZONE");
                sb.append(' ');
                sb.append(right);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("value", this.valueData);
                result.put("type", this.dataType.getNameString());
                return result;
            }
            case 37: {
                result.put("opType", "LIKE");
                result.put("arg", this.dataType.getTypeDefinition());
                break;
            }
            case 26: {
                result.put("opType", "VALUELIST");
                ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.nodes.length; ++i) {
                    values.add(this.nodes[i].describeJson(session));
                }
                result.put("values", values);
                return result;
            }
            case 91: {
                result.put("opType", "CAST");
                result.put("dataType", this.dataType.getTypeDefinition());
                break;
            }
            case 93: {
                result.put("opType", "CASEWHEN");
            }
        }
        if (this.getLeftNode() != null) {
            result.put("argLeft", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("argRight", this.nodes[1].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE").append(' ').append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 37: {
                sb.append("LIKE").append(' ').append("ARG ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
                break;
            }
            case 26: {
                sb.append("VALUE").append(' ').append("LIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                return sb.toString();
            }
            case 91: {
                sb.append("CAST").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
                break;
            }
            case 93: {
                sb.append("EVAL").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 93: {
                acceptsSequences = false;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        if (this.parameters != null) {
            for (Expression expr : this.parameters) {
                if (expr == null) continue;
                unresolvedSet = expr.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
            }
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 93: {
                break;
            }
            default: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodes[i].resolveTypes(session, this);
                }
            }
        }
        block5 : switch (this.opType) {
            case 1: {
                break;
            }
            case 102: {
                String eventId;
                Prototype prototype;
                if (this.parameters != null) {
                    for (Expression expr : this.parameters) {
                        expr.resolveTypes(session, parent);
                    }
                }
                if ((prototype = session.sessionContext.datagramPrototypeCache.lookupPrototype(eventId = this.nodes[0].getValue(session).toString())) == null) {
                    throw new DataspaceException("Invalid event prototype [" + eventId + "] specified.");
                }
                ImmutableEventDatagram event = null;
                try {
                    if (session.sessionContext.eventDatagramFactory.supportsModel(prototype.getModelName())) {
                        event = session.sessionContext.eventDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.exceptionDatagramFactory.supportsModel(prototype.getModelName())) {
                        event = session.sessionContext.exceptionDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.advisoryDatagramFactory.supportsModel(prototype.getModelName())) {
                        event = session.sessionContext.advisoryDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.opaqueDatagramFactory.supportsModel(prototype.getModelName())) {
                        event = session.sessionContext.opaqueDatagramFactory.createEvent(eventId);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException(error);
                }
                if (event != null) {
                    this.dataType = Types.getParameterSQLType(session, event.getClass());
                    ((EventType)this.dataType).setEventId(eventId);
                    break;
                }
                throw new DataspaceException("Invalid event prototype [" + eventId + "] specified.");
            }
            case 103: {
                Method method;
                Object temp;
                if (this.parameters != null) {
                    for (Expression expr : this.parameters) {
                        expr.resolveTypes(session, parent);
                    }
                }
                if (this.nodes[0].getDataType() == null && session.sessionContext.currentCompoundStatement != null) {
                    String className = session.sessionContext.currentCompoundStatement.resolveImportedType(this.nodes[0].getColumnName());
                    if (className == null) {
                        throw new DataspaceException("Unknown instance name '" + this.nodes[0].getColumnName() + "' to call method '" + this.getSQL() + "'.");
                    }
                    try {
                        this.nodes[0].setDataType(session, new OtherType(className, ClassUtils.loadClass(className, DataspaceManager.getContext().getSystemClassLoaderChain())));
                    }
                    catch (ClassNotFoundException e) {
                        throw new DataspaceException("Failed to load class '" + className + "'.", e);
                    }
                }
                if (this.nodes[0].getDataType() == null && this.nodes[0].canBeStaticCall > 0) {
                    this.nodes[0].setDataType(session, session.dataspaceStore.schemaManager.getDomainOrDistinctType(this.nodes[0].getColumnName(), "SYS", true));
                }
                Class<?> clazz = this.nodes[0].getDataType().getInternalClass(session);
                boolean isDataspaceCollectionType = this.nodes[0].getDataType() instanceof DataspaceCollectionType;
                if (isDataspaceCollectionType) {
                    clazz = ((DataspaceCollectionType)this.nodes[0].getDataType()).getCollectionType().getCollectionClass();
                }
                Class[] paramClasses = null;
                if (this.parameters != null) {
                    paramClasses = new Class[this.parameters.size()];
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        temp = this.parameters.get(i).getDataType();
                        paramClasses[i] = temp != null ? ((Type)temp).getInternalClass(session) : Object.class;
                    }
                } else {
                    paramClasses = new Class[]{};
                }
                if ((method = this.getQueryMethodForServerTypeWrapper(clazz, this.methodName, paramClasses)) == null) {
                    method = ClassUtils.findBestDeclaredOrInheritedMethod(clazz, this.methodName, paramClasses, true);
                }
                if (method == null && this.parameters != null) {
                    temp = ClassUtils.findAllMethods(clazz, this.methodName, paramClasses.length);
                    this.conversionTable = new Type[paramClasses.length];
                    for (int i = 0; i < temp.size(); ++i) {
                        boolean canConvert = true;
                        Class<?>[] actualParams = ((Method)temp.get(i)).getParameterTypes();
                        for (int j = 0; j < paramClasses.length; ++j) {
                            Type actualDsType = Types.getParameterSQLType(session, actualParams[j]);
                            if (this.parameters.get(j).getDataType() == null || this.parameters.get(j).getDataType().getJDBCTypeCode() == actualDsType.getJDBCTypeCode()) continue;
                            if (this.parameters.get(j).getDataType().canConvertFrom(actualDsType)) {
                                this.conversionTable[j] = actualDsType;
                                continue;
                            }
                            canConvert = false;
                            break;
                        }
                        if (!canConvert) continue;
                        method = (Method)temp.get(i);
                        break;
                    }
                }
                if (method != null) {
                    temp = Types.getParameterSQLType(session, method.getReturnType());
                    if (temp != null) {
                        this.dataType = temp;
                    }
                    if (!isDataspaceCollectionType) {
                        this.methodToCall = method;
                    }
                }
                if (method != null || clazz != RowSet.class) break;
                throw new DataspaceException("Unable to resolve method '" + this.methodName + "' on variable '" + this.nodes[0].getColumnName() + "', either method does not exist, or parameters do not match.");
            }
            case 101: {
                if (this.parameters != null) {
                    for (Expression expr : this.parameters) {
                        expr.resolveTypes(session, parent);
                    }
                }
                this.dataType = (Type)((OtherTypeWrapper)this.nodes[0].getValue(session)).getObject();
                break;
            }
            case 37: {
                this.dataType = this.nodes[0].dataType;
                if (this.nodes[0].opType != 1 || this.nodes[1] != null && this.nodes[1].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 91: {
                Expression node = this.nodes[0];
                Type nodeType = node.dataType;
                if (!(this.dataType instanceof OtherType || nodeType instanceof OtherType && node instanceof ExpressionColumn && ((ExpressionColumn)node).getSpath() != null || this.dataType instanceof OtherType || nodeType instanceof OtherType && node instanceof ExpressionColumnAccessor && ((ExpressionColumnAccessor)node).getSpath() != null || nodeType == null || this.dataType.canConvertFrom(nodeType) || nodeType instanceof OtherType)) {
                    throw Error.error(5561);
                }
                if (node.opType == 1) {
                    this.setAsConstantValue(session);
                    node.dataType = this.dataType;
                    node.valueData = this.valueData;
                    if (parent == null) break;
                    parent.replaceNode(this, node);
                    break;
                }
                if (this.nodes[0].opType != 8) break;
                node.dataType = this.dataType;
                break;
            }
            case 92: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        if (this.nodes[1].opType == 1) {
                            this.nodes[1].valueData = Type.SQL_INTERVAL_HOUR_TO_MINUTE.castToType(session, this.nodes[1].valueData, this.nodes[1].dataType);
                            this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                        } else {
                            throw Error.error(5563);
                        }
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block5;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block5;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block5;
                    }
                }
                throw Error.error(5563);
            }
            case 93: {
                this.resolveTypesForCaseWhen(session);
                break;
            }
            case 96: {
                break;
            }
            case 95: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        throw Error.error(5567);
                    }
                    if (!this.nodes[0].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                if (this.nodes[1] == null) break;
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType.isIntegralType()) break;
                throw Error.error(5563);
            }
            case 84: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
    }

    void resolveTypesForCaseWhen(Session session) {
        if (this.dataType != null) {
            return;
        }
        Expression expr = this;
        while (expr.opType == 93) {
            expr.nodes[0].resolveTypes(session, expr);
            if (expr.nodes[0].isUnresolvedParam()) {
                expr.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expr.nodes[1].nodes[0].resolveTypes(session, expr.nodes[1]);
            if (expr.nodes[1].nodes[1].opType != 93) {
                expr.nodes[1].nodes[1].resolveTypes(session, expr.nodes[1]);
            }
            expr = expr.nodes[1].nodes[1];
        }
        if (this.exprSubType == 91 && this.nodes[1].nodes[1].dataType != null && this.nodes[1].nodes[1].dataType != this.nodes[1].nodes[0].dataType) {
            Type castType = this.nodes[1].nodes[1].dataType;
            if (castType.isCharacterType()) {
                castType = Type.SQL_VARCHAR_DEFAULT;
            }
            this.nodes[1].nodes[0] = new ExpressionOp(this.nodes[1].nodes[0], castType);
        }
        expr = this;
        while (expr.opType == 93) {
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[1].dataType, this.dataType);
            expr = expr.nodes[1].nodes[1];
        }
        if (this.dataType instanceof CharacterType && this.dataType.precision != Integer.MAX_VALUE) {
            this.dataType.precision = Integer.MAX_VALUE;
        }
        expr = this;
        while (expr.opType == 93) {
            if (expr.nodes[1].nodes[0].dataType == null) {
                expr.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expr.nodes[1].nodes[1].dataType == null) {
                expr.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expr.nodes[1].dataType == null) {
                expr.nodes[1].dataType = this.dataType;
            }
            expr = expr.nodes[1].nodes[1];
        }
        if (this.dataType == null || this.dataType.typeCode == 0) {
            throw Error.error(5567);
        }
    }

    @Override
    public Object getValue(Session session) {
        Object value = this.doGetValue(session);
        if (this.referenceExpressions != null) {
            this.referenceExpressions.forEach(e -> e.setValue(value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object doGetValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 101: {
                baseType = type = (Type)((OtherTypeWrapper)this.nodes[0].getValue(session)).getObject();
                typeModifier = baseType.userTypeModifier;
                typeName = baseType.getTypeDefinition();
                if (typeModifier != null) {
                    typeName = typeModifier.getName().name;
                }
                elementClazz = null;
                if (this.isArray) {
                    baseType = type.collectionBaseType();
                }
                if (baseType instanceof OtherType) {
                    if (typeModifier != null) {
                        className = DataspaceManager.getContext().getSemanticTypeCache().resolveSemanticType(typeName);
                        if (className == null) {
                            throw new DataspaceException("Object '" + typeName + "' creation failed. Unable to resolve semantic type.");
                        }
                        try {
                            elementClazz = ClassUtils.loadClass(className, DataspaceManager.getContext().getSystemClassLoaderChain());
                        }
                        catch (ClassNotFoundException exception) {
                            throw new DataspaceException("Failed to create instance of type '" + typeName + "'. Cause: Type is not loaded.");
                        }
                        if (elementClazz == null) {
                            throw new DataspaceException("Failed to load class '" + className + "'.");
                        }
                    } else {
                        elementClazz = baseType.getInternalClass(session);
                    }
                } else {
                    if (baseType instanceof BinaryType) {
                        return new BinaryData(new byte[(int)((BinaryType)baseType).precision], false);
                    }
                    elementClazz = baseType.getJDBCClass();
                }
                if (elementClazz.isInterface()) {
                    elementClazz = ExpressionOp.defaultImplementations.get(elementClazz);
                }
                if (elementClazz == null || elementClazz.isInterface()) {
                    throw new DataspaceException("Unable to resolve class for new operation. Type '" + typeName + "'.");
                }
                try {
                    if (this.isArray || baseType instanceof BinaryType) {
                        arraySize = ((ArrayType)type).maxCardinality;
                        if (arraySize == -1) {
                            arraySize = 0;
                        }
                        return Array.newInstance(elementClazz, arraySize);
                    }
                    argumentValues = this.parameters != null ? new Object[this.parameters.size()] : new Object[]{};
                    if (this.parameters != null) {
                        for (i = 0; i < this.parameters.size(); ++i) {
                            expr = this.parameters.get(i);
                            if (expr == null) continue;
                            argumentValues[i] = expr.getDataType() != null ? expr.getDataType().convertSQLToJava(session, expr.getValue(session)) : expr.getValue(session);
                        }
                    }
                    if (elementClazz.equals(Metaset.class)) {
                        if (argumentValues.length != 1 || !(argumentValues[0] instanceof String)) {
                            throw new DataspaceException("Constructor with specified arguments not found.");
                        }
                        result = DataspaceStoreManager.getRuntimeContext().getScheduler().getMetaset((String)argumentValues[0]);
                        if (result == null) {
                            throw new DataspaceException("Metaset not found.");
                        }
                        return result;
                    }
                    argumentTypes = new Class[argumentValues.length];
                    for (i = 0; i < argumentValues.length; ++i) {
                        argumentTypes[i] = argumentValues[i] != null ? argumentValues[i].getClass() : Object.class;
                    }
                    constructor = ClassUtils.getSatisfiableConstructor(elementClazz, argumentTypes);
                    if (constructor == null) {
                        throw new DataspaceException("Constructor with specified arguments not found.");
                    }
                    constructor.setAccessible(true);
                    return this.dataType.convertJavaToSQL(session, constructor.newInstance(argumentValues));
                }
                catch (Exception exception) {
                    throw new DataspaceException("Failed to create instance of type '" + typeName + "'.", exception);
                }
            }
            case 103: {
                try {
                    callable = null;
                    callableClass = null;
                    try {
                        callable = this.nodes[0].getValue(session);
                        if (callable == null) {
                            throw new DataspaceException("Unable to call method '" + this.methodName + "' on null object.");
                        }
                        callable = this.nodes[0].getDataType().convertSQLToJava(session, callable);
                        if (callable == null) {
                            throw new DataspaceException("Unable to resolve callee for '" + this.methodName + "' method call.");
                        }
                        callableClass = callable.getClass();
                    }
                    catch (Exception exception) {
                        if (this.nodes[0].opType == 2 && this.nodes[0].getColumn() == null) {
                            callableClass = this.nodes[0].getDataType().getInternalClass(session);
                        }
                        throw exception;
                    }
                    numberOfArguments = this.parameters.size();
                    firstParam = 0;
                    if (Collection.class.isAssignableFrom(callableClass)) {
                        ++numberOfArguments;
                        firstParam = 1;
                    }
                    argumentValues = this.parameters != null ? new Object[numberOfArguments] : new Object[]{};
                    if (this.parameters != null) {
                        for (i = firstParam; i < this.parameters.size() + firstParam; ++i) {
                            expr = this.parameters.get(i - firstParam);
                            if (expr == null) continue;
                            if (expr.getDataType() != null) {
                                if (this.conversionTable == null || i >= this.conversionTable.length || this.conversionTable[i] == null) {
                                    argumentValues[i] = expr.getDataType().convertSQLToJava(session, expr.getValue(session));
                                    continue;
                                }
                                argumentValues[i] = expr.getDataType().convertSQLToJava(session, this.conversionTable[i].convertToType(session, expr.getValue(session), expr.getDataType()));
                                continue;
                            }
                            argumentValues[i] = expr.getValue(session);
                        }
                    }
                    if (this.methodToCall == null) ** GOTO lbl142
                    if (this.methodToCall.getDeclaringClass() != callableClass) {
                        tempClass = callableClass;
                        isDataspaceCollectionType = this.nodes[0].getDataType() instanceof DataspaceCollectionType;
                        if (isDataspaceCollectionType) {
                            callableClass = ((DataspaceCollectionType)this.nodes[0].getDataType()).getCollectionType().getCollectionClass();
                        }
                        paramClasses = null;
                        if (this.parameters != null) {
                            paramClasses = new Class[this.parameters.size()];
                            for (i = 0; i < this.parameters.size(); ++i) {
                                temp = this.parameters.get(i).getDataType();
                                paramClasses[i] = temp != null ? temp.getInternalClass(session) : Object.class;
                            }
                        } else {
                            paramClasses = new Class[]{};
                        }
                        if ((method = ClassUtils.findBestDeclaredOrInheritedMethod(tempClass, this.methodName, paramClasses, true)) != null) {
                            temp = Types.getParameterSQLType(session, method.getReturnType());
                            if (temp != null) {
                                this.dataType = temp;
                            }
                            if (!isDataspaceCollectionType && this.methodToCall.getDeclaringClass().getName().equals(method.getDeclaringClass().getName())) {
                                this.methodToCall = method;
                            }
                        }
                    }
                    if (!this.isQueryMethodForServerTypeWrapper(this.methodToCall)) ** GOTO lbl126
                    a = this.invokeQueryMethodForServerTypeWrapper(callable, this.methodToCall, this.dataType.getInternalClass(session), argumentValues);
                    ** GOTO lbl139
lbl126:
                    // 1 sources

                    argumentValues = ClassUtils.castMethodArguments(this.methodToCall, argumentValues);
                    if (!this.methodToCall.isAccessible()) {
                        this.methodToCall.setAccessible(true);
                    }
                    try {
                        if (FacetsUtils.isUpdateStatementLevel1()) {
                            FacetsUtils.setUpdateStatementLevel2(true);
                        }
                        a = this.methodToCall.invoke(callable, argumentValues);
                    }
                    finally {
                        FacetsUtils.setUpdateStatementLevel2(false);
                    }
                    if (this.methodToCall.getReturnType() == java.lang.Void.TYPE) {
                        a = new Void();
                    }
lbl139:
                    // 4 sources

                    if (a instanceof BigDecimal && this.dataType.getSQLGenericTypeCode() == 3) {
                        return a;
                    }
                    return this.dataType.convertJavaToSQL(session, a);
lbl142:
                    // 1 sources

                    argumentTypes = new Class[argumentValues.length];
                    for (i = 0; i < argumentValues.length; ++i) {
                        if (argumentValues[i] != null) {
                            argumentTypes[i] = argumentValues[i].getClass();
                            continue;
                        }
                        argumentTypes[i] = null;
                        if (i < firstParam || (expr = this.parameters.get(i - firstParam)) == null || expr.getDataType() == null) continue;
                        argumentTypes[i] = expr.getDataType().getInternalClass(session);
                    }
                    if (firstParam == 1) {
                        argumentTypes[0] = Session.class;
                        argumentValues[0] = session;
                    }
                    if ((method = this.getQueryMethodForServerTypeWrapper(callableClass, this.methodName, argumentTypes)) != null) {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        return this.dataType.convertJavaToSQL(session, this.invokeQueryMethodForServerTypeWrapper(callable, method, this.dataType.getInternalClass(session), argumentValues));
                    }
                    meths = ClassUtils.findSatisfiableMethods(callableClass, this.methodName, argumentTypes, true, true);
                    if (meths != null && meths.size() > 0) {
                        method = meths.get(0);
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        argumentValues = ClassUtils.castMethodArguments(method, argumentValues);
                        return this.dataType.convertJavaToSQL(session, method.invoke(callable, argumentValues));
                    }
                    throw new DataspaceException("Unable to resolve method '" + this.methodName + "', either method does not exist, or parameters do not match.");
                }
                catch (Throwable exception) {
                    if (exception instanceof InvocationTargetException) {
                        exception = exception.getCause();
                    }
                    throw new DataspaceException("Failed to invoke method '" + this.methodName + "'.", exception);
                }
            }
            case 102: {
                try {
                    eventId = this.nodes[0].getValue(session).toString();
                    prototype = session.sessionContext.datagramPrototypeCache.lookupPrototype(eventId);
                    if (prototype == null) {
                        throw new DataspaceException("Event prototype [" + eventId + "] does not exist.");
                    }
                    event /* !! */  = null;
                    if (session.sessionContext.eventDatagramFactory.supportsModel(prototype.getModelName())) {
                        event /* !! */  = session.sessionContext.eventDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.exceptionDatagramFactory.supportsModel(prototype.getModelName())) {
                        event /* !! */  = session.sessionContext.exceptionDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.advisoryDatagramFactory.supportsModel(prototype.getModelName())) {
                        event /* !! */  = session.sessionContext.advisoryDatagramFactory.createEvent(eventId);
                    } else if (session.sessionContext.opaqueDatagramFactory.supportsModel(prototype.getModelName())) {
                        event /* !! */  = session.sessionContext.opaqueDatagramFactory.createEvent(eventId);
                    }
                    return this.dataType.convertJavaToSQL(session, event /* !! */ );
                }
                catch (Exception error) {
                    throw new DataspaceException(error.getMessage());
                }
            }
            case 37: {
                hasEscape = this.nodes[1] != null;
                escapeChar = 0x7FFFFFFF;
                if (this.dataType.isBinaryType()) {
                    left = (BinaryData)this.nodes[0].getValue(session);
                    if (left == null) {
                        return null;
                    }
                    if (hasEscape) {
                        right = (BinaryData)this.nodes[1].getValue(session);
                        if (right == null) {
                            return null;
                        }
                        if (right.length(session) != 1L) {
                            throw Error.error(3412);
                        }
                        escapeChar = right.getBytes()[0];
                    }
                    array = left.getBytes();
                    newArray = new byte[array.length];
                    wasEscape = false;
                    escapeCount = 0;
                    j = 0;
                    for (i = 0; i < array.length; ++i) {
                        if (array[i] == escapeChar) {
                            if (wasEscape) {
                                ++escapeCount;
                                newArray[j++] = array[i];
                                wasEscape = false;
                                continue;
                            }
                            wasEscape = true;
                            if (i != array.length - 1) continue;
                            throw Error.error(3458);
                        }
                        if (array[i] == 95 || array[i] == 37) {
                            if (!wasEscape) break;
                            ++escapeCount;
                            newArray[j++] = array[i];
                            wasEscape = false;
                            continue;
                        }
                        if (wasEscape) {
                            throw Error.error(3458);
                        }
                        newArray[j++] = array[i];
                    }
                    newArray = (byte[])ArrayUtil.resizeArrayIfDifferent(newArray, j);
                    return new BinaryData(newArray, false);
                }
                left = (String)this.nodes[0].getValue(session);
                if (left == null) {
                    return null;
                }
                if (hasEscape) {
                    right = (String)this.nodes[1].getValue(session);
                    if (right == null) {
                        return null;
                    }
                    if (right.length() != 1) {
                        throw Error.error(3439);
                    }
                    escapeChar = right.getBytes()[0];
                }
                array = left.toCharArray();
                newArray = new char[array.length];
                wasEscape = false;
                escapeCount = 0;
                j = 0;
                for (i = 0; i < array.length; ++i) {
                    if (array[i] == escapeChar) {
                        if (wasEscape) {
                            ++escapeCount;
                            newArray[j++] = array[i];
                            wasEscape = false;
                            continue;
                        }
                        wasEscape = true;
                        if (i != array.length - 1) continue;
                        throw Error.error(3458);
                    }
                    if (array[i] == '_' || array[i] == '%') {
                        if (!wasEscape) break;
                        ++escapeCount;
                        newArray[j++] = array[i];
                        wasEscape = false;
                        continue;
                    }
                    if (wasEscape) {
                        throw Error.error(3458);
                    }
                    newArray[j++] = array[i];
                }
                return new String(newArray, 0, j);
            }
            case 5: {
                value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 94: {
                return this.nodes[0].getValue(session);
            }
            case 84: {
                if (this.nodes[0].dataType.isCharacterType()) {
                    value = this.nodes[1].getValue(session);
                    type = (CharacterType)this.nodes[1].dataType;
                    length = ((CharacterType)this.nodes[1].dataType).size(session, value);
                    type = (CharacterType)this.nodes[0].dataType;
                    value = this.nodes[0].getValue(session);
                    return type.substring(session, value, 0L, length, true, false);
                }
                value = (BinaryData)this.nodes[1].getValue(session);
                length = value.length(session);
                type = (BinaryType)this.nodes[0].dataType;
                value = (BinaryData)this.nodes[0].getValue(session);
                return type.substring(session, value, 0L, length, true);
            }
            case 91: {
                value = this.nodes[0].getValue(session);
                value = this.dataType.castToType(session, value, this.nodes[0].dataType);
                if (this.dataType instanceof OtherType && !(value instanceof OtherTypeWrapper)) {
                    value = this.nodes[0].dataType.convertSQLToJava(session, value);
                    value = new OtherTypeWrapper(value);
                }
                if (this.dataType.userTypeModifier != null) {
                    if (this.dataType.isDistinctType() && value != null && (unwrappedValue = OtherTypeWrapper.unwrap(value)) != null && (clazz = this.dataType.getInternalClass(session)) != null && !clazz.isAssignableFrom(unwrappedValue.getClass())) {
                        info = new String[]{this.dataType.userTypeModifier.getName().name, "", ""};
                        throw Error.error(null, 3501, 3, info);
                    }
                    constraints = this.dataType.userTypeModifier.getConstraints();
                    for (i = 0; i < constraints.length; ++i) {
                        constraints[i].checkCheckConstraint(session, null, null, value);
                    }
                }
                return value;
            }
            case 93: {
                result = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(result)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 92: {
                leftValue = this.nodes[0].getValue(session);
                v0 = rightValue = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (leftValue == null) {
                    return null;
                }
                if (this.nodes[1] != null && rightValue == null) {
                    return null;
                }
                zoneSeconds = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(rightValue);
                return ((DateTimeType)this.dataType).changeZone(leftValue, this.nodes[0].dataType, (int)zoneSeconds, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    @Override
    public void collectObjectNames(Set set) {
        super.collectObjectNames(set);
        switch (this.opType) {
            case 102: {
                if (this.nodes[0].valueData == null || !(this.nodes[0].valueData instanceof String)) break;
                String eventId = (String)this.nodes[0].valueData;
                set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(eventId));
            }
        }
    }

    private boolean isQueryMethodForServerTypeWrapper(Method method) {
        return method.getDeclaringClass() == ServerTypeWrapper.class && method.getName().equals("query") && method.getParameterCount() > 1;
    }

    private Method getQueryMethodForServerTypeWrapper(Class<?> clazz, String methodName, Class<?>[] paramClasses) {
        List<Method> meths;
        if (clazz != ServerTypeWrapper.class) {
            return null;
        }
        if (methodName.equals("query") && paramClasses.length > 1 && (meths = ClassUtils.findAllMethods(clazz, methodName, 3)) != null && meths.size() > 0) {
            Method method = meths.get(0);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        return null;
    }

    private Object invokeQueryMethodForServerTypeWrapper(Object object, Method method, Class<?> targetClass, Object[] argumentValues) throws Exception {
        if (argumentValues.length > 1) {
            Object[] values = new Object[]{argumentValues[0], targetClass, new Object[argumentValues.length - 1]};
            for (int i = 1; i < argumentValues.length; ++i) {
                ((Object[])values[2])[i - 1] = argumentValues[i];
            }
            return method.invoke(object, values);
        }
        return method.invoke(object, argumentValues);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void addReferenceExpression(ReferenceExpression referenceExpression) {
        if (this.referenceExpressions == null) {
            this.referenceExpressions = new ArrayList<ReferenceExpression>();
        }
        this.referenceExpressions.add(referenceExpression);
    }

    public Method getMethodToCall() {
        return this.methodToCall;
    }

    public String getMethodName() {
        return this.methodName;
    }

    static {
        defaultImplementations.put(Map.class, HashMap.class);
        defaultImplementations.put(List.class, ArrayList.class);
        defaultImplementations.put(java.util.Set.class, HashSet.class);
        defaultImplementations.put(Queue.class, LinkedList.class);
    }
}

