/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.FacetAspectJoinUtils;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExpressionLogicalFacet
extends ExpressionLogical {
    private FacetJoin facetJoin;

    public ExpressionLogicalFacet(Expression left, Expression right, FacetJoin facetJoin) {
        super(120);
        this.facetJoin = facetJoin;
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        String left = ExpressionLogicalFacet.getContextSQL(this.nodes[0]);
        String right = ExpressionLogicalFacet.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        builder.append(left).append(",").append(right);
        builder.append(" (").append(this.facetJoin.matchOn.getSyntax()).append(" ").append(this.facetJoin.matchLevel.name().toLowerCase());
        if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
            builder.append(" ").append(this.facetJoin.degree);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "FACET JOIN");
        if (this.getLeftNode() != null) {
            result.put("argLeft", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("argRight", this.nodes[1].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("FACET JOIN");
        if (this.getLeftNode() != null) {
            builder.append(" arg_left=[");
            builder.append(this.nodes[0].describe(session, blanks + 1));
            builder.append(']');
        }
        if (this.getRightNode() != null) {
            builder.append(" arg_right=[");
            builder.append(this.nodes[1].describe(session, blanks + 1));
            builder.append(']');
        }
        return builder.toString();
    }

    @Override
    public Object getValue(Session session) {
        Facets left = (Facets)OtherTypeWrapper.unwrap(this.nodes[0].getValue(session));
        Object rightObject = OtherTypeWrapper.unwrap(this.nodes[1].getValue(session));
        if (left == null && rightObject == null) {
            return true;
        }
        if (rightObject == null || left == null) {
            return false;
        }
        Facets right = new Facets();
        if (rightObject instanceof Facets) {
            right.putAll((Map)((Facets)rightObject));
        } else if (rightObject instanceof Map) {
            right.putAll((Map)rightObject);
        } else if (rightObject instanceof Aspects) {
            ((Aspects)rightObject).forEach(k -> right.put(String.valueOf(k), (Object)null));
        } else if (rightObject instanceof List) {
            ((List)rightObject).forEach(k -> right.put(String.valueOf(k), (Object)null));
        } else if (rightObject.getClass().isArray()) {
            Arrays.asList(rightObject).forEach(k -> right.put(String.valueOf(k), (Object)null));
        } else {
            throw Error.incompatibleComparisonTypesError("Facets" + (this.facetJoin.matchOn == FacetAspectJoinUtils.MatchOn.KEYS ? " or Aspects" : ""), rightObject);
        }
        return FacetsComparator.compare(left, right, this.facetJoin);
    }

    public Facets makeFacet(Facets left, Facets right) {
        Facets result = new Facets();
        if (this.facetJoin.matchOn == FacetAspectJoinUtils.MatchOn.KEYS) {
            Set leftKeys = left.keySet();
            Set rightKeys = right.keySet();
            if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ALL) {
                if (leftKeys.containsAll(rightKeys)) {
                    rightKeys.forEach(k -> result.put("left." + k, left.get(k)));
                    rightKeys.forEach(k -> result.put("right." + k, right.get(k)));
                }
            } else if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.EQ) {
                if (leftKeys.size() == rightKeys.size() && leftKeys.containsAll(rightKeys)) {
                    rightKeys.forEach(k -> result.put("left." + k, left.get(k)));
                    rightKeys.forEach(k -> result.put("right." + k, right.get(k)));
                }
            } else if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ANY) {
                if (rightKeys.stream().filter(k -> leftKeys.contains(k)).findAny().isPresent()) {
                    rightKeys.forEach(k -> {
                        if (leftKeys.contains(k)) {
                            result.put("left." + k, left.get(k));
                        }
                    });
                    rightKeys.forEach(k -> {
                        if (leftKeys.contains(k)) {
                            result.put("right." + k, right.get(k));
                        }
                    });
                }
            } else if (this.facetJoin.matchLevel != FacetAspectJoinUtils.MatchLevel.NONE && this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE && rightKeys.stream().filter(k -> leftKeys.contains(k)).count() >= (long)this.facetJoin.degree) {
                rightKeys.forEach(k -> {
                    if (leftKeys.contains(k)) {
                        result.put("left." + k, left.get(k));
                    }
                });
                rightKeys.forEach(k -> {
                    if (leftKeys.contains(k)) {
                        result.put("right." + k, right.get(k));
                    }
                });
            }
        } else if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ALL) {
            if (FacetsComparator.compare(left, right, this.facetJoin)) {
                right.entrySet().forEach(k -> {
                    if (left.containsKey(k.getKey())) {
                        result.put((String)k.getKey(), k.getValue());
                    }
                });
            }
        } else if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.EQ) {
            if (FacetsComparator.compare(left, right, this.facetJoin)) {
                right.entrySet().forEach(k -> {
                    if (left.containsKey(k.getKey())) {
                        result.put((String)k.getKey(), k.getValue());
                    }
                });
            }
        } else if (this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ANY) {
            if (FacetsComparator.compare(left, right, this.facetJoin)) {
                right.entrySet().forEach(k -> {
                    if (left.containsKey(k.getKey()) && FacetAspectJoinUtils.compareFacetValues(left.get(k.getKey()), k.getValue())) {
                        result.put((String)k.getKey(), k.getValue());
                    }
                });
            }
        } else if (this.facetJoin.matchLevel != FacetAspectJoinUtils.MatchLevel.NONE && this.facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE && FacetsComparator.compare(left, right, this.facetJoin)) {
            right.entrySet().forEach(k -> {
                if (left.containsKey(k.getKey()) && FacetAspectJoinUtils.compareFacetValues(left.get(k.getKey()), k.getValue())) {
                    result.put((String)k.getKey(), k.getValue());
                }
            });
        }
        return result;
    }

    public static class FacetJoin {
        private final FacetAspectJoinUtils.MatchOn matchOn;
        private final FacetAspectJoinUtils.MatchLevel matchLevel;
        private final int degree;

        public FacetJoin(FacetAspectJoinUtils.MatchOn matchOn, FacetAspectJoinUtils.MatchLevel matchLevel, int degree) {
            this.matchOn = matchOn;
            this.matchLevel = matchLevel;
            this.degree = degree;
        }

        public FacetAspectJoinUtils.MatchOn getMatchOn() {
            return this.matchOn;
        }

        public FacetAspectJoinUtils.MatchLevel getMatchLevel() {
            return this.matchLevel;
        }

        public int getDegree() {
            return this.degree;
        }

        public String getSQL() {
            return "(" + this.matchOn.getSyntax() + " " + this.matchLevel.name().toLowerCase() + (String)(this.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE ? " " + this.degree : "") + ")";
        }

        public static FacetJoin parseSQL(String sql) {
            List<Object> parts = Arrays.stream(sql.split(" ")).map(s -> sql.trim()).collect(Collectors.toList());
            if (parts.size() > 0 && parts.get(0) == "(") {
                parts.remove(0);
            }
            if (parts.size() > 0 && parts.get(parts.size() - 1) == "(") {
                parts.remove(parts.size() - 1);
            }
            String trimmedSql = parts.stream().map(part -> part.toLowerCase()).collect(Collectors.joining(" "));
            FacetAspectJoinUtils.MatchOn matchOn = FacetAspectJoinUtils.MatchOn.parse(trimmedSql);
            parts = Arrays.asList(trimmedSql.substring(matchOn.getSyntax().length()).trim().split(" "));
            FacetAspectJoinUtils.MatchLevel matchLevel = FacetAspectJoinUtils.MatchLevel.valueOf((String)parts.get(0));
            int degree = 0;
            if (matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
                if (parts.size() != 2) {
                    throw new DataspaceException("Invalid degree syntax. Should be (degree <degree>)");
                }
                degree = Integer.valueOf((String)parts.get(1));
            }
            return new FacetJoin(matchOn, matchLevel, degree);
        }
    }

    public static class FacetsComparator {
        public static boolean compare(Facets left, Facets right, FacetJoin facetJoin) {
            if (facetJoin.matchOn == FacetAspectJoinUtils.MatchOn.KEYS) {
                Set leftKeys = left.keySet();
                Set rightKeys = right.keySet();
                if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ALL) {
                    return leftKeys.containsAll(rightKeys);
                }
                if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.EQ) {
                    return leftKeys.size() == rightKeys.size() && leftKeys.containsAll(rightKeys);
                }
                if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ANY) {
                    return rightKeys.stream().filter(k -> leftKeys.contains(k)).findAny().isPresent();
                }
                if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.NONE) {
                    return !rightKeys.stream().filter(k -> leftKeys.contains(k)).findAny().isPresent();
                }
                if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
                    return rightKeys.stream().filter(k -> leftKeys.contains(k)).count() >= (long)facetJoin.degree;
                }
                throw new DataspaceException("Invalid match level: " + String.valueOf((Object)facetJoin.matchLevel));
            }
            Comparator<Object> valuesComparator = FacetAspectJoinUtils.createValuesComparator(facetJoin.matchOn);
            if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ALL) {
                for (Map.Entry entry : right.entrySet()) {
                    if (left.containsKey(entry.getKey()) && valuesComparator.compare(left.get(entry.getKey()), entry.getValue()) == 0) continue;
                    return false;
                }
                return true;
            }
            if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.EQ) {
                if (right.size() != left.size()) {
                    return false;
                }
                for (Map.Entry entry : right.entrySet()) {
                    if (left.containsKey(entry.getKey()) && valuesComparator.compare(left.get(entry.getKey()), entry.getValue()) == 0) continue;
                    return false;
                }
                return true;
            }
            if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ANY) {
                for (Map.Entry entry : right.entrySet()) {
                    if (!left.containsKey(entry.getKey()) || valuesComparator.compare(left.get(entry.getKey()), entry.getValue()) != 0) continue;
                    return true;
                }
                return false;
            }
            if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.NONE) {
                for (Map.Entry entry : right.entrySet()) {
                    if (!left.containsKey(entry.getKey()) || valuesComparator.compare(left.get(entry.getKey()), entry.getValue()) != 0) continue;
                    return false;
                }
                return true;
            }
            if (facetJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
                int count = 0;
                for (Map.Entry entry : right.entrySet()) {
                    if (!left.containsKey(entry.getKey()) || valuesComparator.compare(left.get(entry.getKey()), entry.getValue()) != 0 || ++count < facetJoin.degree) continue;
                    return true;
                }
                return false;
            }
            throw new DataspaceException("Invalid match level: " + String.valueOf((Object)facetJoin.matchLevel));
        }
    }
}

