/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.FacetAspectJoinUtils;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExpressionLogicalAspect
extends ExpressionLogical {
    private final AspectJoin aspectJoin;

    public ExpressionLogicalAspect(Expression left, Expression right, AspectJoin aspectJoin) {
        super(121);
        this.aspectJoin = aspectJoin;
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        String left = ExpressionLogicalAspect.getContextSQL(this.nodes[0]);
        String right = ExpressionLogicalAspect.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        builder.append(left).append(",").append(right);
        builder.append(" (").append((String)(this.aspectJoin.matchOn != null ? this.aspectJoin.matchOn.getSyntax() + " " : "")).append(this.aspectJoin.matchLevel.name().toLowerCase());
        if (this.aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
            builder.append(" ").append(this.aspectJoin.degree);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "ASPECT JOIN");
        if (this.getLeftNode() != null) {
            result.put("argLeft", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("argRight", this.nodes[1].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("ASPECT JOIN");
        if (this.getLeftNode() != null) {
            builder.append(" arg_left=[");
            builder.append(this.nodes[0].describe(session, blanks + 1));
            builder.append(']');
        }
        if (this.getRightNode() != null) {
            builder.append(" arg_right=[");
            builder.append(this.nodes[1].describe(session, blanks + 1));
            builder.append(']');
        }
        return builder.toString();
    }

    @Override
    public Object getValue(Session session) {
        Aspects left = (Aspects)OtherTypeWrapper.unwrap(this.nodes[0].getValue(session));
        Object rightObject = OtherTypeWrapper.unwrap(this.nodes[1].getValue(session));
        if (left == null && rightObject == null) {
            return true;
        }
        if (rightObject == null || left == null) {
            return false;
        }
        Aspects right = new Aspects();
        if (rightObject instanceof Aspects || rightObject instanceof Collection) {
            right.addAll((Collection)rightObject);
        } else if (rightObject.getClass().isArray()) {
            Arrays.asList(rightObject).forEach(k -> right.add(k));
        } else {
            throw Error.incompatibleComparisonTypesError(left, rightObject);
        }
        return AspectsComparator.compare(left, right, this.aspectJoin);
    }

    public static class AspectJoin {
        private FacetAspectJoinUtils.MatchOn matchOn;
        private final FacetAspectJoinUtils.MatchLevel matchLevel;
        private final int degree;

        public AspectJoin(FacetAspectJoinUtils.MatchOn matchOn, FacetAspectJoinUtils.MatchLevel matchLevel, int degree) {
            this.matchOn = matchOn;
            this.matchLevel = matchLevel;
            this.degree = degree;
        }

        public FacetAspectJoinUtils.MatchLevel getMatchLevel() {
            return this.matchLevel;
        }

        public int getDegree() {
            return this.degree;
        }

        public String getSQL() {
            return "(" + (String)(this.matchOn != null ? this.matchOn.getSyntax() + " " : "") + this.matchLevel.name().toLowerCase() + (String)(this.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE ? " " + this.degree : "") + ")";
        }

        public static AspectJoin parseSQL(String sql) {
            List<Object> parts = Arrays.stream(sql.split(" ")).map(s -> sql.trim()).collect(Collectors.toList());
            if (parts.size() > 0 && parts.get(0) == "(") {
                parts.remove(0);
            }
            if (parts.size() > 0 && parts.get(parts.size() - 1) == "(") {
                parts.remove(parts.size() - 1);
            }
            Object trimmedSql = parts.stream().map(part -> part.toLowerCase()).collect(Collectors.joining(" "));
            FacetAspectJoinUtils.MatchOn matchOn = null;
            try {
                matchOn = FacetAspectJoinUtils.MatchOn.parse((String)trimmedSql);
            }
            catch (Exception exception) {
                trimmedSql = "values " + (String)trimmedSql;
                matchOn = FacetAspectJoinUtils.MatchOn.parse((String)trimmedSql);
            }
            parts = Arrays.asList(((String)trimmedSql).substring(matchOn.getSyntax().length()).trim().split(" "));
            FacetAspectJoinUtils.MatchLevel matchLevel = FacetAspectJoinUtils.MatchLevel.valueOf((String)parts.get(0));
            int degree = 0;
            if (matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
                if (parts.size() != 2) {
                    throw new DataspaceException("Invalid degree syntax. Should be (degree <degree>)");
                }
                degree = Integer.valueOf((String)parts.get(1));
            }
            return new AspectJoin(matchOn, matchLevel, degree);
        }
    }

    public static class AspectsComparator {
        public static boolean compare(Aspects left, Aspects right, AspectJoin aspectJoin) {
            Comparator<Object> comparator = FacetAspectJoinUtils.createValuesComparator(aspectJoin.matchOn);
            if (aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ALL) {
                for (Object value : right) {
                    if (AspectsComparator.isAspectIncludesValue(left, value, comparator)) continue;
                    return false;
                }
                return true;
            }
            if (aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.EQ) {
                if (left.size() != right.size()) {
                    return false;
                }
                for (Object value : right) {
                    if (AspectsComparator.isAspectIncludesValue(left, value, comparator)) continue;
                    return false;
                }
                return true;
            }
            if (aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.ANY) {
                for (Object value : right) {
                    if (!AspectsComparator.isAspectIncludesValue(left, value, comparator)) continue;
                    return true;
                }
                return false;
            }
            if (aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.NONE) {
                for (Object value : right) {
                    if (!AspectsComparator.isAspectIncludesValue(left, value, comparator)) continue;
                    return false;
                }
                return true;
            }
            if (aspectJoin.matchLevel == FacetAspectJoinUtils.MatchLevel.DEGREE) {
                int count = 0;
                for (Object value : right) {
                    if (!AspectsComparator.isAspectIncludesValue(left, value, comparator) || ++count < aspectJoin.degree) continue;
                    return true;
                }
                return false;
            }
            throw new DataspaceException("Invalid match level: " + String.valueOf((Object)aspectJoin.matchLevel));
        }

        private static boolean isAspectIncludesValue(Aspects aspect, Object rightValue, Comparator<Object> comparator) {
            for (Object left : aspect) {
                if (comparator.compare(left, rightValue) != 0) continue;
                return true;
            }
            return false;
        }
    }
}

