/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionArithmetic;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionTable;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.DTIType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionLogical
extends Expression {
    public boolean noOptimisation;
    boolean isQuantified;
    public boolean isTerminal;
    RangeVariable[] rangeArray = RangeVariable.emptyArray;

    ExpressionLogical(int type) {
        super(type);
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(boolean b) {
        super(1);
        this.dataType = Type.SQL_BOOLEAN;
        this.valueData = b ? Boolean.TRUE : Boolean.FALSE;
    }

    public ExpressionLogical(RangeVariable leftRangeVar, int colIndexLeft, RangeVariable rightRangeVar, int colIndexRight) {
        super(41);
        ExpressionColumn leftExpression = new ExpressionColumn(leftRangeVar, colIndexLeft);
        ExpressionColumn rightExpression = new ExpressionColumn(rightRangeVar, colIndexRight);
        this.nodes = new Expression[2];
        this.dataType = Type.SQL_BOOLEAN;
        this.nodes[0] = leftExpression;
        this.nodes[1] = rightExpression;
    }

    public ExpressionLogical(Expression left, Expression right) {
        super(41);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    public ExpressionLogical(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.setEqualityMode();
            }
            case 46: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 114: 
            case 117: 
            case 118: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    ExpressionLogical(int type, Expression left, Expression right, Expression end) {
        super(type);
        this.nodes = new Expression[3];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.nodes[2] = end;
    }

    public ExpressionLogical(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 47: 
            case 48: 
            case 55: 
            case 57: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    public ExpressionLogical(ColumnSchema column) {
        super(48);
        this.nodes = new Expression[1];
        this.dataType = Type.SQL_BOOLEAN;
        Expression e = new ExpressionColumn(column);
        e = new ExpressionLogical(47, e);
        this.nodes[0] = e;
    }

    void setEqualityMode() {
        if (this.nodes[0].opType == 2) {
            switch (this.nodes[1].opType) {
                case 2: {
                    if (this.opType != 41) break;
                    this.isColumnEqual = true;
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    this.isSingleColumnCondition = true;
                }
            }
        } else if (this.nodes[1].opType == 2) {
            switch (this.nodes[0].opType) {
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    this.isSingleColumnCondition = true;
                }
            }
        }
    }

    public static Expression andExpressions(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (EXPR_FALSE.equals(e1) || EXPR_FALSE.equals(e2)) {
            return EXPR_FALSE;
        }
        if (e1 == e2) {
            return e1;
        }
        return new ExpressionLogical(49, e1, e2);
    }

    public static Expression orExpressions(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (e1 == e2) {
            return e1;
        }
        return new ExpressionLogical(50, e1, e2);
    }

    public void addLeftColumnsForAllAny(RangeVariable range, OrderedIntHashSet set) {
        if (this.nodes.length == 0) {
            return;
        }
        for (int j = 0; j < this.nodes[0].nodes.length; ++j) {
            int index = this.nodes[0].nodes[j].getColumnIndex();
            if (index < 0 || this.nodes[0].nodes[j].getRangeVariable() != range) {
                set.clear();
                return;
            }
            set.add(index);
        }
    }

    @Override
    public void setSubType(int type) {
        this.exprSubType = type;
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.isQuantified = true;
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        if (this.opType == 1) {
            return super.getSQL();
        }
        String left = ExpressionLogical.getContextSQL(this.nodes[0]);
        String right = ExpressionLogical.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 48: {
                if (this.nodes[0].opType == 47) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return sb.toString();
                }
                if (this.nodes[0].opType == 58) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                    return sb.toString();
                }
                sb.append("NOT").append(' ').append(left);
                return sb.toString();
            }
            case 58: {
                sb.append("NOT").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                return sb.toString();
            }
            case 47: {
                sb.append(left).append(' ').append("IS").append(' ').append("NULL");
                return sb.toString();
            }
            case 57: {
                sb.append(' ').append("UNIQUE").append(' ');
                break;
            }
            case 55: {
                sb.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 41: {
                sb.append(left).append('=').append(right);
                return sb.toString();
            }
            case 42: {
                sb.append(left).append(">=").append(right);
                return sb.toString();
            }
            case 43: {
                sb.append(left).append('>').append(right);
                return sb.toString();
            }
            case 44: {
                sb.append(left).append('<').append(right);
                return sb.toString();
            }
            case 45: {
                sb.append(left).append("<=").append(right);
                return sb.toString();
            }
            case 46: {
                if ("NULL".equals(right)) {
                    sb.append(left).append(" IS NOT ").append(right);
                } else {
                    sb.append(left).append("!=").append(right);
                }
                return sb.toString();
            }
            case 49: {
                sb.append(left).append(' ').append("AND").append(' ').append(right);
                return sb.toString();
            }
            case 114: {
                sb.append(left).append(' ').append("INSTANCEOF").append(' ').append(right);
                return sb.toString();
            }
            case 50: {
                sb.append(left).append(' ').append("OR").append(' ').append(right);
                return sb.toString();
            }
            case 54: {
                sb.append(left).append(' ').append("IN").append(' ').append(right);
                return sb.toString();
            }
            case 59: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(right);
                return sb.toString();
            }
            case 60: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(470).append(right);
                return sb.toString();
            }
            case 61: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(116).append(right);
                return sb.toString();
            }
            case 62: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(299).append(right);
                return sb.toString();
            }
            case 63: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(299).append(' ').append(470).append(right);
                return sb.toString();
            }
            case 64: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(299).append(' ').append(116).append(right);
                return sb.toString();
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("value", this.valueData);
                result.put("type", this.dataType.getNameString());
                return result;
            }
            case 48: {
                if (this.nodes[0].opType == 58) {
                    result.put("opType", "NOT DISTINCT");
                    return result;
                }
                result.put("opType", "NOT");
                break;
            }
            case 58: {
                result.put("opType", "NOT DISTINCT");
                break;
            }
            case 41: {
                result.put("opType", "EQUAL");
                break;
            }
            case 42: {
                result.put("opType", "GREATER_EQUAL");
                break;
            }
            case 43: {
                result.put("opType", "GREATER");
                break;
            }
            case 44: {
                result.put("opType", "SMALLER");
                break;
            }
            case 45: {
                result.put("opType", "SMALLER_EQUAL");
                break;
            }
            case 46: {
                result.put("opType", "NOT_EQUAL");
                break;
            }
            case 49: {
                result.put("opType", "AND");
                break;
            }
            case 50: {
                result.put("opType", "OR");
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                result.put("opType", "MATCH");
                break;
            }
            case 47: {
                result.put("opType", "IS NULL");
                break;
            }
            case 57: {
                result.put("opType", "UNIQUE");
                break;
            }
            case 55: {
                result.put("opType", "EXISTS");
                break;
            }
            case 56: {
                result.put("opType", "OVERLAPS");
                break;
            }
            case 117: {
                result.put("opType", "ARRAY CONTAINS");
                break;
            }
            case 118: {
                result.put("opType", "ARRAY INCLUDES");
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.getLeftNode() != null) {
            result.put("argLeft", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("argRight", this.nodes[1].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 48: {
                if (this.nodes[0].opType == 58) {
                    sb.append("DISTINCT");
                    return sb.toString();
                }
                sb.append("NOT");
                break;
            }
            case 58: {
                sb.append("NOT").append(' ').append("DISTINCT");
                break;
            }
            case 41: {
                sb.append("EQUAL");
                break;
            }
            case 42: {
                sb.append("GREATER_EQUAL");
                break;
            }
            case 43: {
                sb.append("GREATER");
                break;
            }
            case 44: {
                sb.append("SMALLER");
                break;
            }
            case 45: {
                sb.append("SMALLER_EQUAL");
                break;
            }
            case 46: {
                sb.append("NOT_EQUAL");
                break;
            }
            case 49: {
                sb.append("AND");
                break;
            }
            case 50: {
                sb.append("OR");
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                sb.append("MATCH");
                break;
            }
            case 47: {
                sb.append("IS").append(' ').append("NULL");
                break;
            }
            case 57: {
                sb.append("UNIQUE");
                break;
            }
            case 55: {
                sb.append("EXISTS");
                break;
            }
            case 56: {
                sb.append("OVERLAPS");
                break;
            }
            case 117: {
                sb.append("@>");
                break;
            }
            case 118: {
                sb.append("<@");
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        if (this.isQuantified && this.nodes[1].opType == 30 && this.nodes[1] instanceof ExpressionTable && this.nodes[1].nodes[0].opType == 8) {
            this.nodes[0].resolveTypes(session, this);
            this.nodes[1].nodes[0].dataType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: 
            case 120: 
            case 121: {
                this.resolveTypesForComparison(session, parent);
                break;
            }
            case 49: {
                Object value;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object value2 = this.nodes[0].getValue(session);
                    if (value2 != null && !Boolean.FALSE.equals(value2)) break;
                    this.setAsConstantValue(Boolean.FALSE);
                    break;
                }
                if (this.nodes[1].opType != 1 || (value = this.nodes[1].getValue(session)) != null && !Boolean.FALSE.equals(value)) break;
                this.setAsConstantValue(Boolean.FALSE);
                break;
            }
            case 50: {
                Object value;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object value3 = this.nodes[0].getValue(session);
                    if (!Boolean.TRUE.equals(value3)) break;
                    this.setAsConstantValue(Boolean.TRUE);
                    break;
                }
                if (this.nodes[1].opType != 1 || !Boolean.TRUE.equals(value = this.nodes[1].getValue(session))) break;
                this.setAsConstantValue(Boolean.TRUE);
                break;
            }
            case 47: {
                if (this.nodes[0].isUnresolvedParam()) {
                    if (session.dataspaceStore.sqlEnforceTypes) {
                        throw Error.error(5563);
                    }
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 48: {
                if (this.nodes[0].isUnresolvedParam()) {
                    this.nodes[0].dataType = Type.SQL_BOOLEAN;
                    break;
                }
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[0].dataType != null && this.nodes[0].dataType.isBooleanType()) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null || !this.nodes[0].dataType.isBooleanType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 114: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 56: {
                this.resolveTypesForOverlaps();
                break;
            }
            case 117: 
            case 118: {
                this.resolveTypesForArrayContains(session);
                break;
            }
            case 54: {
                this.resolveTypesForIn(session);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 55: 
            case 57: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    private void resolveTypesForLogicalOp() {
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5571);
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25) {
            throw Error.error(5565);
        }
        if (Type.SQL_BOOLEAN != this.nodes[0].dataType || Type.SQL_BOOLEAN != this.nodes[1].dataType) {
            throw Error.error(5568);
        }
    }

    private void resolveTypesForComparison(Session session, Expression parent) {
        Object rightValue;
        if (this.opType == 58 || this.exprSubType == 51 || this.exprSubType == 52) {
            this.resolveTypesForAllAny(session);
            this.checkRowComparison();
            return;
        }
        int leftDegree = this.nodes[0].getDegree();
        int rightDegree = this.nodes[1].getDegree();
        if (leftDegree > 1 || rightDegree > 1) {
            if (leftDegree != rightDegree) {
                throw Error.error(5564);
            }
            this.resolveRowTypes();
            this.checkRowComparison();
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup && !this.convertDateTimeLiteral(session, this.nodes[0], this.nodes[1])) {
            if (this.nodes[0].dataType.isBitType() || this.nodes[0].dataType.isBooleanType()) {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isBitType() || this.nodes[1].dataType.isBooleanType()) {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isNumberType()) {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isNumberType()) {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0]);
                }
            } else if (this.nodes[0].dataType.isObjectType()) {
                var5_5 = (OtherType)this.nodes[0].dataType;
            } else if (this.nodes[1].dataType.isObjectType()) {
                var5_5 = (OtherType)this.nodes[1].dataType;
            } else if (this.nodes[0].dataType.typeCode == 1122) {
                var5_5 = this.nodes[1].dataType;
            } else {
                throw Error.error(5562);
            }
        }
        if (this.opType != 41 && this.opType != 46 && (this.nodes[0].dataType.isLobType() || this.nodes[1].dataType.isLobType())) {
            throw Error.error(5534);
        }
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session);
        }
        if (this.nodes.length == 2 && this.nodes[0].opType == 14 && this.nodes[1].opType == 1) {
            this.isTerminal = true;
        }
        if (this.nodes.length == 2 && this.nodes[1].opType == 1 && this.opType == 41 && (rightValue = this.nodes[1].getValue(session)) == null) {
            this.opType = 47;
        }
        if (this.nodes.length == 2 && this.nodes[1].opType == 1 && this.opType == 46 && (rightValue = this.nodes[1].getValue(session)) == null) {
            this.opType = 48;
            Expression e = this.nodes[0];
            this.nodes = new Expression[1];
            this.dataType = Type.SQL_BOOLEAN;
            this.nodes[0] = e = new ExpressionLogical(47, e);
        }
    }

    private void resolveRowTypes() {
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type leftType = this.nodes[0].nodeDataTypes[i];
            Type rightType = this.nodes[1].nodeDataTypes[i];
            if (leftType == null) {
                leftType = this.nodes[0].nodeDataTypes[i] = rightType;
            } else if (this.nodes[1].dataType == null) {
                rightType = this.nodes[1].nodeDataTypes[i] = leftType;
            }
            if (leftType == null || rightType == null) {
                throw Error.error(5567);
            }
            if (leftType.typeComparisonGroup != rightType.typeComparisonGroup) {
                throw Error.error(5562);
            }
            if (!leftType.isDateTimeType() || !(leftType.isDateTimeTypeWithZone() ^ rightType.isDateTimeTypeWithZone())) continue;
            this.nodes[0].nodes[i] = new ExpressionOp(this.nodes[0].nodes[i]);
            this.nodes[0].nodeDataTypes[i] = this.nodes[0].nodes[i].dataType;
        }
    }

    void checkRowComparison() {
        if (this.opType == 41 || this.opType == 46) {
            return;
        }
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type leftType = this.nodes[0].nodeDataTypes[i];
            Type rightType = this.nodes[1].nodeDataTypes[i];
            if (!leftType.isArrayType() && !leftType.isLobType() && !rightType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private boolean convertDateTimeLiteral(Session session, Expression a, Expression b) {
        if (!a.dataType.isDateTimeType()) {
            if (b.dataType.isDateTimeType()) {
                Expression c = a;
                a = b;
                b = c;
            } else {
                return false;
            }
        }
        if (a.dataType.isDateTimeTypeWithZone()) {
            return false;
        }
        if (b.opType == 1 && b.dataType.isCharacterType()) {
            block7: {
                try {
                    b.valueData = a.dataType.castToType(session, b.valueData, b.dataType);
                    b.dataType = a.dataType;
                }
                catch (DataspaceException e) {
                    if (a.dataType != Type.SQL_DATE) break block7;
                    b.valueData = Type.SQL_TIMESTAMP.castToType(session, b.valueData, b.dataType);
                    b.dataType = Type.SQL_TIMESTAMP;
                }
            }
            return true;
        }
        return false;
    }

    void resolveTypesForOverlaps() {
        if (this.nodes[0].nodes[0].isUnresolvedParam()) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[0].isUnresolvedParam()) {
            this.nodes[1].nodes[0].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (this.nodes[0].nodes[0].dataType == null) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType = Type.SQL_TIMESTAMP;
        }
        if (this.nodes[0].nodes[1].isUnresolvedParam()) {
            this.nodes[0].nodes[1].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[1].isUnresolvedParam()) {
            this.nodes[1].nodes[1].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType) || !DTIType.isValidDatetimeRange(this.nodes[1].nodes[0].dataType, this.nodes[1].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        this.nodes[0].nodeDataTypes[0] = this.nodes[0].nodes[0].dataType;
        this.nodes[0].nodeDataTypes[1] = this.nodes[0].nodes[1].dataType;
        this.nodes[1].nodeDataTypes[0] = this.nodes[1].nodes[0].dataType;
        this.nodes[1].nodeDataTypes[1] = this.nodes[1].nodes[1].dataType;
    }

    void resolveTypesForAllAny(Session session) {
        int degree = this.nodes[0].getDegree();
        if (degree == 1 && this.nodes[0].opType != 25) {
            this.nodes[0] = new Expression(25, new Expression[]{this.nodes[0]});
        }
        if (this.nodes[1].opType == 26) {
            this.nodes[1].prepareTable(session, this.nodes[0], degree);
            this.nodes[1].subQuery.prepareTable(session);
            if (this.nodes[1].isCorrelated) {
                this.nodes[1].subQuery.setCorrelated();
            }
        }
        if (this.nodes[1].nodeDataTypes == null) {
            this.nodes[1].prepareTable(session, this.nodes[0], degree);
        }
        if (degree != this.nodes[1].nodeDataTypes.length) {
            throw Error.error(5564);
        }
        if (this.nodes[1].opType == 26) {
            // empty if block
        }
        this.nodes[0].nodeDataTypes = new Type[this.nodes[0].nodes.length];
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodes[i].dataType;
            if (type == null) {
                type = this.nodes[1].nodeDataTypes[i];
            }
            if (type == null) {
                throw Error.error(5567);
            }
            if (type.typeComparisonGroup != this.nodes[1].nodeDataTypes[i].typeComparisonGroup && this.nodes[1].nodeDataTypes[i].typeComparisonGroup != 1111) {
                throw Error.error(5563);
            }
            this.nodes[0].nodeDataTypes[i] = type;
            this.nodes[0].nodes[i].dataType = type;
        }
    }

    void resolveTypesForArrayContains(Session session) {
        if (!this.nodes[0].dataType.isArrayType() || !this.nodes[1].dataType.isArrayType()) {
            throw Error.error(5563);
        }
    }

    void resolveTypesForIn(Session session) {
        this.resolveTypesForAllAny(session);
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                return session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
            case 47: {
                Object value = this.nodes[0].getValue(session);
                if (value != null && value instanceof OtherTypeWrapper) {
                    value = ((OtherTypeWrapper)value).getObject();
                }
                return value == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 56: {
                Object[] left = this.nodes[0].getRowValue(session);
                Object[] right = this.nodes[1].getRowValue(session);
                return DateTimeType.overlaps(session, left, this.nodes[0].nodeDataTypes, right, this.nodes[1].nodeDataTypes);
            }
            case 117: {
                return this.arrayContains(session, this.nodes[0], this.nodes[1]);
            }
            case 118: {
                return this.arrayContains(session, this.nodes[1], this.nodes[0]);
            }
            case 54: {
                return this.testInCondition(session, this.nodes[0].getRowValue(session));
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return this.testMatchCondition(session, this.nodes[0].getRowValue(session));
            }
            case 57: {
                this.nodes[0].materialise(session);
                return this.nodes[0].subQuery.hasUniqueNotNullRows(session) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return this.testExistsCondition(session);
            }
            case 48: {
                Boolean result = (Boolean)this.nodes[0].getValue(session);
                return result == null ? null : (result != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 49: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.FALSE.equals(r1)) {
                    return Boolean.FALSE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(r2)) {
                    return Boolean.FALSE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.TRUE;
            }
            case 114: {
                Object obj = this.nodes[0].getValue(session);
                obj = this.nodes[0].getDataType().convertSQLToJava(session, obj);
                String typeName = (String)this.nodes[1].getValue(session);
                String errorMessage = "";
                try {
                    Class<?> clazz = session.sessionContext.typeAnalyzer.getClassBySemanticType(typeName);
                    if (clazz != null) {
                        if (clazz.isAssignableFrom(obj.getClass())) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                }
                catch (Exception error) {
                    errorMessage = error.getMessage();
                }
                throw new DataspaceException("Unable to resolve type '" + typeName + "'. " + errorMessage);
            }
            case 50: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(r1)) {
                    return Boolean.TRUE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(r2)) {
                    return Boolean.TRUE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: {
                Object o2;
                if (this.exprSubType == 52 || this.exprSubType == 51) {
                    Object[] rowData = this.nodes[0].getRowValue(session);
                    return this.testAllAnyCondition(session, rowData);
                }
                Object o1 = this.nodes[0].getValue(session);
                if (o1 instanceof OtherTypeWrapper) {
                    o1 = ((OtherTypeWrapper)o1).getObject();
                }
                if ((o2 = this.nodes[1].getValue(session)) instanceof OtherTypeWrapper) {
                    o2 = ((OtherTypeWrapper)o2).getObject();
                }
                if (o1 instanceof Object[]) {
                    if (o2 != null && !(o2 instanceof Object[])) {
                        throw Error.runtimeError(201, "ExpressionLogical");
                    }
                    return this.compareValues(session, (Object[])o1, (Object[])o2);
                }
                if (o2 instanceof Object[]) {
                    if (o1 != null && !(o1 instanceof Object[])) {
                        throw Error.runtimeError(201, "ExpressionLogical");
                    }
                    return this.compareValues(session, (Object[])o1, (Object[])o2);
                }
                if (o2 instanceof Object[]) {
                    o2 = ((Object[])o2)[0];
                }
                return this.compareValues(session, o1, o2);
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object left, Object right) {
        int result = 0;
        if (left == null || right == null) {
            return null;
        }
        result = this.nodes[0].dataType.compare(session, left, right);
        switch (this.opType) {
            case 41: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return result != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object[] leftList, Object[] rightList) {
        int result = 0;
        boolean hasNull = false;
        if (rightList == null || rightList == null) {
            return null;
        }
        for (int i = 0; i < leftList.length && i < rightList.length; ++i) {
            if (leftList[i] == null && (this.opType == 60 || this.opType == 63)) continue;
            Object leftValue = leftList[i];
            Object rightValue = rightList[i];
            Type leftType = null;
            if (this.nodes[0].nodeDataTypes != null && i < this.nodes[0].nodeDataTypes.length) {
                leftType = this.nodes[0].nodeDataTypes[i];
            }
            if (leftType == null && this.nodes[0].nodes != null && i < this.nodes[0].nodes.length) {
                leftType = this.nodes[0].nodes[i].dataType;
            }
            if (leftType == null && this.nodes[0].dataType != null && this.nodes[0].dataType.isArrayType()) {
                leftType = this.nodes[0].dataType.collectionBaseType();
            }
            if (leftType == null) {
                throw new DataspaceException("Cannot resolve element type of left array.");
            }
            Type rightType = null;
            if (this.nodes[1].nodeDataTypes != null && i < this.nodes[1].nodeDataTypes.length) {
                rightType = this.nodes[1].nodeDataTypes[i];
            }
            if (rightType == null && this.nodes[1].nodes != null && i < this.nodes[1].nodes.length) {
                rightType = this.nodes[1].nodes[i].dataType;
            }
            if (rightType == null && this.nodes[1].dataType != null && this.nodes[1].dataType.isArrayType()) {
                rightType = this.nodes[1].dataType.collectionBaseType();
            }
            if (rightType == null) {
                throw new DataspaceException("Cannot resolve element type of roght array.");
            }
            result = leftType.compare(session, leftValue, leftType.convertToType(session, rightValue, rightType));
            if (result != 0) break;
        }
        switch (this.opType) {
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 54: {
                if (hasNull) {
                    return null;
                }
                return result == 0 && leftList.length == rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                if (hasNull) {
                    return null;
                }
                return result != 0 || leftList.length != rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                if (hasNull) {
                    return null;
                }
                return result > 0 && leftList.length >= rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                if (hasNull) {
                    return null;
                }
                return result >= 0 && leftList.length >= rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                if (hasNull) {
                    return null;
                }
                return result <= 0 && leftList.length <= rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                if (hasNull) {
                    return null;
                }
                return result < 0 && leftList.length <= rightList.length ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean arrayContains(Session session, Expression leftNode, Expression rightNode) {
        Object[] left = (Object[])leftNode.getValue(session);
        Object[] right = (Object[])rightNode.getValue(session);
        if (left == null || right == null) {
            return false;
        }
        if (left.length < right.length) {
            return false;
        }
        Type leftType = leftNode.dataType.collectionBaseType();
        Type rightType = rightNode.dataType.collectionBaseType();
        for (int i = 0; i < right.length; ++i) {
            boolean contains = false;
            for (int j = 0; j < left.length; ++j) {
                if (leftType.compare(session, left[j], leftType.convertToType(session, right[i], rightType)) != 0) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    private Boolean testInCondition(Session session, Object[] data) {
        if (data == null) {
            return null;
        }
        if (Expression.countNulls(data) != 0) {
            return null;
        }
        if (this.nodes[1].opType == 26) {
            int length = this.nodes[1].nodes.length;
            for (int i = 0; i < length; ++i) {
                Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                if (!Boolean.TRUE.equals(this.compareValues(session, data, rowData))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testMatchCondition(Session session, Object[] data) {
        if (data == null) {
            return Boolean.TRUE;
        }
        int nulls = ExpressionLogical.countNulls(data);
        if (nulls != 0) {
            switch (this.opType) {
                case 59: 
                case 62: {
                    return Boolean.TRUE;
                }
                case 60: 
                case 63: {
                    if (nulls != data.length) break;
                    return Boolean.TRUE;
                }
                case 61: 
                case 64: {
                    return nulls == data.length ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (this.nodes[1].opType == 26) {
            int length = this.nodes[1].nodes.length;
            boolean hasMatch = false;
            for (int i = 0; i < length; ++i) {
                Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                Boolean result = this.compareValues(session, data, rowData);
                if (result == null || !result.booleanValue()) continue;
                switch (this.opType) {
                    case 59: 
                    case 60: 
                    case 61: {
                        return Boolean.TRUE;
                    }
                    case 62: 
                    case 63: 
                    case 64: {
                        if (hasMatch) {
                            return Boolean.FALSE;
                        }
                        hasMatch = true;
                    }
                }
            }
            return hasMatch ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.nodes[1].opType == 1 || this.nodes[1].opType == 6 || this.nodes[1].opType == 2) {
            Object value = this.nodes[1].getValue(session);
            if ((value = OtherTypeWrapper.unwrap(value)) instanceof Collection || value instanceof Object[]) {
                boolean hasMatch = false;
                Object[] array = value instanceof Collection ? ((Collection)value).toArray(new Object[0]) : (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    Boolean result = this.compareValues(session, data, new Object[]{array[i]});
                    if (result == null || !result.booleanValue()) continue;
                    switch (this.opType) {
                        case 59: 
                        case 60: 
                        case 61: {
                            return Boolean.TRUE;
                        }
                        case 62: 
                        case 63: 
                        case 64: {
                            if (hasMatch) {
                                return Boolean.FALSE;
                            }
                            hasMatch = true;
                        }
                    }
                }
                return hasMatch ? Boolean.TRUE : Boolean.FALSE;
            }
            Object[] rowData = new Object[]{value};
            Boolean result = this.compareValues(session, data, rowData);
            return result != null && result != false ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.nodes[1].opType == 23) {
            PersistentStore store = this.nodes[1].getTable().getRowStore(session);
            this.nodes[1].materialise(session);
            ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
            if (nulls != 0 && (this.opType == 60 || this.opType == 63)) {
                boolean hasMatch = false;
                RowIterator it = this.nodes[1].getTable().rowIterator(session);
                while (it.hasNext()) {
                    Object[] rowData = it.getNextRow().getData();
                    Boolean result = this.compareValues(session, data, rowData);
                    if (result == null || !result.booleanValue()) continue;
                    if (this.opType == 60) {
                        return Boolean.TRUE;
                    }
                    if (hasMatch) {
                        return Boolean.FALSE;
                    }
                    hasMatch = true;
                }
                return hasMatch ? Boolean.TRUE : Boolean.FALSE;
            }
            RowIterator it = this.nodes[1].getTable().getPrimaryIndex().findFirstRow(session, store, data);
            boolean result = it.hasNext();
            if (!result) {
                return Boolean.FALSE;
            }
            switch (this.opType) {
                case 59: 
                case 60: 
                case 61: {
                    return Boolean.TRUE;
                }
            }
            it.getNextRow();
            result = it.hasNext();
            if (!result) {
                return Boolean.TRUE;
            }
            Object[] rowData = it.getNextRow().getData();
            Boolean returnValue = Boolean.TRUE.equals(this.compareValues(session, data, rowData)) ? Boolean.FALSE : Boolean.TRUE;
            return returnValue;
        }
        throw Error.error(5564);
    }

    private Boolean testExistsCondition(Session session) {
        this.nodes[0].materialise(session);
        return this.nodes[0].getTable().isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAllAnyCondition(Session session, Object[] o) {
        SubQuery subquery = this.nodes[1].subQuery;
        subquery.materialiseCorrelated(session);
        Boolean result = this.getAllAnyValue(session, o, subquery);
        return result;
    }

    private Boolean getAllAnyValue(Session session, Object[] data, SubQuery subquery) {
        TableDerived table = subquery.getTable();
        boolean empty = table.isEmpty(session);
        Index index = table.getFullIndex();
        PersistentStore store = table.getRowStore(session);
        Row lastrow = index.lastRow(session, store).getNextRow();
        switch (this.exprSubType) {
            case 52: {
                if (empty) {
                    return Boolean.FALSE;
                }
                if (ExpressionLogical.countNulls(data) == data.length) {
                    return null;
                }
                Object[] lastdata = lastrow.getData();
                if (ExpressionLogical.countNulls(lastdata) == data.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                if (this.opType == 41) {
                    RowIterator it = index.findFirstRow(session, store, data);
                    return it.hasNext() ? Boolean.TRUE : Boolean.FALSE;
                }
                RowIterator it = index.findFirstRowNotNull(session, store);
                Row firstrow = it.getNextRow();
                Object[] firstdata = firstrow.getData();
                Boolean comparefirst = this.compareValues(session, data, firstdata);
                Boolean comparelast = this.compareValues(session, data, lastdata);
                switch (this.opType) {
                    case 46: {
                        return Boolean.TRUE.equals(comparefirst) || Boolean.TRUE.equals(comparelast) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 43: {
                        return comparefirst;
                    }
                    case 42: {
                        return comparefirst;
                    }
                    case 44: {
                        return comparelast;
                    }
                    case 45: {
                        return comparelast;
                    }
                }
                break;
            }
            case 51: {
                if (empty) {
                    return Boolean.TRUE;
                }
                if (ExpressionLogical.countNulls(data) == data.length) {
                    return null;
                }
                RowIterator it = index.firstRow(session, store);
                Row firstrow = it.getNextRow();
                Object[] firstdata = firstrow.getData();
                if (ExpressionLogical.countNulls(firstdata) == data.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                it = index.findFirstRow(session, store, data);
                if (this.opType == 41) {
                    if (it.hasNext()) {
                        return store.elementCount(session) == 1L ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return Boolean.FALSE;
                }
                if (this.opType == 46) {
                    return it.hasNext() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] lastdata = lastrow.getData();
                Boolean comparefirst = this.compareValues(session, data, firstdata);
                Boolean comparelast = this.compareValues(session, data, lastdata);
                switch (this.opType) {
                    case 43: {
                        return comparelast;
                    }
                    case 42: {
                        return comparelast;
                    }
                    case 44: {
                        return comparefirst;
                    }
                    case 45: {
                        return comparefirst;
                    }
                }
                break;
            }
        }
        return null;
    }

    void distributeOr() {
        if (this.opType != 50) {
            return;
        }
        if (this.nodes[0].opType == 49) {
            this.opType = 49;
            ExpressionLogical temp = new ExpressionLogical(50, this.nodes[0].nodes[1], this.nodes[1]);
            this.nodes[0].opType = 50;
            this.nodes[0].nodes[1] = this.nodes[1];
            this.nodes[1] = temp;
        } else if (this.nodes[1].opType == 49) {
            Expression temp = this.nodes[0];
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = temp;
            this.distributeOr();
            return;
        }
        ((ExpressionLogical)this.nodes[0]).distributeOr();
        ((ExpressionLogical)this.nodes[1]).distributeOr();
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVar) {
        switch (this.opType) {
            case 49: {
                return this.nodes[0].isIndexable(rangeVar) || this.nodes[1].isIndexable(rangeVar);
            }
            case 50: {
                return this.nodes[0].isIndexable(rangeVar) && this.nodes[1].isIndexable(rangeVar);
            }
        }
        Expression temp = this.getIndexableExpression(rangeVar);
        return temp != null;
    }

    @Override
    public Expression getIndexableExpression(RangeVariable rangeVar) {
        switch (this.opType) {
            case 47: {
                return this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVar) ? this : null;
            }
            case 48: {
                return this.nodes[0].opType == 47 && this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].isIndexable(rangeVar) ? this : null;
            }
            case 41: {
                if (this.exprSubType == 52) {
                    if (this.nodes[1].isCorrelated) {
                        return null;
                    }
                    for (int node = 0; node < this.nodes[0].nodes.length; ++node) {
                        if (this.nodes[0].nodes[node].opType != 2 || !this.nodes[0].nodes[node].isIndexable(rangeVar)) continue;
                        return this;
                    }
                    return null;
                }
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.exprSubType != 0 && this.exprSubType != 53) {
                    return null;
                }
                if (this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVar)) {
                    if (this.nodes[1].hasReference(rangeVar)) {
                        return null;
                    }
                    return this;
                }
                if (this.nodes[0].hasReference(rangeVar)) {
                    return null;
                }
                if (this.nodes[1].opType == 2 && this.nodes[1].isIndexable(rangeVar)) {
                    this.swapCondition();
                    return this;
                }
                return null;
            }
            case 50: {
                if (this.isIndexable(rangeVar)) {
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    boolean isSimpleBound() {
        if (this.opType == 47) {
            return true;
        }
        if (this.nodes[1] != null) {
            if (this.nodes[1].opType == 1) {
                return true;
            }
            if (this.nodes[1].opType == 28 && ((FunctionSQL)this.nodes[1]).isValueFunction()) {
                return true;
            }
        }
        return false;
    }

    boolean convertToSmaller() {
        switch (this.opType) {
            case 42: 
            case 43: {
                this.swapCondition();
                return true;
            }
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    void swapCondition() {
        int i = 41;
        switch (this.opType) {
            case 42: {
                i = 45;
                break;
            }
            case 45: {
                i = 42;
                break;
            }
            case 44: {
                i = 43;
                break;
            }
            case 43: {
                i = 44;
                break;
            }
            case 58: {
                i = 58;
                break;
            }
            case 41: 
            case 120: 
            case 121: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.opType = i;
        Expression e = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = e;
    }

    boolean reorderComparison(Session session, Expression parent) {
        Expression colExpression = null;
        Expression nonColExpression = null;
        boolean left = false;
        boolean replaceColumn = false;
        int operation = 0;
        if (this.nodes[0].opType == 32) {
            operation = 33;
            left = true;
        } else if (this.nodes[0].opType == 33) {
            operation = 32;
            left = true;
        } else if (this.nodes[1].opType == 32) {
            operation = 33;
        } else if (this.nodes[1].opType == 33) {
            operation = 32;
        }
        if (operation == 0) {
            return false;
        }
        if (left) {
            if (this.nodes[0].nodes[0].opType == 2) {
                colExpression = this.nodes[0].nodes[0];
                nonColExpression = this.nodes[0].nodes[1];
            } else if (this.nodes[0].nodes[1].opType == 2) {
                replaceColumn = operation == 32;
                colExpression = this.nodes[0].nodes[1];
                nonColExpression = this.nodes[0].nodes[0];
            }
        } else if (this.nodes[1].nodes[0].opType == 2) {
            colExpression = this.nodes[1].nodes[0];
            nonColExpression = this.nodes[1].nodes[1];
        } else if (this.nodes[1].nodes[1].opType == 2) {
            replaceColumn = operation == 32;
            colExpression = this.nodes[1].nodes[1];
            nonColExpression = this.nodes[1].nodes[0];
        }
        if (colExpression == null) {
            return false;
        }
        Expression otherExpression = left ? this.nodes[1] : this.nodes[0];
        ExpressionArithmetic newArg = null;
        if (!replaceColumn) {
            newArg = new ExpressionArithmetic(operation, otherExpression, nonColExpression);
            newArg.resolveTypesForArithmetic(session, parent);
        }
        if (left) {
            if (replaceColumn) {
                this.nodes[1] = colExpression;
                this.nodes[0].nodes[1] = otherExpression;
                ((ExpressionArithmetic)this.nodes[0]).resolveTypesForArithmetic(session, parent);
            } else {
                this.nodes[0] = colExpression;
                this.nodes[1] = newArg;
            }
        } else if (replaceColumn) {
            this.nodes[0] = colExpression;
            this.nodes[1].nodes[1] = otherExpression;
            ((ExpressionArithmetic)this.nodes[1]).resolveTypesForArithmetic(session, parent);
        } else {
            this.nodes[1] = colExpression;
            this.nodes[0] = newArg;
        }
        return true;
    }

    boolean isConditionRangeVariable(RangeVariable range) {
        if (this.nodes[0].getRangeVariable() == range) {
            return true;
        }
        return this.nodes[1].getRangeVariable() == range;
    }

    @Override
    public RangeVariable[] getJoinRangeVariables(RangeVariable[] ranges) {
        OrderedHashSet set = new OrderedHashSet();
        this.collectRangeVariables(ranges, set);
        if (set != null) {
            this.rangeArray = new RangeVariable[set.size()];
            set.toArray(this.rangeArray);
        }
        return this.rangeArray;
    }

    @Override
    public double costFactor(Session session, RangeVariable rangeVar, int operation) {
        double cost;
        block0 : switch (this.opType) {
            case 50: {
                return this.nodes[0].costFactor(session, rangeVar, this.opType) + this.nodes[1].costFactor(session, rangeVar, this.opType);
            }
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 117: 
            case 118: {
                PersistentStore store = rangeVar.rangeTable.getRowStore(session);
                cost = store.elementCount();
                if (!(cost < 16.0)) break;
                cost = 16.0;
                break;
            }
            case 47: 
            case 48: {
                cost = this.costFactorUnaryColumn(session, rangeVar);
                break;
            }
            case 41: 
            case 120: 
            case 121: {
                switch (this.exprSubType) {
                    case 52: {
                        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
                            cost = this.costFactorColumns(session, rangeVar);
                            cost *= 1024.0;
                            break block0;
                        }
                    }
                    case 51: {
                        PersistentStore store = rangeVar.rangeTable.getRowStore(session);
                        cost = store.elementCount();
                        if (cost < 16.0) {
                            cost = 16.0;
                        }
                        cost *= 1024.0;
                        break block0;
                    }
                }
                cost = this.costFactorColumns(session, rangeVar);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                cost = this.costFactorColumns(session, rangeVar);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return cost;
    }

    double costFactorUnaryColumn(Session session, RangeVariable rangeVar) {
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
            return this.nodes[0].costFactor(session, rangeVar, this.opType);
        }
        PersistentStore store = rangeVar.rangeTable.getRowStore(session);
        double cost = store.elementCount();
        return cost < 16.0 ? 16.0 : cost;
    }

    double costFactorColumns(Session session, RangeVariable rangeVar) {
        PersistentStore store;
        double cost = 0.0;
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
            if (!this.nodes[1].hasReference(rangeVar)) {
                cost = this.nodes[0].costFactor(session, rangeVar, this.opType);
            }
        } else if (this.nodes[1].opType == 2 && this.nodes[1].getRangeVariable() == rangeVar) {
            if (!this.nodes[0].hasReference(rangeVar)) {
                cost = this.nodes[1].costFactor(session, rangeVar, this.opType);
            }
        } else {
            store = rangeVar.rangeTable.getRowStore(session);
            cost = store.elementCount();
        }
        if (cost == 0.0) {
            store = rangeVar.rangeTable.getRowStore(session);
            cost = store.elementCount();
        }
        if (cost < 16.0) {
            cost = 16.0;
        }
        return cost;
    }
}

