/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.Like;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ExpressionLike
extends ExpressionLogical {
    private static final int ESCAPE = 2;
    private Like likeObject;

    public ExpressionLike(Expression left, Expression right, Expression escape, boolean noOptimisation) {
        super(53);
        this.nodes = new Expression[3];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.nodes[2] = escape;
        this.likeObject = new Like();
        this.noOptimisation = noOptimisation;
    }

    private ExpressionLike(ExpressionLike other) {
        super(53);
        this.nodes = other.nodes;
        this.likeObject = other.likeObject;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Session session) {
        Object escapeValue;
        if (this.opType != 53) {
            return super.getValue(session);
        }
        Object leftValue = this.nodes[0].getValue(session);
        Object rightValue = this.nodes[1].getValue(session);
        Object object = escapeValue = this.nodes[2] == null ? null : this.nodes[2].getValue(session);
        if (this.likeObject.isVariable) {
            Like like = this.likeObject;
            synchronized (like) {
                this.likeObject.setPattern(session, rightValue, escapeValue, this.nodes[2] != null);
                return this.likeObject.compare(session, leftValue);
            }
        }
        return this.likeObject.compare(session, leftValue);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        boolean isRightArgFixedConstant;
        if (this.opType != 53) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        boolean isEscapeFixedConstant = true;
        if (this.nodes[2] != null) {
            if (this.nodes[2].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            this.nodes[2].resolveTypes(session, this);
            boolean bl = isEscapeFixedConstant = this.nodes[2].opType == 1;
            if (isEscapeFixedConstant) {
                this.nodes[2].setAsConstantValue(session);
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[2].valueData != null) {
                    if ((switch (this.nodes[2].dataType.typeCode) {
                        case 1, 12 -> ((String)this.nodes[2].valueData).length();
                        case 60, 61 -> ((BinaryData)this.nodes[2].valueData).length(session);
                        default -> throw Error.error(5563);
                    }) != 1L) {
                        throw Error.error(3439);
                    }
                }
            }
        }
        if (this.nodes[0].isUnresolvedParam() && this.nodes[1].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType == null && this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType.isBinaryType() ? Type.SQL_VARBINARY_DEFAULT : Type.SQL_VARCHAR_DEFAULT;
        } else if (this.nodes[1].isUnresolvedParam()) {
            Type type = this.nodes[1].dataType = this.nodes[0].dataType.isBinaryType() ? Type.SQL_VARBINARY_DEFAULT : Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        switch (this.nodes[0].dataType.typeComparisonGroup) {
            case 12: {
                if (this.nodes[1].dataType.isCharacterType() && (this.nodes[2] == null || this.nodes[2].dataType.isCharacterType())) {
                    boolean ignoreCase = this.nodes[0].dataType.typeCode == 100 || this.nodes[1].dataType.typeCode == 100;
                    this.likeObject.setIgnoreCase(ignoreCase);
                    break;
                }
                throw Error.error(5563);
            }
            case 61: {
                if (this.nodes[1].dataType.isBinaryType() && (this.nodes[2] == null || this.nodes[2].dataType.isBinaryType())) {
                    this.likeObject.isBinary = true;
                    break;
                }
                throw Error.error(5563);
            }
            case 1111: {
                throw Error.error(5563);
            }
            default: {
                if (session.dataspaceStore.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], Type.SQL_VARCHAR_DEFAULT);
                if (this.nodes[1].dataType.isCharacterType() && (this.nodes[2] == null || this.nodes[2].dataType.isCharacterType())) {
                    boolean ignoreCase = this.nodes[1].dataType.typeCode == 100;
                    this.likeObject.setIgnoreCase(ignoreCase);
                    break;
                }
                throw Error.error(5563);
            }
        }
        this.likeObject.dataType = this.nodes[0].dataType;
        boolean bl = isRightArgFixedConstant = this.nodes[1].opType == 1;
        if (isRightArgFixedConstant && isEscapeFixedConstant) {
            if (this.nodes[0].opType == 1) {
                this.setAsConstantValue(session);
                this.likeObject = null;
                return;
            }
            this.likeObject.isVariable = false;
        }
        Object pattern = isRightArgFixedConstant ? this.nodes[1].getValue(session) : null;
        boolean constantEscape = isEscapeFixedConstant && this.nodes[2] != null;
        Object escape = constantEscape ? this.nodes[2].getValue(session) : null;
        this.likeObject.setPattern(session, pattern, escape, this.nodes[2] != null);
        if (this.noOptimisation) {
            return;
        }
        if (this.likeObject.isEquivalentToUnknownPredicate()) {
            this.setAsConstantValue(session);
            this.likeObject = null;
            return;
        }
        if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.opType = 41;
            this.nodes[1] = new ExpressionValue(this.likeObject.getRangeLow(), Type.SQL_VARCHAR);
            this.likeObject = null;
            return;
        }
        if (this.likeObject.isEquivalentToNotNullPredicate()) {
            ExpressionLogical notNull = new ExpressionLogical(47, this.nodes[0]);
            this.opType = 48;
            this.nodes = new Expression[1];
            this.nodes[0] = notNull;
            this.likeObject = null;
            return;
        }
        if (this.nodes[0].opType == 2) {
            ExpressionLike newLike = new ExpressionLike(this);
            ExpressionOp prefix = new ExpressionOp(37, this.nodes[1], this.nodes[2]);
            ((Expression)prefix).resolveTypes(session, null);
            ExpressionOp cast = new ExpressionOp(84, this.nodes[0], prefix);
            ExpressionLogical equ = new ExpressionLogical(41, cast, prefix);
            equ = new ExpressionLogical(42, this.nodes[0], prefix, equ);
            ((Expression)equ).setSubType(53);
            this.nodes = new Expression[2];
            this.likeObject = null;
            this.nodes[0] = equ;
            this.nodes[1] = newLike;
            this.opType = 49;
        }
    }

    @Override
    public String getSQL() {
        if (this.likeObject == null) {
            return super.getSQL();
        }
        String left = ExpressionLike.getContextSQL(this.nodes[0]);
        String right = ExpressionLike.getContextSQL(this.nodes[1]);
        StringBuffer sb = new StringBuffer();
        sb.append(left).append(' ').append("LIKE").append(' ');
        sb.append(right);
        if (this.nodes[2] != null) {
            sb.append(' ').append("ESCAPE").append(' ');
            sb.append(this.nodes[2].getSQL());
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.likeObject == null) {
            return super.describeJson(session);
        }
        result.put("opType", "LIKE");
        result.put("likeObject", this.likeObject.describeJson(session));
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        if (this.likeObject == null) {
            return super.describe(session, blanks);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("LIKE ");
        sb.append(this.likeObject.describe(session));
        return sb.toString();
    }
}

