/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionExpand
extends Expression {
    private boolean withUnfold;

    public ExpressionExpand(Expression left, Expression right, boolean withUnfold) {
        super(26);
        this.withUnfold = withUnfold;
        this.nodes = new Expression[]{left, right};
    }

    @Override
    public Object getValue(Session session) {
        return new FacetsExpand((Facets)OtherTypeWrapper.unwrap(this.nodes[0].getValue(session)), (Facets)OtherTypeWrapper.unwrap(this.nodes[1].getValue(session)));
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("EXPAND").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
        builder.append(")");
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "EXPAND");
        ArrayList<Map<String, Object>> args = new ArrayList<Map<String, Object>>();
        args.add(this.nodes[0].describeJson(session));
        args.add(this.nodes[1].describeJson(session));
        result.put("args", args);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder(64);
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("EXPAND");
        builder.append(" facets=[");
        builder.append(this.nodes[0].describe(session, blanks + 1));
        builder.append(",");
        builder.append(this.nodes[1].describe(session, blanks + 1));
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Type getDataType() {
        return FacetsType.DEFAULT;
    }

    public boolean isWithUnfold() {
        return this.withUnfold;
    }

    public static class FacetsExpand {
        Facets left;
        Facets right;

        public FacetsExpand(Facets left, Facets right) {
            this.left = left;
            this.right = right;
        }
    }
}

