/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.fields.FieldAccessorByMethodExpression;
import com.streamscape.sef.evtrigger.function.fields.SpecificFieldAccessorsManager;
import com.streamscape.sef.evtrigger.function.fields.event.EventSpecificFieldAccessors;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionColumnAccessor
extends Expression {
    ColumnSchema column;
    String spath = null;
    int index = -1;
    public Expression root = null;
    public Method setMethod = null;
    private RangeVariable rangeVariable = null;

    public ExpressionColumnAccessor(ColumnSchema column) {
        super(2);
        this.column = column;
        this.dataType = column.getDataType();
    }

    public ExpressionColumnAccessor(ColumnSchema column, Expression root) {
        super(2);
        this.column = column;
        this.root = root;
    }

    public void setRangeVariable(RangeVariable rangeVariable) {
        this.rangeVariable = rangeVariable;
    }

    public void setSpath(String spath) {
        this.spath = spath;
    }

    public String getSpath() {
        return this.spath;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    String getAlias() {
        return this.column.getNameString();
    }

    @Override
    public void collectObjectNames(Set set) {
        set.add(this.column.getObjectName());
        if (this.column.getObjectName().parent != null) {
            set.add(this.column.getObjectName().parent);
        }
    }

    @Override
    public String getColumnName() {
        return this.column.getNameString();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    @Override
    public RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        try {
            Type actualType = this.column.getDataType();
            Object actualSpath = this.spath;
            if (this.root != null) {
                this.root.resolveTypes(session, parent);
                actualType = this.root.getDataType();
                actualSpath = "/" + this.spath;
            }
            if (this.spath != null) {
                Class<?> parentClass;
                if (actualType instanceof EventType && (((OtherType)actualType).userTypeModifier != null || ((OtherType)actualType).getInternalClass(session) != Object.class) && (parentClass = ((OtherType)actualType).getInternalClass(session)) != null) {
                    this.resolveSetMethodForClass(session, parentClass, this.spath);
                    if (this.setMethod != null) {
                        return;
                    }
                }
                if (actualType instanceof OtherType) {
                    Class<?> objectClass = ((OtherType)actualType).userTypeModifier != null ? this.resolveObjectClass(session, actualType) : ((OtherType)actualType).getInternalClass(session);
                    if (objectClass != null) {
                        this.resolveDataTypeFrom(session, objectClass, (String)actualSpath);
                    } else {
                        this.dataType = new OtherType();
                    }
                } else {
                    this.dataType = new OtherType();
                }
            } else {
                this.dataType = this.column.getDataType();
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            this.dataType = new OtherType();
        }
        if (this.dataType == null) {
            this.dataType = new OtherType();
        }
    }

    private Class<?> resolveObjectClass(Session session, Type objectType) throws Exception {
        String semanticType = objectType.getObjectName().name;
        String className = session.sessionContext.typeAnalyzer.getSemanticTypeCache().resolveSemanticType(semanticType);
        return ClassUtils.loadClass(className, DataspaceManager.getContext().getSystemClassLoaderChain());
    }

    public void resolveDataTypeFrom(Session session, Class<?> objectClass, String spath) {
        try {
            Class<?> fieldClass = session.sessionContext.typeAnalyzer.getFieldClass(objectClass, "/" + spath);
            this.dataType = ExpressionColumn.resolveType(session, fieldClass);
        }
        catch (Exception error) {
            this.dataType = Types.getParameterSQLType(session, Object.class);
        }
    }

    public void resolveSetMethodForClass(Session session, Class<?> clazz, String spath) {
        try {
            String fieldName = spath.substring(1);
            fieldName = EventSpecificFieldAccessors.resolveAlias(fieldName);
            SpecificFieldAccessorsManager.SpecificFieldInfo info = EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().lookupSpecificFieldsByFieldNameAndClass(fieldName, clazz);
            if (info != null) {
                this.setMethod = ClassUtils.getDeclaredOrInheritedMethod(info.clazz, info.setMethod, new Class[]{info.fieldType}, false);
            } else {
                Class<?> fieldType = session.sessionContext.typeAnalyzer.getFieldClass(clazz, "/" + spath);
                this.setMethod = ClassUtils.getDeclaredOrInheritedMethod(clazz, FieldAccessorByMethodExpression.getSetterName(fieldName), new Class[]{fieldType}, false);
            }
            if (this.setMethod != null) {
                this.dataType = ExpressionColumn.resolveType(session, this.setMethod.getParameters()[0].getType());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Method resolveGetMethodForField(Session session, Class<?> clazz, String fieldName) {
        try {
            fieldName = EventSpecificFieldAccessors.resolveAlias(fieldName);
            SpecificFieldAccessorsManager.SpecificFieldInfo info = EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().lookupSpecificFieldsByFieldNameAndClass(fieldName, clazz);
            if (info != null) {
                return ClassUtils.getDeclaredOrInheritedMethod(info.clazz, info.getMethod, new Class[0], false);
            }
            return ClassUtils.getDeclaredOrInheritedMethod(clazz, FieldAccessorByMethodExpression.getGetterName(fieldName), new Class[0], false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getValue(Session session) {
        Object value = null;
        value = this.root != null ? this.root.getValue(session) : session.sessionContext.routineVariables[this.index];
        value = OtherTypeWrapper.unwrap(value);
        if (this.spath != null) {
            try {
                value = session.sessionContext.sdrManager.getValueAtPath("//" + this.spath, value);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return OtherTypeWrapper.unwrap(value);
    }

    @Override
    public String getSQL() {
        return this.column.getObjectName().statementName;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "COLUMN ACCESSOR");
        result.put("columName", this.column.getObjectName().name);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        return this.column.getObjectName().name;
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        return unresolvedSet;
    }

    @Override
    public void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
    }

    @Override
    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        return this;
    }

    @Override
    public Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        return this;
    }

    @Override
    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        return -1;
    }

    @Override
    boolean hasReference(RangeVariable range) {
        return false;
    }

    @Override
    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType) {
            return false;
        }
        return this.column == other.getColumn();
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
    }

    @Override
    public void resetColumnReferences() {
    }

    @Override
    public boolean isIndexable(RangeVariable range) {
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return false;
    }

    @Override
    public boolean isDynamicParam() {
        return false;
    }

    @Override
    public Type getDataType() {
        return this.dataType;
    }

    @Override
    NameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.column != null) {
            return this.column.getObjectName();
        }
        return null;
    }
}

