/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.completion.EventPropertiesCompleter;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.AbstractLazyFlobFunctionExpression;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.FacetsSchemaObject;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.fields.SpecificFieldAccessorsManager;
import com.streamscape.sef.evtrigger.function.fields.event.EventSpecificFieldAccessors;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    static final NameManager.SimpleName rownumName = NameManager.getSimpleName("ROWNUM", false);
    public static final HashMappedList diagnosticsList = new HashMappedList();
    public static final String[] diagnosticsVariableTokens = new String[]{"NUMBER", "MORE", "ROW_COUNT"};
    public static final int idx_number = 0;
    public static final int idx_more = 1;
    public static final int idx_row_count = 2;
    private static ThreadLocal<List<QuerySpecification>> parentQuerySpecifications = new ThreadLocal();
    public ColumnSchema column;
    public String schema;
    public String tableName;
    public String columnName;
    public RangeVariable rangeVariable;
    public NumberSequence sequence;
    boolean isWritable;
    boolean isParam;
    String spath = null;
    Method getMethod = null;
    private boolean columnNameIsDelimiter;
    private boolean columnNameIsAtSign;

    public ExpressionColumn(String schema, String table, String column) {
        super(2);
        this.schema = schema;
        this.tableName = table;
        this.columnName = column;
    }

    public ExpressionColumn(ColumnSchema column) {
        super(2);
        this.column = column;
        this.dataType = column.getDataType();
        this.columnName = column.getObjectName().name;
    }

    public ExpressionColumn(RangeVariable rangeVar, int index) {
        super(2);
        this.columnIndex = index;
        this.setAutoAttributesAsColumn(rangeVar, this.columnIndex);
    }

    ExpressionColumn(Expression e, int colIndex, int rangePosition) {
        super(5);
        this.dataType = e.dataType;
        this.columnIndex = colIndex;
        this.alias = e.alias;
        this.rangePosition = rangePosition;
    }

    ExpressionColumn() {
        super(11);
    }

    public ExpressionColumn(int type) {
        super(type);
        if (type == 8) {
            this.isParam = true;
        } else if (type == 14) {
            this.columnName = ExpressionColumn.rownumName.name;
            this.dataType = Type.SQL_INTEGER;
        }
    }

    public ExpressionColumn(int type, int columnIndex) {
        super(type);
        this.column = (ColumnSchema)diagnosticsList.get(columnIndex);
        this.columnIndex = columnIndex;
        this.dataType = this.column.dataType;
    }

    public ExpressionColumn(ColumnSchema column, int columnIndex, String varName, String spath) {
        super(6);
        this.column = column;
        this.columnIndex = columnIndex;
        this.columnName = varName;
        this.spath = spath;
    }

    ExpressionColumn(Expression[] nodes, String name) {
        super(3);
        this.nodes = nodes;
        this.columnName = name;
    }

    public ExpressionColumn(String schema, String table) {
        super(97);
        this.schema = schema;
        this.tableName = table;
    }

    public ExpressionColumn(NumberSequence sequence, int opType) {
        super(opType);
        this.sequence = sequence;
        this.dataType = sequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.columnName = range.getColumnAlias((int)i).name;
        this.tableName = range.getTableAlias().name;
        this.rangeVariable = range;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.rangeVariable = range;
        if ((this.column.getDataType() instanceof ArrayType || this.column.getDataType() instanceof BinaryType) && "/length".equalsIgnoreCase(this.spath)) {
            this.dataType = Types.getParameterSQLType(null, Integer.TYPE);
        }
        if (range.rangeType == 1) {
            this.rangeVariable.addColumn(this.columnIndex);
        }
    }

    public void setSpath(String spath) {
        this.spath = spath;
    }

    public String getSpath() {
        return this.spath;
    }

    @Override
    public byte getNullability() {
        switch (this.opType) {
            case 2: {
                return this.column.getNullability();
            }
            case 3: 
            case 12: 
            case 14: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        this.column = column;
        this.dataType = column.getDataType();
        this.isWritable = isWritable;
    }

    @Override
    NameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.rangeVariable != null && this.rangeVariable.hasColumnAlias()) {
            return this.rangeVariable.getColumnAlias(this.columnIndex);
        }
        if (this.column != null) {
            return this.column.getObjectName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        if (this.opType == 14) {
            return rownumName;
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        switch (this.opType) {
            case 2: 
            case 3: 
            case 14: {
                return this.columnName;
            }
        }
        switch (this.opType) {
            case 6: {
                if (this.column == null) break;
                return this.column.getObjectName().name;
            }
        }
        return "";
    }

    public String getBaseColumnName() {
        if (this.opType == 2 && this.rangeVariable != null) {
            return this.rangeVariable.getTable().getColumn((int)this.columnIndex).getObjectName().name;
        }
        return null;
    }

    public NameManager.ObjectName getBaseColumnHsqlName() {
        return this.column.getObjectName();
    }

    @Override
    public void collectObjectNames(Set set) {
        switch (this.opType) {
            case 12: {
                NameManager.ObjectName name = this.sequence.getObjectName();
                set.add(name);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 97: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                if (this.column != null) {
                    set.add(this.column.getObjectName());
                    if (this.column.getObjectName().parent != null) {
                        set.add(this.column.getObjectName().parent);
                    }
                }
                return;
            }
        }
    }

    @Override
    public String getColumnName() {
        if ((this.opType == 2 || this.opType == 7) && this.column != null) {
            return this.column.getObjectName().name;
        }
        return this.getAlias();
    }

    public String getColumnNameWithAlias() {
        if ((this.opType == 2 || this.opType == 7) && this.column != null) {
            return this.column.getObjectName().name;
        }
        Object result = "";
        if (this.columnName != null) {
            result = this.columnName;
            if (this.alias != null) {
                result = (String)result + " as " + this.alias.name;
            }
        } else {
            result = this.getAlias();
        }
        return result;
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        switch (this.opType) {
            case 12: {
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 97: {
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean tableQualified;
                boolean resolved = false;
                boolean bl = tableQualified = this.tableName != null;
                if (this.rangeVariable != null) {
                    return unresolvedSet;
                }
                for (int i = 0; i < rangeCount; ++i) {
                    RangeVariable rangeVar = rangeVarArray[i];
                    if (rangeVar == null || this.opType == 7 || this.opType == 6 && rangeVar.rangeType != 3 && rangeVar.rangeType != 4 && rangeVar.rangeType != 5) continue;
                    if (rangeVar.getTable() != null && rangeVar.getTableAlias() != null && this.columnName != null && rangeVar.getTableAlias().name.equals(this.columnName) && this.spath != null) {
                        int index = this.spath.indexOf(47, 1);
                        if (index > 0) {
                            this.columnName = this.spath.substring(1, index);
                            this.spath = this.spath.substring(index);
                        } else {
                            this.columnName = this.spath.substring(1);
                            this.spath = null;
                        }
                    }
                    if (resolved) {
                        if (!session.dataspaceStore.sqlEnforceRefs || !this.resolvesDuplicateColumnReference(rangeVar)) continue;
                        String message = this.getColumnName();
                        if (this.alias != null) {
                            StringBuffer sb = new StringBuffer(message);
                            sb.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            message = sb.toString();
                        }
                        throw Error.error(5580, message);
                    }
                    if (!this.resolveColumnReference(rangeVar)) continue;
                    if (tableQualified) {
                        return unresolvedSet;
                    }
                    resolved = true;
                }
                if (!resolved && this.opType == 2 && session.sessionContext.currentCompoundStatement != null && session.sessionContext.currentCompoundStatement.hasImportedType(this.columnName)) {
                    resolved = true;
                }
                if (!resolved && this.opType == 2 && this.canBeStaticCall > 0 && session.dataspaceStore.schemaManager.getDomainOrDistinctType(this.columnName, "SYS", false) != null) {
                    resolved = true;
                }
                if (resolved) {
                    return unresolvedSet;
                }
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    private boolean resolveColumnReference(RangeVariable rangeVar) {
        int colIndex;
        if (rangeVar.getTable() instanceof VirtualTable && ((VirtualTable)rangeVar.getTable()).hasParameter(this.columnName)) {
            return true;
        }
        ExpressionColumn e = rangeVar.getColumnExpression(this.columnName);
        if (e != null) {
            this.opType = e.opType;
            this.nodes = e.nodes;
            this.dataType = e.dataType;
            return true;
        }
        if (rangeVar.rangeType == 2 && this.tableName == null && rangeVar.resolvesTableName(this.columnName) && this.spath != null && this.spath.length() > 0) {
            this.tableName = this.columnName;
            this.spath = this.spath.substring(1);
            int index = this.spath.indexOf(47, 0);
            if (index == -1) {
                this.columnName = this.spath;
                this.spath = null;
            } else {
                this.columnName = this.spath.substring(0, index);
                this.spath = this.spath.substring(index);
            }
        }
        if ((colIndex = rangeVar.findColumn(this)) == -1) {
            return false;
        }
        if (this.isColumnNameIsAtSign() && rangeVar.rangeType != 3 && rangeVar.rangeType != 4) {
            return false;
        }
        if (this.isColumnNameIsDelimiter() && (rangeVar.rangeType == 3 || rangeVar.rangeType == 4)) {
            return false;
        }
        switch (rangeVar.rangeType) {
            case 3: 
            case 4: {
                QuerySpecification parentQuerySpecification;
                if (this.tableName != null) {
                    return false;
                }
                ColumnSchema column = rangeVar.getColumn(colIndex);
                if (column.getParameterMode() == 4) {
                    return false;
                }
                int n = this.opType = rangeVar.rangeType == 4 ? 6 : 7;
                if (this.isColumnNameIsAtSign() || (parentQuerySpecification = ExpressionColumn.getParentQuerySpecification()) == null) break;
                for (RangeVariable rangeVariable : parentQuerySpecification.rangeVariables) {
                    if (rangeVariable == null || rangeVariable.rangeType != 1 || rangeVariable.rangeTable == null || rangeVariable.rangeTable.findColumn(column.getNameString()) == -1) continue;
                    throw Error.error(5612, new String[]{column.getNameString(), rangeVariable.rangeTable.getObjectName().getSchemaQualifiedStatementName() + "." + column.getNameString()});
                }
                break;
            }
            case 2: {
                if (this.tableName == null) {
                    return false;
                }
                if (this.schema != null) {
                    return false;
                }
                if (!rangeVar.resolvesTableName(this.tableName)) {
                    return false;
                }
                this.opType = 9;
                break;
            }
            case 5: {
                this.opType = 117;
                break;
            }
            default: {
                if (!rangeVar.resolvesSchemaName(this.schema)) {
                    return false;
                }
                if (rangeVar.resolvesTableName(this.tableName)) break;
                return false;
            }
        }
        this.setAttributesAsColumn(rangeVar, colIndex);
        switch (this.opType) {
            case 6: 
            case 7: 
            case 117: {
                this.futureFunctionSensitive = true;
            }
        }
        return true;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVar) {
        if (this.tableName == null) {
            ExpressionColumn e = rangeVar.getColumnExpression(this.columnName);
            if (e != null) {
                return false;
            }
            switch (rangeVar.rangeType) {
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            int colIndex = rangeVar.findColumn(this);
            return colIndex != -1;
        }
        return false;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 4: {
                if (parent == null || parent.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
            case 6: {
                this.resolveColumnDataTypeInternal(session);
                break;
            }
            case 2: {
                if (session.isCompleteMode()) {
                    if (this.column == null && this.tableName != null && this.columnName != null) {
                        int index;
                        com.streamscape.ds.schema.collection.Collection collection;
                        String schemaName = this.schema;
                        if (this.schema == null) {
                            schemaName = session.currentDataspace.name;
                        }
                        if ((collection = (com.streamscape.ds.schema.collection.Collection)session.dataspaceStore.schemaManager.findSchemaObject(this.tableName, schemaName, 4)) != null && (index = collection.getBaseTable().getColumnIndex(this.columnName)) != -1) {
                            this.column = collection.getBaseTable().getColumn(index);
                        }
                    }
                    if (this.column == null) break;
                    this.resolveColumnDataTypeInternal(session);
                    break;
                }
            }
            case 9: {
                if (this.column == null || !(this.column.getDataType() instanceof FlobType) && !(this.column.getDataType() instanceof FacetsType)) break;
                this.resolveColumnDataTypeInternal(session);
            }
        }
    }

    public void resolveColumnDataTypeInternal(Session session) {
        Object[] resolved = ExpressionColumn.resolveColumnDataTypeInternalStatic(session, this.spath, this.column);
        if (resolved[0] != null) {
            this.dataType = (Type)resolved[0];
        }
        this.spath = (String)resolved[1];
        this.getMethod = (Method)resolved[2];
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] resolveColumnDataTypeInternalStatic(Session session, String spath, ColumnSchema column) {
        Type dataType = null;
        if (spath != null) {
            if ((column.getDataType() instanceof ArrayType || column.getDataType() instanceof BinaryType) && ((String)spath).equals("/length")) {
                dataType = Types.getParameterSQLType(session, Integer.TYPE);
                return new Object[]{dataType, spath, null};
            }
            try {
                if (column.getDataType() instanceof EventType) {
                    Method getMethod;
                    String fieldName = ((String)spath).substring(1);
                    String fieldName2 = "";
                    if (fieldName.indexOf("/") != -1) {
                        fieldName2 = fieldName.substring(fieldName.indexOf("/"));
                        fieldName = fieldName.substring(0, fieldName.indexOf("/"));
                    }
                    fieldName = EventSpecificFieldAccessors.resolveAlias(fieldName);
                    spath = "/" + fieldName + fieldName2;
                    SpecificFieldAccessorsManager.SpecificFieldInfo info = EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().lookupSpecificFieldsByFieldNameAndClass(fieldName, column.getDataType().getInternalClass(session));
                    if (info != null && (getMethod = ClassUtils.getDeclaredOrInheritedMethod(info.clazz, info.getMethod, new Class[0], false)) != null) {
                        dataType = ExpressionColumn.resolveType(session, info.fieldType);
                        if (fieldName2.length() <= 0) return new Object[]{dataType, spath, getMethod};
                        dataType = ExpressionColumn.resolveDataType(session, getMethod.getReturnType(), fieldName2);
                        return new Object[]{dataType, spath, getMethod};
                    }
                } else if (column.getDataType() instanceof FlobType) {
                    if (((String)spath).equals("/location") || ((String)spath).equals("/filename")) {
                        dataType = Types.getParameterSQLType(session, String.class);
                    } else if (((String)spath).equals("/autotag")) {
                        dataType = Types.getParameterSQLType(session, Boolean.class);
                    } else if (((String)spath).equals("/linked")) {
                        dataType = Types.getParameterSQLType(session, Boolean.class);
                    } else if (((String)spath).equals("/id")) {
                        dataType = Types.getParameterSQLType(session, Long.class);
                    } else if (((String)spath).equals("/charset")) {
                        dataType = Types.getParameterSQLType(session, String.class);
                    } else if (((String)spath).equals("/size")) {
                        dataType = Types.getParameterSQLType(session, Integer.class);
                    } else if (((String)spath).equals("/usageCount")) {
                        dataType = Types.getParameterSQLType(session, Integer.class);
                    } else if (((String)spath).equals("/isManaged")) {
                        dataType = Types.getParameterSQLType(session, Boolean.class);
                    } else if (((String)spath).equals("/isValid")) {
                        dataType = Types.getParameterSQLType(session, Boolean.class);
                    }
                } else if (column.getDataType() instanceof FacetsType) {
                    FacetsSchemaObject facetsSchemaObject = ((FacetsType)column.getDataType()).getFacetsSchemaObject();
                    if (facetsSchemaObject != null) {
                        ColumnSchema keyColumn;
                        Object key = spath;
                        if (((String)key).startsWith("/")) {
                            key = ((String)key).substring(1);
                        }
                        if ((keyColumn = facetsSchemaObject.getColumnsMap().get(key)) != null) {
                            dataType = keyColumn.getDataType();
                            return new Object[]{dataType, spath, null};
                        }
                    }
                    dataType = Type.STRING;
                    return new Object[]{dataType, spath, null};
                }
                if (!(column.getDataType() instanceof OtherType) || ((OtherType)column.getDataType()).userTypeModifier == null) return new Object[]{dataType, spath, null};
                String semanticType = column.getDataType().getObjectName().name;
                String className = session.sessionContext.typeAnalyzer.getSemanticTypeCache().resolveSemanticType(semanticType);
                Class objectClass = ClassUtils.loadClass(className, DataspaceManager.getContext().getSystemClassLoaderChain());
                try {
                    dataType = ExpressionColumn.resolveDataType(session, objectClass, (String)spath);
                    return new Object[]{dataType, spath, null};
                }
                catch (Exception error) {
                    if (column.getDataType() instanceof EventType && ((EventType)column.getDataType()).getEventId() != null) {
                        String eventId = ((EventType)column.getDataType()).getEventId();
                        String propertyName = ((String)spath).substring(1);
                        TriggerFunctionParserContextImpl context = new TriggerFunctionParserContextImpl(DataspaceManager.getContext());
                        try {
                            ImmutableEventDatagram event = context.createEvent(eventId);
                            PropertyType propertyType = new EventPropertiesCompleter(objectClass, event, context).resolvePropertyType(((String)spath).substring(1));
                            if (propertyType != null) {
                                void var13_30;
                                Object var13_20 = null;
                                switch (propertyType) {
                                    case BigDecimal: {
                                        Class<BigDecimal> clazz = BigDecimal.class;
                                        break;
                                    }
                                    case Boolean: {
                                        Class<Boolean> clazz = Boolean.class;
                                        break;
                                    }
                                    case Byte: {
                                        Class<Byte> clazz = Byte.class;
                                        break;
                                    }
                                    case Double: {
                                        Class<Double> clazz = Double.class;
                                        break;
                                    }
                                    case Float: {
                                        Class<Float> clazz = Float.class;
                                        break;
                                    }
                                    case Integer: {
                                        Class<Integer> clazz = Integer.class;
                                        break;
                                    }
                                    case Long: {
                                        Class<Long> clazz = Long.class;
                                        break;
                                    }
                                    case Short: {
                                        Class<Short> clazz = Short.class;
                                        break;
                                    }
                                    case String: {
                                        Class<String> clazz = String.class;
                                        break;
                                    }
                                }
                                if (var13_30 != null) {
                                    dataType = Types.getParameterSQLType(session, var13_30);
                                }
                            }
                        }
                        catch (DatagramFactoryException exception) {
                            Trace.logError(ExpressionColumn.class, "Failed to create event [" + eventId + "].");
                        }
                        catch (Exception exception) {
                            Trace.logError(ExpressionColumn.class, "Failed to resolve event [" + eventId + "] property '" + propertyName + "'.");
                        }
                    }
                    if (dataType != null) return new Object[]{dataType, spath, null};
                    dataType = Type.OTHER;
                }
                return new Object[]{dataType, spath, null};
            }
            catch (Exception error) {
                Trace.logException(ExpressionColumn.class, error, true);
                throw new DataspaceException(error.getMessage());
            }
        }
        dataType = column.getDataType();
        return new Object[]{dataType, spath, null};
    }

    public static Type resolveType(Session session, Class<?> elementClass) {
        if (elementClass.isArray() && elementClass.getComponentType() != Byte.TYPE && elementClass.getComponentType() != Byte.class) {
            Type elementType = Types.getParameterSQLType(session, elementClass.getComponentType());
            return new ArrayType(elementType, -1);
        }
        if (elementClass == byte[].class || elementClass == Byte[].class) {
            return BinaryType.getBinaryType(-3, 0L);
        }
        return Types.getParameterSQLType(session, elementClass);
    }

    public static Type resolveDataType(Session session, Class<?> objectClass, String spath) throws TypeAnalyzerException, ClassNotFoundException {
        if ((objectClass.isArray() || Collection.class.isAssignableFrom(objectClass)) && spath.equals("/length")) {
            return NumberType.SQL_INTEGER;
        }
        boolean length = false;
        if (spath.endsWith("/length")) {
            spath = spath.substring(0, spath.length() - "/length".length());
            length = true;
        }
        if (((objectClass = session.sessionContext.typeAnalyzer.getFieldClass(objectClass, "/" + spath)).isArray() || Collection.class.isAssignableFrom(objectClass)) && length) {
            return NumberType.SQL_INTEGER;
        }
        Type dataType = Types.getParameterSQLType(session, objectClass.getName());
        if (dataType == null) {
            dataType = ExpressionColumn.resolveType(session, objectClass);
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 10: {
                return this.getDiagnosticsVariable(session);
            }
            case 6: 
            case 117: {
                Object value = null;
                if (this.opType == 6) {
                    if (this.columnIndex >= session.sessionContext.routineVariables.length) throw new DataspaceException("Invalid index " + this.columnIndex + " for variable " + this.columnName + ".");
                    value = session.sessionContext.routineVariables[this.columnIndex];
                } else if (this.opType == 117 && this.rangeVariable != null && this.rangeVariable.getParentRplBlock() != null) {
                    value = this.rangeVariable.getParentRplBlock().getTransientVariable(this.columnIndex);
                }
                if (this.spath == null) return value;
                if (this.columnIndex == -1) return value;
                return this.getValueBySpath(session, value);
            }
            case 7: {
                Object value = session.sessionContext.rplArguments[this.columnIndex];
                if (this.spath == null) return value;
                if (this.columnIndex == -1) return value;
                if (value != null) return this.getValueBySpath(session, value);
                throw new DataspaceException("Variable with name '" + this.columnName + "' is not set or null.");
            }
            case 9: {
                if (session.sessionContext.triggerArguments[this.rangeVariable.rangePosition] == null) {
                    throw new DataspaceException("Variable with name '" + (this.rangeVariable.tableAlias != null ? this.rangeVariable.tableAlias.getNameString() : "unknown") + "' is not set or null.");
                }
                if (session.sessionContext.triggerArguments[this.rangeVariable.rangePosition].length <= this.columnIndex) {
                    throw new DataspaceException("Variable with name '" + (this.rangeVariable.tableAlias != null ? this.rangeVariable.tableAlias.getNameString() : "unknown") + "." + String.valueOf(this.rangeVariable.getVariables().get(this.columnIndex)) + "' is not set or null.");
                }
                Object value = session.sessionContext.triggerArguments[this.rangeVariable.rangePosition][this.columnIndex];
                if (this.spath == null) return value;
                return this.getValueBySpath(session, value);
            }
            case 2: {
                if (this.columnIndex < 0) {
                    throw new DataspaceException("Invalid column index " + this.columnIndex);
                }
                Object value = session.sessionContext.rangeIterators[this.rangeVariable.rangePosition].getCurrent(this.columnIndex);
                if (this.dataType != this.column.getDataType() && this.spath == null) {
                    value = this.dataType.convertToType(session, value, this.column.getDataType());
                }
                if (this.spath == null) return value;
                return this.getValueBySpath(session, value);
            }
            case 5: {
                return session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
            }
            case 3: {
                Object value = null;
                int i = 0;
                while (i < this.nodes.length) {
                    value = this.nodes[i].getValue(session, this.dataType);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
                return value;
            }
            case 8: {
                if (!this.dataType.isObjectType()) return session.sessionContext.dynamicArguments[this.parameterIndex];
                try {
                    return SDOUtils.clone(session.sessionContext.dynamicArguments[this.parameterIndex]);
                }
                catch (Exception error) {
                    return session.sessionContext.dynamicArguments[this.parameterIndex];
                }
            }
            case 12: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
            case 13: {
                return session.sessionData.getSequenceCurrent(this.sequence);
            }
            case 14: {
                return ValuePool.getInt(session.sessionContext.rownum);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    private Object getValueBySpath(Session session, Object value) {
        if ((value = OtherTypeWrapper.unwrap(value)) instanceof AbstractLazyFlobFunctionExpression) {
            value = ((AbstractLazyFlobFunctionExpression)value).getLazyFlobData(session);
        }
        if (value instanceof FlobDataID && ((FlobDataID)value).getFilename() == null) {
            try {
                ((FlobDataID)value).initialize(session.dataspaceStore.flobManager.getFlobData(((FlobDataID)value).getId()));
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to get flob data. Cause: " + exception.getMessage());
            }
        }
        if (value instanceof Facets) {
            String key = this.spath;
            if (key.startsWith("/")) {
                key = key.substring(1);
            }
            return ((Facets)value).get(key);
        }
        if (this.spath.equals("/length")) {
            return ExpressionColumn.getLength(session, value);
        }
        if (this.spath.equals("/size") && this.column.getDataType() instanceof FlobType) {
            if (((FlobData)value).getId() != -1L) {
                value = ((FlobData)value).length(session);
            } else if (((FlobData)value).getFilename() != null) {
                try {
                    return session.sessionData.getFilelLength(((FlobData)value).getFilename());
                }
                catch (Exception exception) {
                    value = -1;
                }
            } else {
                value = -1;
            }
            return value;
        }
        if (this.spath.equals("/usageCount") && this.column.getDataType() instanceof FlobType) {
            value = ((FlobData)value).getId() != -1L ? Integer.valueOf(((FlobDataID)session.dataspaceStore.flobManager.getFlobData(((FlobDataID)value).getId())).getUsageCount()) : Integer.valueOf(0);
            return value;
        }
        if (this.spath.equals("/isValid") && this.column.getDataType() instanceof FlobType) {
            value = ((FlobData)value).getId() != -1L ? Boolean.valueOf(((FlobDataID)session.dataspaceStore.flobManager.validateFlob(((FlobData)value).getId(), false)).isValid()) : Boolean.valueOf(false);
            return value;
        }
        if (this.spath.endsWith("/length")) {
            int dotIndex = this.spath.lastIndexOf(46);
            if (dotIndex == -1) {
                dotIndex = this.spath.lastIndexOf(47);
            }
            try {
                if (dotIndex != -1) {
                    value = session.sessionContext.sdrManager.getValueAtPath("/" + this.spath.substring(0, dotIndex), value);
                }
                return ExpressionColumn.getLength(session, value);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        try {
            value = this.getMethod != null ? this.getMethod.invoke(value, new Object[0]) : (value instanceof EventDatagram && this.spath.length() > 0 && ((EventDatagram)value).existsEventProperty(this.spath.substring(1)) ? ((EventDatagram)value).getEventObjectProperty(this.spath.substring(1)) : (value instanceof ExceptionEventDatagram && this.spath.length() > 0 && ((ExceptionEventDatagram)value).existsEventProperty(this.spath.substring(1)) ? ((ExceptionEventDatagram)value).getEventObjectProperty(this.spath.substring(1)) : session.sessionContext.sdrManager.getValueAtPath("/" + this.spath, value)));
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to evaluate expression '" + this.getSQL() + "'. " + error.getMessage());
        }
        if (this.dataType.isArrayType()) {
            return value;
        }
        return this.dataType.convertJavaToSQL(session, value);
    }

    public static Object getLength(Session session, Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        if (value instanceof BinaryData) {
            return ((BinaryData)value).length(session);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return null;
    }

    private Object getDiagnosticsVariable(Session session) {
        return session.sessionContext.diagnosticsVariables[this.columnIndex];
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 11: {
                return "*";
            }
            case 3: {
                return this.alias.getStatementName();
            }
            case 6: 
            case 7: 
            case 10: {
                if (this.spath == null) {
                    return this.column.getObjectName().statementName;
                }
                return this.column.getObjectName().statementName + this.spath.replaceAll("/", ".");
            }
            case 14: {
                StringBuffer sb = new StringBuffer("ROWNUM");
                sb.append('(').append(')');
            }
            case 2: {
                Object sql = null;
                if (this.column == null) {
                    sql = this.alias != null ? this.alias.getStatementName() : this.columnName;
                } else if (this.rangeVariable.getTableAlias() == null) {
                    sql = this.column.getObjectName().getSchemaQualifiedStatementName();
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.rangeVariable.getTableAlias().getStatementName());
                    sb.append('.');
                    sb.append(this.column.getObjectName().statementName);
                    sql = sb.toString();
                }
                if (this.spath != null) {
                    sql = (String)sql + this.spath.replaceAll("/", ".");
                }
                return sql;
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression e = this.nodes[i];
                    if (i > 0) {
                        sb.append(',');
                    }
                    String s = e.getSQL();
                    sb.append(s);
                }
                return sb.toString();
            }
            case 9: 
            case 117: {
                if (this.spath == null) {
                    return this.column.getObjectName().statementName;
                }
                return this.column.getObjectName().statementName + this.spath.replaceAll("/", ".");
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 4: {
                result.put("opType", "DEFAULT");
                break;
            }
            case 11: {
                result.put("opType", "ASTERISK");
                break;
            }
            case 6: {
                result.put("opType", "VARIABLE");
                result.put("variableName", this.column.getObjectName().name);
                break;
            }
            case 7: {
                result.put("opType", "PARAMETER");
                result.put("parameterName", this.column.getObjectName().name);
                break;
            }
            case 3: {
                result.put("opType", "COALESCE");
                result.put("columnName", this.columnName);
                if (this.alias == null) break;
                result.put("alias", this.alias.name);
                break;
            }
            case 2: {
                result.put("opType", "COLUMN");
                result.put("columnName", this.column.getObjectName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                result.put("alias", this.alias.name);
                break;
            }
            case 8: {
                result.put("opType", "DYNAMIC PARAM");
                result.put("type", this.dataType.getNameString());
                break;
            }
            case 12: {
                result.put("opType", "SEQUENCE");
                result.put("sequenceName", this.sequence.getObjectName().name);
                break;
            }
        }
        result.put("isNullable", this.getNullability() != 0);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 4: {
                sb.append("DEFAULT");
                break;
            }
            case 11: {
                sb.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                sb.append("VARIABLE: ");
                sb.append(this.column.getObjectName().name);
                break;
            }
            case 7: {
                sb.append("PARAMETER").append(": ");
                sb.append(this.column.getObjectName().name);
                break;
            }
            case 3: {
                sb.append("COLUMN").append(": ");
                sb.append(this.columnName);
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                sb.append("COLUMN").append(": ");
                sb.append(this.column.getObjectName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                sb.append("DYNAMIC PARAM: ");
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 12: {
                sb.append("SEQUENCE").append(": ");
                sb.append(this.sequence.getObjectName().name);
                break;
            }
        }
        return sb.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getObjectName().name;
        }
        return "";
    }

    public static void checkColumnsResolved(HsqlList set) {
        ExpressionColumn.checkColumnsResolved(set, null);
    }

    public static void checkColumnsResolved(HsqlList set, RangeVariable[] vars) {
        if (set != null && !set.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Expression e = (Expression)set.get(0);
            if (e instanceof ExpressionColumn) {
                ExpressionColumn c = (ExpressionColumn)e;
                if (c.schema != null) {
                    sb.append(c.schema + ".");
                }
                if (c.tableName != null) {
                    sb.append(c.tableName + ".");
                }
                if (vars != null) {
                    for (RangeVariable var : vars) {
                        if (var == null || var.getTableAlias() == null || !c.getColumnName().equals(var.getTableAlias().name)) continue;
                        throw Error.error(5501, "Element '" + c.getColumnName() + "' is not a primitive or an object. It may not be referenced directly from functions.");
                    }
                }
                throw Error.error(5501, sb.toString() + c.getColumnNameWithAlias());
            }
            OrderedHashSet newSet = new OrderedHashSet();
            e.collectAllExpressions(newSet, Expression.columnExpressionSet, Expression.emptyExpressionSet);
            ExpressionColumn.checkColumnsResolved(newSet);
            throw Error.error(5501);
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (unresolvedSet == null) {
                unresolvedSet = new OrderedHashSet();
            }
            unresolvedSet.add(this);
        }
        return unresolvedSet;
    }

    @Override
    public void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.rangeVariable != null) {
            for (i = 0; i < rangeVariables.length; ++i) {
                if (rangeVariables[i] != this.rangeVariable) continue;
                set.add(this.rangeVariable);
                break;
            }
        }
    }

    @Override
    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(columns, length);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                for (i = 0; i < length; ++i) {
                    String alias;
                    NameManager.SimpleName aliasName = columns[i].alias;
                    String string = alias = aliasName == null ? null : aliasName.name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(alias)) continue;
                    return columns[i];
                }
                for (i = 0; i < length; ++i) {
                    if (!(columns[i] instanceof ExpressionColumn)) continue;
                    if (this.equals(columns[i])) {
                        return columns[i];
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)columns[i]).columnName)) continue;
                    return columns[i];
                }
                break;
            }
        }
        return this;
    }

    @Override
    public Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        if (this.opType == 2 && this.rangeVariable == range) {
            return list[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        return this;
    }

    @Override
    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        for (int i = 0; i < rangeVarArray.length; ++i) {
            RangeVariable rangeVar = rangeVarArray[i];
            if (!rangeVar.resolvesTableName(this)) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean hasReference(RangeVariable range) {
        if (range == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 3: {
                return this.nodes == other.nodes;
            }
            case 2: 
            case 6: 
            case 7: {
                return this.column == other.getColumn() && this.rangeVariable == other.getRangeVariable();
            }
        }
        return false;
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].replaceRangeVariables(ranges, newRanges);
        }
        for (i = 0; i < ranges.length; ++i) {
            if (this.rangeVariable != ranges[i]) continue;
            this.rangeVariable = newRanges[i];
            break;
        }
    }

    @Override
    public void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    @Override
    public boolean isIndexable(RangeVariable range) {
        if (this.opType == 2) {
            return this.rangeVariable == range;
        }
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    @Override
    public boolean isDynamicParam() {
        return this.isParam;
    }

    @Override
    public RangeVariable[] getJoinRangeVariables(RangeVariable[] ranges) {
        if (this.opType == 2) {
            return new RangeVariable[]{this.rangeVariable};
        }
        return RangeVariable.emptyArray;
    }

    @Override
    public double costFactor(Session session, RangeVariable range, int operation) {
        double factor;
        if (range.rangeTable instanceof TableDerived) {
            return 1024.0;
        }
        PersistentStore store = range.rangeTable.getRowStore(session);
        int indexType = range.rangeTable.indexTypeForColumn(session, this.columnIndex);
        switch (indexType) {
            case 2: {
                if (operation == 41) {
                    factor = 1.0;
                    break;
                }
                factor = store.elementCount() / 2L;
                break;
            }
            case 1: {
                if (operation == 41) {
                    factor = store.elementCount() / 8L;
                    if (!(factor > 1024.0)) break;
                    factor = 1024.0;
                    break;
                }
                factor = store.elementCount() / 2L;
                break;
            }
            default: {
                factor = store.elementCount();
            }
        }
        return factor < 16.0 ? 16.0 : factor;
    }

    @Override
    public Expression duplicate() {
        if (this.opType == 7) {
            return this;
        }
        return super.duplicate();
    }

    public void setColumnNameIsDelimiter(boolean columnNameIsDelimiter) {
        this.columnNameIsDelimiter = columnNameIsDelimiter;
    }

    public boolean isColumnNameIsDelimiter() {
        return this.columnNameIsDelimiter;
    }

    public void setColumnNameIsAtSign(boolean columnNameIsAtSign) {
        this.columnNameIsAtSign = columnNameIsAtSign;
    }

    public boolean isColumnNameIsAtSign() {
        return this.columnNameIsAtSign;
    }

    public static void addParentQuerySpecification(QuerySpecification querySpecification) {
        List<QuerySpecification> list = parentQuerySpecifications.get();
        if (list == null) {
            list = new ArrayList<QuerySpecification>();
        }
        list.add(querySpecification);
        parentQuerySpecifications.set(list);
    }

    public static void removeParentQuerySpecificationLast() {
        List<QuerySpecification> list = parentQuerySpecifications.get();
        if (list != null && list.size() > 0) {
            list.remove(list.size() - 1);
        }
        if (list.size() == 0) {
            parentQuerySpecifications.remove();
        }
    }

    public static QuerySpecification getParentQuerySpecification() {
        List<QuerySpecification> list = parentQuerySpecifications.get();
        if (list != null && list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    static {
        for (int i = 0; i < diagnosticsVariableTokens.length; ++i) {
            NameManager.ObjectName name = NameManager.newSystemObjectName(diagnosticsVariableTokens[i], 23);
            Type type = Type.SQL_INTEGER;
            if (diagnosticsVariableTokens[i] == "MORE") {
                type = Type.SQL_CHAR;
            }
            ColumnSchema col = new ColumnSchema(name, type, false, false, null);
            diagnosticsList.add(diagnosticsVariableTokens[i], col);
        }
    }
}

