/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.DataspaceCollectionType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionCollectionReference
extends Expression {
    public ExpressionCollectionReference(Collection collection) {
        super(115);
        this.nodes = new Expression[1];
        DataspaceCollectionType type = new DataspaceCollectionType();
        type.setCollectionType(collection.getCollectionType());
        this.nodes[0] = new ExpressionValue(new OtherTypeWrapper(collection), type);
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        if (this.dataType == null) {
            this.dataType = this.nodes[0].dataType.collectionBaseType();
        }
        if (this.dataType == null) {
            this.dataType = new OtherType();
        }
    }

    @Override
    public Result getResult(Session session) {
        return super.getResult(session);
    }

    @Override
    public Object getValue(Session session) {
        return this.nodes[0].getValue(session);
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("COLLECTION ").append('[');
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "COLLECTION");
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("COLLECTION");
        return sb.toString();
    }
}

