/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.SelectForClassifyExpression;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionClassifyAggregate
extends Expression {
    boolean isDistinctAggregate;
    Expression condition = Expression.EXPR_TRUE;
    List<String> terms = new ArrayList<String>();
    private Map<String, Integer> clustersMap;

    public ExpressionClassifyAggregate(boolean distinct, Expression e, Expression tableName, Expression clustersCount) {
        super(119);
        this.nodes = new Expression[3];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
        this.nodes[1] = tableName;
        this.nodes[2] = clustersCount;
    }

    @Override
    protected boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        String left = ExpressionClassifyAggregate.getContextSQL(this.nodes[0]);
        String right = ExpressionClassifyAggregate.getContextSQL(this.nodes[1]);
        String clustersCount = ExpressionClassifyAggregate.getContextSQL(this.nodes[2]);
        builder.append(' ').append("CLASSIFY").append('(');
        builder.append(left).append(",").append(right).append(",").append(clustersCount).append(')');
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "CLASSIFY");
        ArrayList<Map<String, Object>> argsExplained = new ArrayList<Map<String, Object>>();
        result.put("opType", "CLASSIFY");
        argsExplained.add(this.nodes[0].describeJson(session));
        argsExplained.add(this.nodes[1].describeJson(session));
        argsExplained.add(this.nodes[2].describeJson(session));
        result.put("args", argsExplained);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("CLASSIFY").append(' ');
        builder.append(" arg=[");
        builder.append(this.nodes[0].describe(session, blanks + 1));
        builder.append(",");
        builder.append(this.nodes[1].describe(session, blanks + 1));
        builder.append(",");
        builder.append(this.nodes[2].describe(session, blanks + 1));
        builder.append(']');
        return builder.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeVarArray, rangeCount, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = Type.SQL_INTEGER;
        this.condition.resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression other) {
        if (!(other instanceof ExpressionClassifyAggregate)) {
            return false;
        }
        ExpressionClassifyAggregate o = (ExpressionClassifyAggregate)other;
        if (this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == o.isDistinctAggregate && this.condition.equals(o.condition)) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return null;
        }
        currValue = String.valueOf(this.nodes[0].getValue(session));
        this.terms.add((String)currValue);
        return currValue;
    }

    @Override
    public Object getAggregatedValue(Session session, Object currValue) {
        if (this.clustersMap == null) {
            try {
                int[] labels = SelectForClassifyExpression.execute(session, this.terms, String.valueOf(this.nodes[1].getValue(session)), ((Number)this.nodes[2].getValue(session)).intValue());
                this.clustersMap = new HashMap<String, Integer>();
                for (int i = 0; i < this.terms.size(); ++i) {
                    this.clustersMap.put(this.terms.get(i), labels[i]);
                }
            }
            catch (Exception e) {
                throw new DataspaceException(e);
            }
        }
        return this.clustersMap.get(currValue);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }
}

