/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionAspectsValue
extends Expression {
    public ExpressionAspectsValue(List<Object> list, Type datatype) {
        super(1);
        this.nodes = Expression.emptyArray;
        this.dataType = datatype;
        this.valueData = list;
    }

    @Override
    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        if (this.valueData != null) {
            for (Object value : (List)this.valueData) {
                if (!(value instanceof Expression)) continue;
                ((Expression)value).resolveTypes(session, this);
            }
        }
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, HsqlList unresolvedSet) {
        return this.resolveColumnReferences(session, rangeVarArray, rangeVarArray.length, unresolvedSet, true);
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.valueData != null) {
            for (Object value : (List)this.valueData) {
                if (!(value instanceof Expression)) continue;
                unresolvedSet = ((Expression)value).resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
            }
        }
        return unresolvedSet;
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                try {
                    return this.valueDataToString();
                }
                catch (Throwable error) {
                    return "VALUE";
                }
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("value", this.valueDataToString());
                result.put("type", this.dataType.getNameString());
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionValue");
            }
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueDataToString());
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Object getValue(Session session, Type type) {
        Object aspects = this.getValue(session);
        if (this.dataType == type) {
            return aspects;
        }
        return type.convertToType(session, aspects, this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        if (this.valueData == null) {
            return null;
        }
        Aspects aspects = new Aspects();
        for (Object value : (List)this.valueData) {
            if (value instanceof Expression) {
                value = ((Expression)value).getValue(session);
            }
            aspects.add(OtherTypeWrapper.unwrap(value));
        }
        return aspects;
    }

    private String valueDataToString() {
        Aspects aspects = new Aspects();
        for (Object value : (List)this.valueData) {
            if (value instanceof ExpressionColumn) {
                value = "@" + ((ExpressionColumn)value).getColumnName();
            } else if (value instanceof Expression) {
                value = ((Expression)value).getSQL();
            }
            aspects.add(OtherTypeWrapper.unwrap(value));
        }
        return FacetsUtils.aspectsToString(aspects);
    }
}

