/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionArrayUnnest
extends Expression {
    private final boolean asterisk;

    public ExpressionArrayUnnest(Expression expression, boolean asterisk) {
        super(1);
        this.asterisk = asterisk;
        this.nodes = new Expression[]{expression};
    }

    @Override
    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        this.dataType = this.getCollectionBaseType(session);
    }

    private Type getCollectionBaseType(Session session) {
        if (!this.nodes[0].dataType.isArrayType() && !this.nodes[0].dataType.isObjectType()) {
            throw Error.error(5563);
        }
        Type type = this.nodes[0].dataType.collectionBaseType();
        if (type == null) {
            type = new OtherType();
        }
        return type;
    }

    @Override
    public Object getValue(Session session) {
        Object value = this.nodes[0].getValue(session);
        if (value instanceof OtherTypeWrapper) {
            value = ((OtherTypeWrapper)value).getObject();
        }
        return value;
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder(64);
        if (this.asterisk) {
            builder.append(this.nodes[0].getSQL()).append("[*]");
        } else {
            builder.append("UNNEST").append("(").append(this.nodes[0].getSQL()).append(")");
        }
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "UNNEST");
        result.put("array", this.nodes[0].describeJson(session));
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder(64);
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("UNNEST");
        builder.append(" array=[");
        builder.append(this.nodes[0].describe(session, blanks + 1));
        builder.append(']');
        return builder.toString();
    }
}

