/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionArrayAccessor
extends Expression {
    public static final Expression[] ASTERIKS_EXPRESSION = new Expression[]{new ExpressionValue("*", Type.STRING)};
    public boolean isRoot = true;
    public boolean subarrayAccess = false;

    public ExpressionArrayAccessor(Expression left, Expression[] indexes) {
        super(99);
        if (indexes.length == 1) {
            this.nodes = new Expression[]{left, indexes[0]};
        } else {
            this.nodes = new Expression[]{left, indexes[0], indexes[1]};
            this.subarrayAccess = true;
        }
    }

    @Override
    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        if (this.subarrayAccess) {
            this.dataType = this.nodes[0].dataType;
        } else {
            this.dataType = this.getCollectionBaseType(session);
            if (this.nodes[1].opType == 8) {
                this.nodes[1].dataType = Type.SQL_INTEGER;
            }
        }
    }

    private Type getCollectionBaseType(Session session) {
        if (!this.nodes[0].dataType.isArrayType() && !this.nodes[0].dataType.isObjectType()) {
            if (this.nodes[0].dataType instanceof BinaryType) {
                return Types.getParameterSQLType(session, Byte.TYPE);
            }
            throw Error.error(5563);
        }
        Type type = this.nodes[0].dataType.collectionBaseType();
        if (type == null) {
            type = new OtherType();
        }
        return type;
    }

    @Override
    public Result getResult(Session session) {
        return Result.newPSMResult(this.getValue(session), this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        if (this.subarrayAccess) {
            return this.getSubarray(session);
        }
        return this.getSingleValue(session);
    }

    private Object getSingleValue(Session session) {
        Number index;
        Object value = this.nodes[0].getValue(session);
        if (value instanceof OtherTypeWrapper) {
            value = ((OtherTypeWrapper)value).getObject();
        }
        if ((index = (Number)this.nodes[1].getValue(session)) == null) {
            return null;
        }
        if (value == null) {
            return null;
        }
        Object result = null;
        if (value instanceof BinaryData) {
            byte[] byteArray = (byte[])(value = (Object)((BinaryData)value).getBytes());
            if (byteArray == null) {
                return null;
            }
            if (index.intValue() < 1 || index.intValue() > byteArray.length) {
                throw Error.error(3490, "index is out of range");
            }
            result = byteArray[index.intValue() - 1];
        } else if (value instanceof List) {
            if (index.intValue() < 1 || index.intValue() > ((List)value).size()) {
                throw Error.error(3490, "index is out of range");
            }
            result = ((List)value).get(index.intValue() - 1);
        } else if (value instanceof Set) {
            if (index.intValue() < 1 || index.intValue() > ((Set)value).size()) {
                throw Error.error(3490, "index is out of range");
            }
            Iterator iterator = ((Set)value).iterator();
            int offset = 1;
            while (offset < index.intValue()) {
                iterator.next();
            }
            result = iterator.next();
        } else if (value.getClass().isArray()) {
            if (index.intValue() < 1 || index.intValue() > Array.getLength(value)) {
                throw Error.error(3490, "index is out of range");
            }
            result = Array.get(value, index.intValue() - 1);
        } else {
            throw new DataspaceException("Only variables of type binary, arrays or list can be accessed by index.");
        }
        result = OtherTypeWrapper.unwrap(result);
        if (this.dataType == null) {
            throw new DataspaceException("Unresolved expression encountered.");
        }
        if (this.dataType.isObjectType()) {
            return new OtherTypeWrapper(result);
        }
        return result;
    }

    private Object getSubarray(Session session) {
        Object[] result;
        block12: {
            int intIndex2;
            int intIndex1;
            Object value;
            block14: {
                block13: {
                    value = this.nodes[0].getValue(session);
                    if (value instanceof OtherTypeWrapper) {
                        value = ((OtherTypeWrapper)value).getObject();
                    }
                    if (value == null) {
                        return null;
                    }
                    Number index1 = (Number)this.nodes[1].getValue(session);
                    if (index1 == null) {
                        throw new DataspaceException("Null start index in array access.");
                    }
                    Number index2 = (Number)this.nodes[2].getValue(session);
                    if (index1 == null) {
                        throw new DataspaceException("Null end index in array access.");
                    }
                    intIndex1 = index1.intValue();
                    intIndex2 = index2.intValue();
                    if (intIndex1 == -1) {
                        intIndex1 = 1;
                    }
                    if (intIndex2 == -1) {
                        int n = value.getClass().isArray() ? Array.getLength(value) : (intIndex2 = value instanceof Collection ? ((Collection)value).size() : 0);
                        if (intIndex2 == 0) {
                            return new Object[0];
                        }
                    }
                    if (intIndex1 > intIndex2) {
                        throw Error.error(3490, "first index is greater than second");
                    }
                    result = new Object[intIndex2 - intIndex1 + 1];
                    if (!value.getClass().isArray()) break block13;
                    for (int i = intIndex1; i <= intIndex2 && i <= Array.getLength(value); ++i) {
                        result[i - intIndex1] = Array.get(value, i - 1);
                    }
                    break block12;
                }
                if (!(value instanceof List)) break block14;
                List list = (List)value;
                for (int i = intIndex1; i <= intIndex2 && i <= list.size(); ++i) {
                    result[i - intIndex1] = list.get(i - 1);
                }
                break block12;
            }
            if (!(value instanceof Collection)) break block12;
            Iterator iterator = ((Collection)value).iterator();
            int index = 1;
            while (iterator.hasNext()) {
                if (index >= intIndex1 && index <= intIndex2) {
                    result[index - intIndex1] = iterator.next();
                }
                if (++index <= intIndex2) continue;
                break;
            }
        }
        return result;
    }

    public Object updateArrayValue(Session session, Object array, Object value, boolean copy, boolean withExtend) {
        if (array == null) {
            throw Error.error(3413, "array is null");
        }
        int intIndex1 = -1;
        int intIndex2 = -1;
        Number index1 = (Number)this.nodes[1].getValue(session);
        if (index1 == null) {
            throw Error.error(3490, "first index is null");
        }
        intIndex1 = index1.intValue();
        if (this.subarrayAccess) {
            Number index2 = (Number)this.nodes[2].getValue(session);
            if (index2 == null) {
                throw Error.error(3490, "second index is null");
            }
            intIndex2 = index2.intValue();
            if (intIndex2 == -1) {
                int n = array.getClass().isArray() ? Array.getLength(array) : (intIndex2 = array instanceof Collection ? ((Collection)array).size() : 0);
                if (intIndex2 == 0) {
                    throw Error.error(3490, "array is empty");
                }
            }
            if (--intIndex2 < 0) {
                throw Error.error(3490, "second index is out of range");
            }
            if (intIndex1 == -1) {
                intIndex1 = 1;
            }
            if (--intIndex1 > intIndex2) {
                throw Error.error(3490, "first index is greater than second index");
            }
            if (intIndex2 - intIndex1 > 0) {
                if (value == null || !value.getClass().isArray() && !(value instanceof Collection)) {
                    throw Error.error(3490, "right value should be an array or collection to be assigned to sliced array");
                }
                if (value.getClass().isArray() && Array.getLength(value) != intIndex2 - intIndex1 + 1 || value instanceof Collection && ((Collection)value).size() != intIndex2 - intIndex1 + 1) {
                    throw Error.error(3490, "right value should have the same length as left to be assigned to sliced array");
                }
            }
        } else {
            intIndex2 = --intIndex1;
        }
        if (intIndex1 < 0) {
            throw Error.error(3490, "index index is out of range");
        }
        Class<Object> arrayClass = null;
        if ((array = OtherTypeWrapper.unwrap(array)) instanceof BinaryData || array.getClass().isArray()) {
            if (!(this.nodes[0].dataType instanceof OtherType) && this.nodes[0].dataType.arrayLimitCardinality() > 0 && intIndex2 >= this.nodes[0].dataType.arrayLimitCardinality()) {
                throw Error.error(3490, "index is greater than array limit cardinality");
            }
            arrayClass = Object.class;
            if (array instanceof BinaryData) {
                array = ((BinaryData)array).getBytes();
                arrayClass = Byte.TYPE;
                if (value == null) {
                    value = 0;
                }
                value = ((Number)value).byteValue();
            }
            if (intIndex2 >= Array.getLength(array) && !withExtend) {
                throw Error.error(3490, "index is greater than array length");
            }
            Object newArray = array;
            if (intIndex2 >= Array.getLength(array)) {
                newArray = Array.newInstance(arrayClass, intIndex2 + 1);
                System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            } else if (copy) {
                newArray = Array.newInstance(arrayClass, Array.getLength(array));
                System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            }
            for (int i = intIndex1; i <= intIndex2; ++i) {
                Array.set(newArray, i, this.subarrayAccess ? (value.getClass().isArray() ? Array.get(value, i - intIndex1) : ((List)value).get(i - intIndex1)) : value);
            }
            if (arrayClass == Byte.TYPE) {
                newArray = new BinaryData((byte[])newArray, false);
            }
            array = newArray;
        } else if (array instanceof List) {
            if (copy) {
                array = new ArrayList((List)array);
            }
            while (((List)array).size() <= intIndex2) {
                ((List)array).add(null);
            }
            for (int i = intIndex1; i <= intIndex2; ++i) {
                ((List)array).set(i, this.subarrayAccess ? (value.getClass().isArray() ? Array.get(value, i - intIndex1) : ((List)value).get(i - intIndex1)) : value);
            }
        } else {
            throw new DataspaceException("Invalid variable is passed to array access expression.");
        }
        return array;
    }

    public void updateArrayValue(Session session, Object value, boolean copy) {
        Object arrayValue = this.nodes[0].getValue(session);
        this.updateArrayValue(session, arrayValue, value, copy, false);
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder(64);
        String left = ExpressionArrayAccessor.getContextSQL(this.nodes[0]);
        builder.append(left).append('[');
        builder.append(this.nodes[1].getSQL());
        if (this.subarrayAccess) {
            builder.append(":").append(this.nodes[2].getSQL());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "ARRAY ACCESS");
        if (this.getLeftNode() != null) {
            result.put("array", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("arrayIndex", this.nodes[1].describeJson(session));
            if (this.nodes.length == 3 && this.nodes[2] != null) {
                result.put("arrayIndexEnd", this.nodes[2].describeJson(session));
            }
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuilder builder = new StringBuilder(64);
        builder.append('\n');
        for (int i = 0; i < blanks; ++i) {
            builder.append(' ');
        }
        builder.append("ARRAY ACCESS");
        if (this.getLeftNode() != null) {
            builder.append(" array=[");
            builder.append(this.nodes[0].describe(session, blanks + 1));
            builder.append(']');
        }
        if (this.getRightNode() != null) {
            builder.append(" array_index=[");
            builder.append(this.nodes[1].describe(session, blanks + 1));
            if (this.nodes.length == 3 && this.nodes[2] != null) {
                builder.append(":").append(this.nodes[2].describe(session, blanks + 1));
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

