/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionArithmetic
extends Expression {
    public ExpressionArithmetic(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 116: {
                this.futureFunctionSensitive = true;
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public ExpressionArithmetic(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 31: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.futureFunctionSensitive = true;
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "Expression");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        String left = ExpressionArithmetic.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionArithmetic.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                break;
            }
            case 31: {
                sb.append('-').append(left);
                break;
            }
            case 105: {
                sb.append("--").append(left);
                break;
            }
            case 104: {
                sb.append(left).append("--");
                break;
            }
            case 107: {
                sb.append("++").append(left);
                break;
            }
            case 106: {
                sb.append(left).append("++");
                break;
            }
            case 32: {
                sb.append(left).append('+').append(right);
                break;
            }
            case 110: {
                sb.append(left).append("+=").append(right);
                break;
            }
            case 33: {
                sb.append(left).append('-').append(right);
                break;
            }
            case 111: {
                sb.append(left).append("-=").append(right);
                break;
            }
            case 34: {
                sb.append(left).append('*').append(right);
                break;
            }
            case 108: {
                sb.append(left).append("*=").append(right);
                break;
            }
            case 35: {
                sb.append(left).append('/').append(right);
                break;
            }
            case 109: {
                sb.append(left).append("/=").append(right);
                break;
            }
            case 36: {
                sb.append(left).append("+").append(right);
                break;
            }
            case 116: {
                sb.append(left).append("+=").append(right);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("valueData", this.valueData);
                result.put("valueType", this.dataType.getNameString());
                return result;
            }
            case 25: 
            case 26: {
                result.put("opType", "VALUELIST");
                result.put("dataType", this.dataType.getNameString());
                ArrayList<Map<String, Object>> nodesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.nodes.length; ++i) {
                    nodesExplained.add(this.nodes[i].describeJson(session));
                }
                result.put("nodes", nodesExplained);
                break;
            }
            case 31: {
                result.put("opType", "NEGATE");
                break;
            }
            case 104: 
            case 105: {
                result.put("opType", "DECREMENT");
                break;
            }
            case 106: 
            case 107: {
                result.put("opType", "INCREMENT");
                break;
            }
            case 32: {
                result.put("opType", "ADD");
                break;
            }
            case 33: {
                result.put("opType", "SUBTRACT");
                break;
            }
            case 34: {
                result.put("opType", "MULTIPLY");
                break;
            }
            case 35: {
                result.put("opType", "DIVIDE");
                break;
            }
            case 36: {
                result.put("opType", "CONCAT");
                break;
            }
            case 91: {
                result.put("opType", "CAST");
                result.put("dataType", this.dataType.getTypeDefinition());
            }
        }
        if (this.getLeftNode() != null) {
            result.put("argLeft", this.nodes[0].describeJson(session));
        }
        if (this.getRightNode() != null) {
            result.put("argRight", this.nodes[1].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 25: 
            case 26: {
                sb.append("VALUELIST ");
                sb.append(" TYPE = ").append(this.dataType.getNameString());
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + blanks));
                    sb.append(' ');
                }
                break;
            }
            case 31: {
                sb.append("NEGATE ");
                break;
            }
            case 104: 
            case 105: {
                sb.append("DECREMENT ");
                break;
            }
            case 106: 
            case 107: {
                sb.append("INCREMENT ");
                break;
            }
            case 32: {
                sb.append("ADD ");
                break;
            }
            case 33: {
                sb.append("SUBTRACT ");
                break;
            }
            case 34: {
                sb.append("MULTIPLY ");
                break;
            }
            case 35: {
                sb.append("DIVIDE ");
                break;
            }
            case 36: {
                sb.append("CONCAT ");
                break;
            }
            case 91: {
                sb.append("CAST ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isNumberType()) break;
                throw Error.error(5563);
            }
            case 31: {
                if (this.nodes[0].isUnresolvedParam() || this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[0].dataType;
                if (!this.dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 32: 
            case 110: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isCharacterType() || this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) {
                    this.opType = this.opType == 32 ? 36 : 116;
                    this.resolveTypesForConcat(session, parent);
                    break;
                }
            }
            case 33: 
            case 34: 
            case 35: 
            case 108: 
            case 109: 
            case 111: {
                this.resolveTypesForArithmetic(session, parent);
                break;
            }
            case 36: 
            case 116: {
                this.resolveTypesForConcat(session, parent);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        switch (this.opType) {
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 116: {
                if (this.nodes[0].getColumn() == null || this.nodes[0].getColumn().getParameterMode() != 1) break;
                throw Error.error(2500);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resolveTypesForArithmetic(Session session, Expression parent) {
        if (this.nodes[0].isUnresolvedParam() && this.nodes[1].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_INTEGER;
        }
        if (this.nodes[0].dataType == null && this.nodes[1].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_INTEGER;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            if (this.nodes[1].dataType == null) {
                throw Error.error(5567);
            }
            if (this.nodes[1].dataType.isIntervalType() && parent != null) {
                block0 : switch (parent.opType) {
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        for (int i = 0; i < parent.nodes.length; ++i) {
                            if (parent.nodes[i] == this) continue;
                            if (parent.nodes[i].dataType == null || !parent.nodes[i].dataType.isDateTimeType()) break block0;
                            this.nodes[0].dataType = parent.nodes[i].dataType;
                            break block0;
                        }
                        break;
                    }
                }
            }
            if (this.nodes[0].dataType == null) {
                switch (this.opType) {
                    case 33: 
                    case 111: {
                        if (!this.nodes[1].dataType.isIntervalType()) break;
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                        break;
                    }
                    case 32: 
                    case 110: {
                        if (this.nodes[1].dataType.isDateTimeType()) {
                            if (this.nodes[1].dataType.typeComparisonGroup == 91) {
                                this.nodes[0].dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                                break;
                            }
                            this.nodes[0].dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                            break;
                        }
                        if (!this.nodes[1].dataType.isIntervalType()) break;
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                    }
                }
            }
            if (this.nodes[0].dataType == null) {
                this.nodes[0].dataType = this.nodes[1].dataType;
            }
        } else if (this.nodes[1].isUnresolvedParam()) {
            if (this.nodes[0].dataType == null) {
                throw Error.error(5567);
            }
            switch (this.opType) {
                case 34: 
                case 35: {
                    if (this.nodes[0].dataType.isIntervalType()) {
                        this.nodes[1].dataType = Type.SQL_DECIMAL;
                        break;
                    }
                    this.nodes[1].dataType = this.nodes[0].dataType;
                    break;
                }
                case 32: 
                case 33: {
                    if (this.nodes[0].dataType.isDateTimeType()) {
                        if (this.dataType != null && this.dataType.isIntervalType()) {
                            this.nodes[1].dataType = this.nodes[0].dataType;
                            break;
                        }
                        if (this.nodes[0].dataType.typeComparisonGroup == 91) {
                            this.nodes[1].dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                            break;
                        }
                        this.nodes[1].dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                        break;
                    }
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
            }
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.dataType != null && this.dataType.isIntervalType()) {
            if (this.nodes[0].dataType.isDateTimeType() && this.nodes[1].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                    throw Error.error(5562);
                }
            } else {
                Type type = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, this.opType);
                if (type == null) {
                    throw Error.error(5562);
                }
                if (type.isIntervalType()) {
                    if (type.typeCode != this.dataType.typeCode) {
                        throw Error.error(5562);
                    }
                } else {
                    if (!type.isNumberType()) throw Error.error(5562);
                    this.nodes[0] = new ExpressionOp(this.nodes[0], this.dataType);
                    this.nodes[1] = new ExpressionOp(this.nodes[1], this.dataType);
                    this.nodes[0].resolveTypes(session, this);
                    this.nodes[1].resolveTypes(session, this);
                }
            }
        } else {
            this.dataType = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, this.opType);
            if (this.dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.isIntervalType()) {
                    if (this.opType != 32) {
                        throw Error.error(5563);
                    }
                    Expression temp = this.nodes[0];
                    this.nodes[0] = this.nodes[1];
                    this.nodes[1] = temp;
                } else if (this.nodes[1].dataType.isNumberType()) {
                    // empty if block
                }
            }
        }
        if (this.nodes[0].opType != 1 || this.nodes[1].opType != 1) return;
        this.setAsConstantValue(session);
    }

    void resolveTypesForConcat(Session session, Expression parent) {
        CharacterType newType;
        if (this.dataType != null) {
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.getParameterType(this.nodes[1].dataType);
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.getParameterType(this.nodes[0].dataType);
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType.isBinaryType() ^ this.nodes[1].dataType.isBinaryType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isArrayType()) {
            Expression e = this.nodes[1];
            if (e.opType == 99) {
                if (parent == null) {
                    throw Error.error(5563);
                }
                this.nodes[1] = e.getLeftNode();
                e.nodes[0] = this;
                parent.replaceNode(this, e);
            }
        }
        if (this.nodes[0].dataType.isArrayType() ^ this.nodes[1].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isCharacterType() && !this.nodes[1].dataType.isCharacterType()) {
            if (session.dataspaceStore.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            newType = CharacterType.getCharacterType(12, this.nodes[1].dataType.displaySize(), this.nodes[0].dataType.getCollation());
            this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], newType);
        }
        if (this.nodes[1].dataType.isCharacterType() && !this.nodes[0].dataType.isCharacterType()) {
            if (session.dataspaceStore.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            newType = CharacterType.getCharacterType(12, this.nodes[0].dataType.displaySize(), this.nodes[1].dataType.getCollation());
            this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], newType);
        }
        this.dataType = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, 36);
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session);
        }
    }

    private Type getParameterType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.typeCode) {
            case 1: 
            case 12: {
                return Type.SQL_VARCHAR_DEFAULT;
            }
            case 40: {
                return Type.SQL_CLOB;
            }
            case 60: 
            case 61: {
                return Type.SQL_VARBINARY_DEFAULT;
            }
            case 30: {
                return Type.SQL_BLOB;
            }
            case 14: 
            case 15: {
                return Type.SQL_BIT_VARYING_MAX_LENGTH;
            }
            case 50: {
                return type;
            }
        }
        return null;
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                return session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 116: {
                return this.processOperationWithSelfAssignment(session);
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
        }
        Object a = this.nodes[0].getValue(session);
        a = OtherTypeWrapper.unwrap(a);
        Object b = this.nodes[1].getValue(session);
        b = OtherTypeWrapper.unwrap(b);
        boolean isOther = false;
        if (this.dataType instanceof OtherType && a != null) {
            this.dataType = Types.getParameterSQLType(session, a.getClass());
            if (this.dataType == null && b != null) {
                this.dataType = Types.getParameterSQLType(session, b.getClass());
            }
            if (this.dataType == null) {
                throw new DataspaceException("Invalid data type in arithmetic expression.");
            }
            isOther = true;
        }
        Object value = null;
        switch (this.opType) {
            case 32: {
                value = this.dataType.add(a, b, this.nodes[1].dataType);
                break;
            }
            case 33: {
                value = this.dataType.subtract(a, b, this.nodes[1].dataType);
                break;
            }
            case 34: {
                value = this.dataType.multiply(a, b);
                break;
            }
            case 35: {
                value = this.dataType.divide(session, a, b);
                break;
            }
            case 36: {
                if (!session.dataspaceStore.sqlConcatNulls && this.nodes[0].dataType.isCharacterType()) {
                    if (a == null && b != null) {
                        a = "";
                    } else if (a != null && b == null) {
                        b = "";
                    }
                }
                return this.dataType.concat(session, a, b);
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        if (isOther) {
            return new OtherTypeWrapper(value);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private Object processOperationWithSelfAssignment(Session session) {
        if (this.nodes[0] instanceof ExpressionColumn && this.nodes[0].columnIndex != -1) {
            sourceValue = null;
            newValue = null;
            varValue = null;
            isOtherType = false;
            column = (ExpressionColumn)this.nodes[0];
            if (column.opType == 6) {
                varValue = session.sessionContext.routineVariables[column.columnIndex];
            } else if (column.opType == 117) {
                varValue = this.nodes[0].getValue(session);
            } else if (column.opType == 7) {
                varValue = this.nodes[0].getValue(session);
            }
            if (varValue instanceof OtherTypeWrapper) {
                varValue = ((OtherTypeWrapper)varValue).getObject();
                isOtherType = true;
            }
            if (column.getSpath() != null) {
                sourceValue = this.nodes[0].getValue(session);
                if (sourceValue instanceof OtherTypeWrapper) {
                    sourceValue = ((OtherTypeWrapper)sourceValue).getObject();
                }
            } else {
                sourceValue = varValue;
            }
            newValue = this.getUpdatedValue(session, sourceValue);
            if (column.getSpath() != null) {
                try {
                    session.sessionContext.sdrManager.setValueAtPath("/" + column.getSpath(), varValue, newValue, true);
                    if (!isOtherType) ** GOTO lbl43
                    sourceValue = new OtherTypeWrapper(sourceValue);
                }
                catch (Exception error) {
                    throw new DataspaceException(error.getMessage());
                }
            } else {
                if (isOtherType) {
                    newValue = new OtherTypeWrapper(newValue);
                }
                if (column.opType == 6) {
                    session.sessionContext.routineVariables[column.columnIndex] = newValue;
                } else if (column.opType == 117) {
                    this.nodes[0].getRangeVariable().getParentRplBlock().setTransientVariable(column.columnIndex, newValue);
                } else if (column.opType == 7) {
                    session.sessionContext.rplArguments[column.columnIndex] = newValue;
                }
            }
lbl43:
            // 7 sources

            if (this.opType == 104 || this.opType == 106) {
                return sourceValue;
            }
            return newValue;
        }
        return this.getUpdatedValue(session, this.nodes[0].getValue(session));
    }

    private Object getUpdatedValue(Session session, Object sourceValue) {
        Object b = null;
        if (this.nodes.length > 1 && this.nodes[1] != null && (b = this.nodes[1].getValue(session)) instanceof OtherTypeWrapper) {
            b = ((OtherTypeWrapper)b).getObject();
        }
        switch (this.opType) {
            case 104: 
            case 105: {
                return this.dataType.subtract(sourceValue, 1, this.nodes[0].dataType);
            }
            case 106: 
            case 107: {
                return this.dataType.add(sourceValue, 1, this.nodes[0].dataType);
            }
            case 110: {
                return this.dataType.add(sourceValue, b, this.nodes[1].dataType);
            }
            case 111: {
                return this.dataType.subtract(sourceValue, b, this.nodes[1].dataType);
            }
            case 108: {
                return this.dataType.multiply(sourceValue, b);
            }
            case 109: {
                return this.dataType.divide(session, sourceValue, b);
            }
            case 116: {
                return this.dataType.concat(session, sourceValue, b);
            }
        }
        return null;
    }
}

