/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.SetFunction;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionAggregate
extends Expression {
    boolean isDistinctAggregate;
    Expression condition = Expression.EXPR_TRUE;
    ArrayType arrayType;

    public ExpressionAggregate(int type, boolean distinct, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
    }

    @Override
    protected boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 5: 
            case 71: {
                sb.append(' ').append("COUNT").append('(');
                sb.append(left).append(')');
                break;
            }
            case 72: {
                sb.append(' ').append("SUM").append('(');
                sb.append(left).append(')');
                break;
            }
            case 73: {
                sb.append(' ').append("MIN").append('(');
                sb.append(left).append(')');
                break;
            }
            case 74: {
                sb.append(' ').append("MAX").append('(');
                sb.append(left).append(')');
                break;
            }
            case 75: {
                sb.append(' ').append("AVG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 76: {
                sb.append(' ').append("EVERY").append('(');
                sb.append(left).append(')');
                break;
            }
            case 77: {
                sb.append(' ').append("SOME").append('(');
                sb.append(left).append(')');
                break;
            }
            case 78: {
                sb.append(' ').append("STDDEV_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 79: {
                sb.append(' ').append("STDDEV_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 80: {
                sb.append(' ').append("VAR_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 81: {
                sb.append(' ').append("VAR_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 71: {
                result.put("opType", "COUNT");
                break;
            }
            case 72: {
                result.put("opType", "SUM");
                break;
            }
            case 73: {
                result.put("opType", "MIN");
                break;
            }
            case 74: {
                result.put("opType", "MAX");
                break;
            }
            case 75: {
                result.put("opType", "AVG");
                break;
            }
            case 76: {
                result.put("opType", "EVERY");
                break;
            }
            case 77: {
                result.put("opType", "SOME");
                break;
            }
            case 78: {
                result.put("opType", "STDDEV_POP");
                break;
            }
            case 79: {
                result.put("opType", "STDDEV_SAMP");
                break;
            }
            case 80: {
                result.put("opType", "VAR_POP");
                break;
            }
            case 81: {
                result.put("opType", "VAR_SAMP");
            }
        }
        if (this.getLeftNode() != null) {
            result.put("arg", this.nodes[0].describeJson(session));
        }
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 71: {
                sb.append("COUNT").append(' ');
                break;
            }
            case 72: {
                sb.append("SUM").append(' ');
                break;
            }
            case 73: {
                sb.append("MIN").append(' ');
                break;
            }
            case 74: {
                sb.append("MAX").append(' ');
                break;
            }
            case 75: {
                sb.append("AVG").append(' ');
                break;
            }
            case 76: {
                sb.append("EVERY").append(' ');
                break;
            }
            case 77: {
                sb.append("SOME").append(' ');
                break;
            }
            case 78: {
                sb.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                sb.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                sb.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                sb.append("VAR_SAMP").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeVarArray, rangeCount, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate) {
            if (this.nodes[0].dataType.isLobType()) {
                throw Error.error(5534);
            }
            if (this.nodes[0].dataType.isCharacterType()) {
                this.arrayType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
            }
        }
        this.dataType = SetFunction.getType(session, this.opType, this.nodes[0].dataType);
        this.condition.resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression other) {
        if (!(other instanceof ExpressionAggregate)) {
            return false;
        }
        ExpressionAggregate o = (ExpressionAggregate)other;
        if (this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == o.isDistinctAggregate && this.condition.equals(o.condition)) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        if (currValue == null) {
            currValue = new SetFunction(this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate, this.arrayType);
        }
        Integer newValue = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)currValue).add(session, newValue);
        return currValue;
    }

    @Override
    public Object getAggregatedValue(Session session, Object currValue) {
        if (currValue == null) {
            return this.opType == 71 ? ValuePool.INTEGER_0 : null;
        }
        return ((SetFunction)currValue).getValue(session);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }
}

