/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.ExpressionArithmetic;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.range.RangeVariableResolver;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.NullType;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Expression
implements Cloneable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    public static final Expression[] emptyArray = new Expression[0];
    public static final Expression EXPR_TRUE = new ExpressionLogical(true);
    public static final Expression EXPR_FALSE = new ExpressionLogical(false);
    static final OrderedIntHashSet aggregateFunctionSet = new OrderedIntHashSet();
    public static final OrderedIntHashSet columnExpressionSet;
    static final OrderedIntHashSet subqueryExpressionSet;
    static final OrderedIntHashSet subqueryAggregateExpressionSet;
    static final OrderedIntHashSet functionExpressionSet;
    public static final OrderedIntHashSet emptyExpressionSet;
    public int opType;
    public int exprSubType;
    public HsqlList unresolvedExpressions;
    public int canBeStaticCall = 0;
    NameManager.SimpleName alias;
    private boolean isAggregate;
    public Object valueData;
    public Expression[] nodes;
    Type[] nodeDataTypes;
    public SubQuery subQuery;
    boolean isCorrelated;
    public int columnIndex = -1;
    public Type dataType;
    int queryTableColumnIndex = -1;
    public int parameterIndex = -1;
    public int rangePosition = -1;
    public boolean isColumnEqual;
    public boolean isSingleColumnCondition;
    public Collation collation;
    protected boolean futureFunctionSensitive;
    public Object metaResultObject = null;

    public Expression(int type) {
        this.opType = type;
        this.nodes = emptyArray;
    }

    public Expression(int type, SubQuery sq) {
        switch (type) {
            case 19: {
                this.opType = 19;
                break;
            }
            case 100: {
                this.opType = 100;
                break;
            }
            case 23: {
                this.opType = 23;
                break;
            }
            case 21: 
            case 22: {
                this.opType = 22;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        this.nodes = emptyArray;
        this.subQuery = sq;
    }

    public Expression(int type, Expression[] list) {
        this(type);
        this.nodes = list;
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String ddl = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 93: 
            case 96: {
                return ddl;
            }
        }
        StringBuffer sb = new StringBuffer();
        ddl = sb.append('(').append(ddl).append(')').toString();
        return ddl;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                sb.append('(');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 26: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                return sb.toString();
            }
        }
        switch (this.opType) {
            case 19: {
                sb.append("ARRAY").append('[');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                sb.append(']');
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                sb.append('(');
                if (this.subQuery != null) {
                    sb.append(this.subQuery.sql);
                }
                sb.append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return sb.toString();
    }

    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.opType) {
            case 1: {
                result.put("opType", "VALUE");
                result.put("value", this.valueData);
                result.put("type", this.dataType.getNameString());
                break;
            }
            case 19: {
                result.put("opType", "ARRAY");
                break;
            }
            case 100: {
                result.put("opType", "ARRAY SUBQUERY");
                break;
            }
            case 22: 
            case 23: {
                result.put("opType", "QUERY");
                result.put("queryExpression", this.subQuery.queryExpression.describeJson(session));
                break;
            }
            case 25: {
                result.put("opType", "ROW");
                ArrayList<Map<String, Object>> nodesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.nodes.length; ++i) {
                    nodesExplained.add(this.nodes[i].describeJson(session));
                }
                result.put("nodes", nodesExplained);
                break;
            }
            case 26: {
                result.put("opType", "VALUELIST");
                ArrayList<Map<String, Object>> nodesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.nodes.length; ++i) {
                    nodesExplained.add(this.nodes[i].describeJson(session));
                }
                result.put("nodes", nodesExplained);
                break;
            }
        }
        return result;
    }

    public String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 19: {
                sb.append("ARRAY ");
                return sb.toString();
            }
            case 100: {
                sb.append("ARRAY SUBQUERY");
                return sb.toString();
            }
            case 22: 
            case 23: {
                sb.append("QUERY ");
                sb.append(this.subQuery.queryExpression.describe(session, blanks));
                return sb.toString();
            }
            case 25: {
                sb.append("ROW = ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
            case 26: {
                sb.append("VALUELIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
        }
        return sb.toString();
    }

    public void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType || this.exprSubType != other.exprSubType || !Expression.equals(this.dataType, other.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 1: {
                return Expression.equals(this.valueData, other.valueData);
            }
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                return this.subQuery.queryExpression.isEquivalent(other.subQuery.queryExpression);
            }
        }
        return Expression.equals(this.nodes, other.nodes) && Expression.equals(this.subQuery, other.subQuery);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Expression) {
            return this.equals((Expression)other);
        }
        return false;
    }

    public int hashCode() {
        int val = this.opType + this.exprSubType;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            val += this.nodes[i].hashCode();
        }
        return val;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static boolean equals(Expression[] row1, Expression[] row2) {
        if (row1 == row2) {
            return true;
        }
        if (row1.length != row2.length) {
            return false;
        }
        int len = row1.length;
        for (int i = 0; i < len; ++i) {
            boolean equals;
            Expression e1 = row1[i];
            Expression e2 = row2[i];
            boolean bl = e1 == null ? e2 == null : (equals = e1.equals(e2));
            if (equals) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] exprList, int start, int end, OrderedIntHashSet excludeSet) {
        if (this.opType == 1) {
            return true;
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (int i = start; i < end; ++i) {
            if (!this.equals(exprList[i])) continue;
            return true;
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 100: {
                return false;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            result &= this.nodes[i] == null || this.nodes[i].isComposedOf(exprList, start, end, excludeSet);
        }
        return result;
    }

    boolean isComposedOf(OrderedHashSet expressions, OrderedIntHashSet excludeSet) {
        if (this.opType == 1 || this.opType == 8 || this.opType == 7 || this.opType == 6) {
            return true;
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (int i = 0; i < expressions.size(); ++i) {
            if (!this.equals(expressions.get(i))) continue;
            return true;
        }
        switch (this.opType) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return false;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            result &= this.nodes[i] == null || this.nodes[i].isComposedOf(expressions, excludeSet);
        }
        return result;
    }

    public Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null) {
            this.subQuery.queryExpression.replaceColumnReference(range, list);
        }
        return this;
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].replaceRangeVariables(ranges, newRanges);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null) {
            this.subQuery.queryExpression.replaceRangeVariables(ranges, newRanges);
        }
    }

    public void resetColumnReferences() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resetColumnReferences();
        }
    }

    void convertToSimpleColumn(OrderedHashSet expressions, OrderedHashSet replacements) {
        if (this.opType == 1) {
            return;
        }
        if (this.opType == 5) {
            return;
        }
        int index = expressions.getIndex(this);
        if (index != -1) {
            Expression e = (Expression)replacements.get(index);
            this.nodes = emptyArray;
            this.opType = 5;
            this.columnIndex = e.columnIndex;
            this.rangePosition = e.rangePosition;
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].convertToSimpleColumn(expressions, replacements);
        }
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    void setAggregate() {
        this.isAggregate = true;
    }

    protected boolean isSelfAggregate() {
        return false;
    }

    public void setAlias(NameManager.SimpleName name) {
        this.alias = name;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    NameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        return null;
    }

    public int getType() {
        return this.opType;
    }

    public Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    public Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    public void setLeftNode(Expression e) {
        this.nodes[0] = e;
    }

    public void setRightNode(Expression e) {
        this.nodes[1] = e;
    }

    public void setSubType(int i) {
        this.exprSubType = i;
    }

    public RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(columns, length);
        }
        return this;
    }

    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        return -1;
    }

    public void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
        HsqlList unresolvedExpressions;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null && (unresolvedExpressions = this.subQuery.queryExpression.getUnresolvedExpressions()) != null) {
            for (int i = 0; i < unresolvedExpressions.size(); ++i) {
                Expression e = (Expression)unresolvedExpressions.get(i);
                e.collectRangeVariables(rangeVariables, set);
            }
        }
    }

    public void collectObjectNames(Set set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectObjectNames(set);
        }
        if (this.subQuery != null) {
            this.subQuery.collectViewReferences(set);
            if (this.subQuery.queryExpression != null) {
                this.subQuery.queryExpression.collectObjectNames(set);
            }
        }
    }

    boolean hasReference(RangeVariable range) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return this.subQuery != null && this.subQuery.queryExpression != null && this.subQuery.queryExpression.hasReference(range);
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, HsqlList unresolvedSet) {
        return this.resolveColumnReferences(session, rangeVarArray, rangeVarArray.length, unresolvedSet, true);
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 26: 
            case 30: {
                HsqlList localSet = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    localSet = this.nodes[i].resolveColumnReferences(session, RangeVariable.emptyArray, localSet);
                }
                if (localSet != null) {
                    this.isCorrelated = true;
                    if (this.subQuery != null) {
                        this.subQuery.setCorrelated();
                    }
                    unresolvedSet = Expression.resolveColumnSet(session, rangeVarArray, rangeCount, localSet, unresolvedSet);
                }
                return unresolvedSet;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        switch (this.opType) {
            case 19: {
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                QueryExpression queryExpression = this.subQuery.queryExpression;
                if (queryExpression instanceof QuerySpecification) {
                    ((QuerySpecification)queryExpression).resolveVtableParameters(session);
                }
                if (queryExpression.areColumnsResolved()) break;
                this.isCorrelated = true;
                this.subQuery.setCorrelated();
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.addAll(queryExpression.getUnresolvedExpressions());
                break;
            }
        }
        return unresolvedSet;
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                if (this.subQuery == null) break;
                if (unresolvedSet == null) {
                    unresolvedSet = new OrderedHashSet();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodeDataTypes[i] = this.nodes[i].dataType;
                }
                break;
            }
            case 19: {
                int i2;
                boolean hasUndefined = false;
                Type nodeDataType = null;
                for (i2 = 0; i2 < this.nodes.length; ++i2) {
                    if (this.nodes[i2].dataType == null) {
                        hasUndefined = true;
                        continue;
                    }
                    nodeDataType = Type.getAggregateType(nodeDataType, this.nodes[i2].dataType);
                }
                if (hasUndefined) {
                    for (i2 = 0; i2 < this.nodes.length; ++i2) {
                        if (this.nodes[i2].dataType != null) continue;
                        this.nodes[i2].dataType = nodeDataType;
                    }
                }
                this.dataType = new ArrayType(nodeDataType, this.nodes.length);
                return;
            }
            case 100: {
                QueryExpression queryExpression = this.subQuery.queryExpression;
                queryExpression.resolveTypes(session);
                this.subQuery.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                Type temp = this.nodeDataTypes[0];
                if (this.nodeDataTypes.length > 1) {
                    throw Error.error(5564);
                }
                this.dataType = new ArrayType(temp, -1);
                this.nodeDataTypes[0] = new ArrayType(temp, -1);
                break;
            }
            case 22: 
            case 23: {
                QueryExpression queryExpression = this.subQuery.queryExpression;
                queryExpression.resolveTypes(session);
                this.subQuery.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session) {
        this.valueData = this.getValue(session);
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void setAsConstantValue(Object value) {
        this.valueData = value;
        this.opType = 1;
        this.nodes = emptyArray;
    }

    public void prepareTable(Session session, Expression row, int degree) {
        if (this.nodeDataTypes != null) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            if (e.opType == 25) {
                if (degree == e.nodes.length) continue;
                throw Error.error(5564);
            }
            if (degree == 1) {
                this.nodes[i] = new Expression(25);
                this.nodes[i].nodes = new Expression[]{e};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[degree];
        for (int j = 0; j < degree; ++j) {
            Type type = row == null ? null : row.nodes[j].dataType;
            boolean hasUresolvedParameter = row == null ? false : row.nodes[j].isUnresolvedParam();
            for (int i = 0; i < this.nodes.length; ++i) {
                type = Type.getAggregateType(this.nodes[i].nodes[j].dataType, type);
                hasUresolvedParameter |= this.nodes[i].nodes[j].isUnresolvedParam();
            }
            if (type == null) {
                type = Type.SQL_VARCHAR_DEFAULT;
            }
            int typeCode = type.typeCode;
            if (hasUresolvedParameter && type.isCharacterType() && (typeCode == 1 || type.precision < Type.SQL_VARCHAR_DEFAULT.precision)) {
                if (typeCode == 1) {
                    typeCode = 12;
                }
                long precision = Math.max(Type.SQL_VARCHAR_DEFAULT.precision, type.precision);
                type = CharacterType.getCharacterType(typeCode, precision, type.getCollation());
            }
            this.nodeDataTypes[j] = type;
            if (row != null && row.nodes[j].isUnresolvedParam()) {
                row.nodes[j].dataType = type;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].nodes[j].isUnresolvedParam()) {
                    this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
                    continue;
                }
                if (this.nodes[i].nodes[j].opType != 1 || this.nodes[i].nodes[j].valueData != null) continue;
                this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
            }
            if (this.nodeDataTypes[j].isCharacterType() && ((CharacterType)this.nodeDataTypes[j]).isEqualIdentical()) continue;
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Object[] data = this.nodes[i].getRowValue(session);
            for (int j = 0; j < this.nodeDataTypes.length; ++j) {
                data[j] = this.nodeDataTypes[j].convertToType(session, data[j], this.nodes[i].nodes[j].dataType);
            }
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
                continue;
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public ColumnSchema getColumn() {
        return null;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Type getDataType() {
        return this.dataType;
    }

    byte getNullability() {
        return 2;
    }

    public Type getNodeDataType(int i) {
        if (this.nodeDataTypes == null) {
            if (i > 0) {
                throw Error.runtimeError(201, "Expression");
            }
            return this.dataType;
        }
        return this.nodeDataTypes[i];
    }

    public Type[] getNodeDataTypes() {
        if (this.nodeDataTypes == null) {
            return new Type[]{this.dataType};
        }
        return this.nodeDataTypes;
    }

    public int getDegree() {
        switch (this.opType) {
            case 25: {
                return this.nodes.length;
            }
            case 22: 
            case 23: 
            case 30: {
                if (this.subQuery == null) {
                    return this.nodeDataTypes.length;
                }
                return this.subQuery.queryExpression.getColumnCount();
            }
        }
        return 1;
    }

    public Table getTable() {
        return this.subQuery == null ? null : this.subQuery.getTable();
    }

    public void materialise(Session session) {
        if (this.subQuery == null) {
            return;
        }
        if (this.subQuery.isCorrelated()) {
            this.subQuery.materialiseCorrelated(session);
        } else {
            this.subQuery.materialise(session);
        }
    }

    public Object getValue(Session session, Type type) {
        Object o = this.getValue(session);
        if (o == null || this.dataType == type) {
            return o;
        }
        return type.convertToType(session, o, this.dataType);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (DataspaceException e) {
            return null;
        }
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] data = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    data[i] = this.nodes[i].getValue(session);
                }
                return data;
            }
            case 22: 
            case 23: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                if (session.sessionContext.rangeIterators[this.rangePosition] != null) {
                    return session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                }
                return null;
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] row = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    row[i] = this.nodes[i].getValue(session);
                }
                return row;
            }
            case 19: {
                Object[] array = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    array[i] = this.nodes[i].getValue(session);
                }
                return array;
            }
            case 100: {
                this.subQuery.materialiseCorrelated(session);
                RowSetNavigatorData nav = this.subQuery.getNavigator(session);
                int size = nav.getSize();
                Object[] array = new Object[size];
                nav.beforeFirst();
                int i = 0;
                while (nav.hasNext()) {
                    Object[] data = nav.getNextRowData();
                    array[i] = data[0];
                    ++i;
                }
                return array;
            }
            case 22: 
            case 23: {
                this.subQuery.materialiseCorrelated(session);
                Object[] value = this.subQuery.getValues(session);
                if (value.length == 1) {
                    return value[0];
                }
                return value;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 19: {
                RowSetNavigatorData navigator = this.subQuery.getNavigator(session);
                Object[] array = new Object[navigator.getSize()];
                navigator.beforeFirst();
                int i = 0;
                while (navigator.hasNext()) {
                    Object[] data = navigator.getNext();
                    array[i] = data[0];
                    ++i;
                }
                return Result.newPSMResult(array, this.dataType);
            }
            case 23: {
                this.subQuery.materialiseCorrelated(session);
                RowSetNavigatorData navigator = this.subQuery.getNavigator(session);
                Result result = Result.newResult(navigator);
                result.metaData = this.subQuery.queryExpression.getMetaData();
                return result;
            }
        }
        Object value = this.getValue(session);
        return Result.newPSMResult(value, this.dataType);
    }

    public boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] a) {
        int nulls = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) continue;
            ++nulls;
        }
        return nulls;
    }

    public boolean isIndexable(RangeVariable range) {
        return false;
    }

    static void convertToType(Session session, Object[] data, Type[] dataType, Type[] newType) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = newType[i].convertToType(session, data[i], dataType[i]);
        }
    }

    public static QuerySpecification getCheckSelect(Session session, Table t, Expression e) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session, null);
        compileContext.reset(0);
        QuerySpecification s = new QuerySpecification(compileContext);
        RangeVariable[] ranges = new RangeVariable[]{new RangeVariable(t, null, null, null, compileContext)};
        e.resolveCheckOrGenExpression(session, ranges, true);
        s.exprColumns = new Expression[1];
        s.exprColumns[0] = EXPR_TRUE;
        s.rangeVariables = ranges;
        if (Type.SQL_BOOLEAN != e.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical condition = new ExpressionLogical(48, e);
        s.queryCondition = condition;
        s.resolveReferences(session, RangeVariable.emptyArray);
        s.resolveTypes(session);
        return s;
    }

    public void resolveCheckOrGenExpression(Session session, RangeVariable[] ranges, boolean isCheck) {
        int i;
        boolean nonDeterministic = false;
        OrderedHashSet set = new OrderedHashSet();
        HsqlList unresolved = this.resolveColumnReferences(session, ranges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        this.resolveTypes(session, null);
        this.collectAllExpressions(set, subqueryAggregateExpressionSet, emptyExpressionSet);
        if (!set.isEmpty()) {
            throw Error.error(5512);
        }
        this.collectAllExpressions(set, functionExpressionSet, emptyExpressionSet);
        for (i = 0; i < set.size(); ++i) {
            Expression current = (Expression)set.get(i);
            if (current.opType == 27 && !((FunctionSQLInvoked)current).isDeterministic()) {
                throw Error.error(5512);
            }
            if (current.opType != 28 || ((FunctionSQL)current).isDeterministic()) continue;
            if (isCheck) {
                nonDeterministic = true;
                continue;
            }
            throw Error.error(5512);
        }
        if (isCheck && nonDeterministic) {
            HsqlArrayList list = new HsqlArrayList();
            RangeVariableResolver.decomposeAndConditions(session, this, list);
            block9: for (int i2 = 0; i2 < list.size(); ++i2) {
                boolean b;
                nonDeterministic = true;
                Expression e = (Expression)list.get(i2);
                if (!(e instanceof ExpressionLogical) || !(b = ((ExpressionLogical)e).convertToSmaller())) break;
                Expression e1 = e.getRightNode();
                e = e.getLeftNode();
                if (!e.dataType.isDateTimeType()) {
                    nonDeterministic = true;
                    break;
                }
                if (e.hasNonDeterministicFunction()) {
                    nonDeterministic = true;
                    break;
                }
                if (e1 instanceof ExpressionArithmetic) {
                    if (this.opType == 32) {
                        if (e1.getRightNode().hasNonDeterministicFunction()) {
                            e1.swapLeftAndRightNodes();
                        }
                    } else if (this.opType != 33) break;
                    if (e1.getRightNode().hasNonDeterministicFunction()) break;
                    e1 = e1.getLeftNode();
                }
                if (e1.opType != 28) break;
                FunctionSQL function = (FunctionSQL)e1;
                switch (function.funcType) {
                    case 43: 
                    case 50: 
                    case 52: {
                        nonDeterministic = false;
                        continue block9;
                    }
                }
            }
            if (nonDeterministic) {
                throw Error.error(5512);
            }
        }
        set.clear();
        this.collectObjectNames(set);
        block10: for (i = 0; i < set.size(); ++i) {
            NameManager.ObjectName name = (NameManager.ObjectName)set.get(i);
            switch (name.type) {
                case 10: {
                    int colIndex;
                    ColumnSchema column;
                    if (isCheck || !(column = ranges[0].rangeTable.getColumn(colIndex = ranges[0].rangeTable.findColumn(name.name))).isGenerated()) continue block10;
                    throw Error.error(5512);
                }
                case 8: {
                    throw Error.error(5512);
                }
                case 25: {
                    RplScript routine = (RplScript)session.dataspaceStore.schemaManager.getSchemaObject(name);
                    if (routine.isDeterministic()) continue block10;
                    throw Error.error(5512);
                }
            }
        }
        set.clear();
    }

    public boolean isUnresolvedParam() {
        return false;
    }

    public boolean isDynamicParam() {
        return false;
    }

    boolean hasNonDeterministicFunction() {
        OrderedHashSet list = null;
        if ((list = this.collectAllExpressions(list, functionExpressionSet, emptyExpressionSet)) == null) {
            return false;
        }
        for (int j = 0; j < list.size(); ++j) {
            Expression current = (Expression)list.get(j);
            if (!(current.opType == 27 ? !((FunctionSQLInvoked)current).isDeterministic() : current.opType == 28 && !((FunctionSQL)current).isDeterministic())) continue;
            return true;
        }
        return false;
    }

    void swapLeftAndRightNodes() {
        Expression temp = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = temp;
    }

    public void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        throw Error.runtimeError(201, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        if (stopAtTypeSet.contains(this.opType)) {
            return set;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (typeSet.contains(this.opType)) {
            if (set == null) {
                set = new OrderedHashSet();
            }
            set.add(this);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null) {
            set = this.subQuery.queryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    public OrderedHashSet getSubqueries() {
        return this.collectAllSubqueries(null);
    }

    public OrderedHashSet collectAllSubqueries(OrderedHashSet set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectAllSubqueries(set);
        }
        if (this.subQuery != null) {
            if (set == null) {
                set = new OrderedHashSet();
            }
            set.add(this.subQuery);
            if (this.subQuery.queryExpression != null) {
                OrderedHashSet tempSet = this.subQuery.queryExpression.getSubqueries();
                set = OrderedHashSet.addAll(set, tempSet);
            }
        }
        return set;
    }

    public boolean isCorrelated() {
        if (this.subQuery == null) {
            return false;
        }
        return this.subQuery.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        OrderedHashSet set = null;
        if ((set = this.collectAllExpressions(set, subqueryAggregateExpressionSet, emptyExpressionSet)) != null && !set.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    public static HsqlList resolveColumnSet(Session session, RangeVariable[] rangeVars, int rangeCount, HsqlList sourceSet, HsqlList targetSet) {
        if (sourceSet == null) {
            return targetSet;
        }
        for (int i = 0; i < sourceSet.size(); ++i) {
            Expression e = (Expression)sourceSet.get(i);
            targetSet = e.resolveColumnReferences(session, rangeVars, rangeCount, targetSet, false);
        }
        return targetSet;
    }

    boolean isTargetRangeVariables(RangeVariable range) {
        return false;
    }

    public RangeVariable[] getJoinRangeVariables(RangeVariable[] ranges) {
        return RangeVariable.emptyArray;
    }

    public double costFactor(Session session, RangeVariable range, int operation) {
        return 16.0;
    }

    public Expression getIndexableExpression(RangeVariable rangeVar) {
        return null;
    }

    public Expression duplicate() {
        Expression e = null;
        try {
            e = (Expression)super.clone();
            e.nodes = (Expression[])this.nodes.clone();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                e.nodes[i] = this.nodes[i].duplicate();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "Expression");
        }
        return e;
    }

    void replaceNode(Expression existing, Expression replacement) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != existing) continue;
            replacement.alias = this.nodes[i].alias;
            this.nodes[i] = replacement;
            return;
        }
    }

    public Object updateAggregatingValue(Session session, Object currValue) {
        throw Error.runtimeError(201, "Expression");
    }

    public Object getAggregatedValue(Session session, Object currValue) {
        throw Error.runtimeError(201, "Expression");
    }

    public Expression getCondition() {
        return null;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setCondition(Expression e) {
        throw Error.runtimeError(201, "Expression");
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }

    public boolean isFutureFunctionSensitive() {
        return this.futureFunctionSensitive;
    }

    public String toString() {
        return this.getSQL();
    }

    static {
        aggregateFunctionSet.add(71);
        aggregateFunctionSet.add(72);
        aggregateFunctionSet.add(73);
        aggregateFunctionSet.add(74);
        aggregateFunctionSet.add(75);
        aggregateFunctionSet.add(76);
        aggregateFunctionSet.add(77);
        aggregateFunctionSet.add(78);
        aggregateFunctionSet.add(79);
        aggregateFunctionSet.add(80);
        aggregateFunctionSet.add(81);
        aggregateFunctionSet.add(83);
        aggregateFunctionSet.add(82);
        aggregateFunctionSet.add(85);
        aggregateFunctionSet.add(98);
        aggregateFunctionSet.add(119);
        columnExpressionSet = new OrderedIntHashSet();
        columnExpressionSet.add(2);
        subqueryExpressionSet = new OrderedIntHashSet();
        subqueryExpressionSet.add(22);
        subqueryExpressionSet.add(23);
        subqueryAggregateExpressionSet = new OrderedIntHashSet();
        subqueryAggregateExpressionSet.add(71);
        subqueryAggregateExpressionSet.add(72);
        subqueryAggregateExpressionSet.add(73);
        subqueryAggregateExpressionSet.add(74);
        subqueryAggregateExpressionSet.add(75);
        subqueryAggregateExpressionSet.add(76);
        subqueryAggregateExpressionSet.add(77);
        subqueryAggregateExpressionSet.add(78);
        subqueryAggregateExpressionSet.add(79);
        subqueryAggregateExpressionSet.add(80);
        subqueryAggregateExpressionSet.add(81);
        subqueryAggregateExpressionSet.add(83);
        subqueryAggregateExpressionSet.add(82);
        subqueryAggregateExpressionSet.add(85);
        subqueryAggregateExpressionSet.add(98);
        subqueryAggregateExpressionSet.add(23);
        subqueryAggregateExpressionSet.add(22);
        functionExpressionSet = new OrderedIntHashSet();
        functionExpressionSet.add(28);
        functionExpressionSet.add(27);
        emptyExpressionSet = new OrderedIntHashSet();
    }
}

