/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.range.RangeVariable;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ExplainComplexity {
    private final RangeVariable[] rangeVariables;
    private Boolean[] isIndexScan;
    private long[] sampleCounts;
    private long unitSize;
    private long unitEstTimeMs;

    public ExplainComplexity(RangeVariable[] rangeVariables, DataspaceStore dataspaceStore) {
        this.rangeVariables = rangeVariables;
        this.unitSize = dataspaceStore.getProperties().getIntegerProperty("dtspace.governor.unit_size");
        this.unitEstTimeMs = dataspaceStore.getProperties().getIntegerProperty("dtspace.governor.unit_est_time_ms");
    }

    public long getUnitSize() {
        return this.unitSize;
    }

    public long getUnitEstTimeMs() {
        return this.unitEstTimeMs;
    }

    public void init() {
        this.isIndexScan = new Boolean[this.rangeVariables.length];
        this.sampleCounts = new long[this.rangeVariables.length];
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.isIndexScan[i] = !this.rangeVariables[i].isFullScan();
            this.sampleCounts[i] = this.rangeVariables[i].rangeTable.getSampleCount();
        }
    }

    public String getComplexity() {
        return "O(" + (this.isIndexScan.length > 0 ? Arrays.stream(this.isIndexScan).map(bb -> bb != false ? "log(N)" : "N").collect(Collectors.joining("*")) : "1") + ")";
    }

    public double getIterationsCount() {
        return IntStream.range(0, this.isIndexScan.length).mapToDouble(i -> this.isIndexScan[i] != false ? Math.log(this.sampleCounts[i]) : (double)this.sampleCounts[i]).map(a -> a == 0.0 ? 1.0 : a).reduce(1.0, (a1, a2) -> a1 * a2);
    }

    public String getIterationsCountString() {
        return String.format("%.2f", this.getIterationsCount());
    }

    public long getEstimatedDurationMs() {
        return Math.round(this.getIterationsCount() / (double)this.unitSize * (double)this.unitEstTimeMs);
    }

    public String getEstimatedDurationString() {
        long ms = this.getEstimatedDurationMs();
        if (ms < 1000L) {
            return ms + " ms";
        }
        int seconds = (int)(ms / 1000L);
        ms -= (long)(seconds * 1000);
        if (seconds < 60) {
            return String.format("%.2f secs", Float.valueOf((float)seconds + (float)ms / 1000.0f));
        }
        int minutes = seconds / 60;
        seconds -= 60 * minutes;
        if (minutes < 60) {
            return String.format("%.2f minutes", (double)minutes + (double)seconds / 60.0);
        }
        int hours = minutes / 60;
        return String.format("%.2f hours", (double)hours + (double)(minutes -= 60 * hours) / 60.0);
    }
}

