/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.ParserBase;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.rowset.RowSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ExecImmediateExpression
extends Expression {
    private List<Expression> expressions;
    private String sql;

    public ExecImmediateExpression(List<Expression> expressions, String sql) {
        super(1);
        this.expressions = expressions;
        this.sql = sql;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (Expression expression : this.expressions) {
            unresolvedSet = expression.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (Expression expression : this.expressions) {
            expression.resolveTypes(session, parent);
        }
        this.dataType = new OtherType("RowSet", RowSet.class);
    }

    @Override
    public Object getValue(Session session) {
        Result result = this.getResult(session);
        if (result.isError()) {
            if (result.getException() != null) {
                throw new DataspaceException("Exec immediate error: " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
            }
            throw new DataspaceException("Exec immediate error: " + result.getMainString());
        }
        List<RowSet> rowSets = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(true)).createRowSets(session, result);
        if (rowSets.size() == 0) {
            return null;
        }
        if (rowSets.size() == 1) {
            return rowSets.get(0);
        }
        return rowSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getResult(Session session) {
        Expression statementExpression = this.expressions.get(0);
        Object statementObject = statementExpression.getValue(session);
        if (!((statementObject = OtherTypeWrapper.unwrap(statementObject)) instanceof String)) {
            throw new DataspaceException("Query is not instance of string.");
        }
        String statementSql = (String)statementObject;
        statementSql = this.resolveVars(session, statementSql);
        StatementCompound currentCompountStatementContext = session.sessionContext.compoundStatementContext;
        RangeVariable[] currentSessionVariablesRange = session.sessionContext.sessionVariablesRange;
        if (session.sessionContext.rplObject instanceof RplScript && ((RplScript)session.sessionContext.rplObject).statement instanceof StatementCompound) {
            session.sessionContext.compoundStatementContext = (StatementCompound)((RplScript)session.sessionContext.rplObject).statement;
            session.sessionContext.sessionVariablesRange = ((StatementCompound)((RplScript)session.sessionContext.rplObject).statement).rangeVariables;
        } else if (session.sessionContext.rplObject instanceof EventTriggerDefSQL && ((EventTriggerDefSQL)session.sessionContext.rplObject).routine instanceof RplScript && ((EventTriggerDefSQL)session.sessionContext.rplObject).routine.statement instanceof StatementCompound) {
            session.sessionContext.compoundStatementContext = (StatementCompound)((EventTriggerDefSQL)session.sessionContext.rplObject).routine.statement;
            session.sessionContext.sessionVariablesRange = ((StatementCompound)((EventTriggerDefSQL)session.sessionContext.rplObject).routine.statement).rangeVariables;
        }
        try {
            Statement statement = new ParserCommand(session, new Scanner(statementSql)).compileStatement(0);
            Object[] args = null;
            Object secondValue = null;
            if (this.expressions.size() >= 2) {
                secondValue = OtherTypeWrapper.unwrap(this.expressions.get(1).getValue(session));
            }
            if (this.expressions.size() == 2 && secondValue instanceof Collection) {
                Collection c = (Collection)secondValue;
                args = new Object[c.size()];
                Iterator iterator = c.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    args[i++] = iterator.next();
                }
            } else {
                args = new Object[this.expressions.size() - 1];
                if (args.length > 0) {
                    args[0] = secondValue;
                    for (int i = 2; i < this.expressions.size(); ++i) {
                        args[i - 1] = OtherTypeWrapper.unwrap(this.expressions.get(i).getValue(session));
                    }
                }
            }
            session.sessionContext.push();
            try {
                Result result = session.executeCompiledStatement(statement, args);
                session.sessionContext.pop();
                return result;
            }
            catch (Throwable throwable) {
                session.sessionContext.pop();
                throw throwable;
            }
        }
        finally {
            session.sessionContext.compoundStatementContext = currentCompountStatementContext;
            session.sessionContext.sessionVariablesRange = currentSessionVariablesRange;
        }
    }

    private String resolveVars(Session session, String sql) {
        StringBuilder builder = new StringBuilder();
        Scanner scanner = new Scanner(sql);
        int lastPosition = 0;
        while (scanner.getToken().tokenType != 848) {
            scanner.scanNext();
            ParserBase.checkMalformedToken(scanner.getToken());
            if (scanner.getToken().tokenType != 794) continue;
            int startVarPosition = scanner.getTokenPosition();
            scanner.scanNext();
            if (scanner.getToken().tokenType == 848 || !scanner.getToken().isUndelimitedIdentifier()) continue;
            String varName = scanner.getToken().getTokenString();
            int endVarPosition = scanner.getCurrentPosition();
            ExpressionColumn varExpression = null;
            RangeVariable[] rangeVariables = session.sessionContext.rplObject instanceof RplScript ? ((RplScript)session.sessionContext.rplObject).statement.getRangeVariables() : (session.sessionContext.rplObject instanceof Actor ? ((Actor)session.sessionContext.rplObject).getRoutine().statement.getRangeVariables() : (session.sessionContext.rplObject instanceof TriggerDef ? ((TriggerDef)((Object)session.sessionContext.rplObject)).routine.statement.getRangeVariables() : session.sessionContext.sessionVariablesRange));
            for (int i = 0; i < rangeVariables.length; ++i) {
                int index;
                if (rangeVariables[i] == null || (index = rangeVariables[i].findColumn(varName)) <= -1) continue;
                ColumnSchema column = rangeVariables[i].getColumn(index);
                varExpression = new ExpressionColumn(column, index, varName, null);
                varExpression.resolveColumnReferences(session, rangeVariables, null);
                break;
            }
            if (varExpression == null) {
                throw new DataspaceException("Exec immediate: variable @" + varName + " doesn't exist.");
            }
            Object varValue = varExpression.getValue(session);
            builder.append(sql.substring(lastPosition, startVarPosition));
            builder.append(" ").append(varValue).append(" ");
            lastPosition = endVarPosition;
        }
        builder.append(sql.substring(lastPosition));
        return builder.toString();
    }

    @Override
    public String getSQL() {
        return this.sql;
    }
}

