/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.rowset.RowSet;
import java.util.List;

public class ExecBlockExpression
extends Expression {
    private RplScript routine;
    private String sql;

    public ExecBlockExpression(RplScript routine, String sql) {
        super(1);
        this.routine = routine;
        this.sql = sql;
    }

    @Override
    public Object getValue(Session session) {
        Result result = this.getResult(session);
        if (result.isError()) {
            if (result.getException() != null) {
                throw new DataspaceException("Exec block error: " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
            }
            throw new DataspaceException("Exec block error: " + result.getMainString());
        }
        List<RowSet> rowSets = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(true)).createRowSets(session, result);
        if (rowSets.size() == 0) {
            return null;
        }
        if (rowSets.size() == 1) {
            return rowSets.get(0);
        }
        return rowSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getResult(Session session) {
        session.sessionContext.push();
        try {
            Result result;
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            RplSchemaObject rplObject = session.sessionContext.rplObject;
            try {
                session.sessionContext.rplObject = this.routine;
                result = this.routine.statement.execute(session);
            }
            finally {
                session.sessionContext.rplObject = rplObject;
            }
            session.sessionContext.closeRoutineVariables();
            Result result2 = result;
            return result2;
        }
        finally {
            session.sessionContext.pop();
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }
}

