/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.Trace;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;

public class DataspaceQueryMemoryMonitor {
    private MemoryPoolMXBean oldGenMemoryPool;
    private int thresholdPercent;
    private long thresholdBytes;
    private Checker checker;
    private int chkRowsStart;
    private int chkRowsInterval;

    public DataspaceQueryMemoryMonitor(int thresholdPercent, int chkRowsStart, int chkRowsInterval) {
        this.initOldGenMemoryPool();
        this.setThresholdPercent(thresholdPercent);
        this.setChkRowsStart(chkRowsStart);
        this.setChkRowsInterval(chkRowsInterval);
    }

    private void initOldGenMemoryPool() {
        if (this.oldGenMemoryPool != null) {
            return;
        }
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !DataspaceQueryMemoryMonitor.isOldGenName(pool.getName())) continue;
            this.oldGenMemoryPool = pool;
            break;
        }
        if (this.oldGenMemoryPool == null) {
            Trace.logError(DataspaceQueryMemoryMonitor.class, "Failed to get on old gen memory pool.");
        }
    }

    public void setThresholdPercent(int thresholdPercent) {
        if (thresholdPercent <= 0) {
            thresholdPercent = 0;
        }
        this.thresholdPercent = thresholdPercent;
        this.initOldGenMemoryPool();
        if (this.oldGenMemoryPool == null) {
            return;
        }
        if (thresholdPercent == 0) {
            if (this.checker != null) {
                this.checker.updateThreshold();
                this.checker = null;
            }
        } else {
            Trace.logDebug(this, "Not use thresholds.");
            this.checker = new Checker(){
                {
                    this.updateThreshold();
                }

                @Override
                public void updateThreshold() {
                    DataspaceQueryMemoryMonitor.this.thresholdBytes = DataspaceQueryMemoryMonitor.this.getBytesThreshold(DataspaceQueryMemoryMonitor.this.oldGenMemoryPool.getUsage().getMax());
                }

                @Override
                public boolean isExceeded() {
                    return DataspaceQueryMemoryMonitor.this.thresholdBytes > 0L && DataspaceQueryMemoryMonitor.this.oldGenMemoryPool.getUsage().getUsed() > DataspaceQueryMemoryMonitor.this.thresholdBytes;
                }
            };
        }
    }

    public int getThresholdPercent() {
        return this.thresholdPercent;
    }

    public int getChkRowsStart() {
        return this.chkRowsStart;
    }

    public void setChkRowsStart(int chkRowsStart) {
        this.chkRowsStart = chkRowsStart;
    }

    public int getChkRowsInterval() {
        return this.chkRowsInterval;
    }

    public void setChkRowsInterval(int chkRowsInterval) {
        this.chkRowsInterval = chkRowsInterval;
    }

    public boolean isExceeded() {
        if (this.checker == null) {
            return false;
        }
        if (this.checker.isExceeded()) {
            System.gc();
            return this.checker.isExceeded();
        }
        return false;
    }

    private long getBytesThreshold(long max) {
        return max * (long)this.thresholdPercent / 100L;
    }

    public static boolean isOldGenName(String name) {
        if (name == null) {
            return false;
        }
        return (name = name.toLowerCase()).indexOf("old") != -1 && name.indexOf("gen") != -1;
    }

    private static interface Checker {
        public void updateThreshold();

        public boolean isExceeded();
    }
}

