/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.session.Session;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VariableCompleter
implements PrefixCompleter {
    private Session session;
    private VariableScope scope;

    public VariableCompleter(Session session) {
        this(session, VariableScope.ALL);
    }

    public VariableCompleter(Session session, VariableScope scope) {
        this.session = session;
        this.scope = scope;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        RangeVariable[] vars = null;
        vars = this.session.sessionContext.compoundStatementContext != null ? this.session.sessionContext.compoundStatementContext.getRangeVariables() : this.session.sessionContext.sessionVariablesRange;
        if (vars != null) {
            ArrayList<String> variableNames = new ArrayList<String>();
            HashMap<String, String> variableTypes = new HashMap<String, String>();
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i] == null || vars[i].getVariables() == null || this.scope == VariableScope.PARAMETERS && vars[i].rangeType != 3) continue;
                if (vars[i].rangeType == 2 && vars[i].getTableAlias() != null) {
                    String variableName = vars[i].getTableAlias().getNameString();
                    variableNames.add(variableName);
                    variableTypes.put(variableName, "ROW");
                    continue;
                }
                HashMappedList variables = vars[i].getVariables();
                for (int j = 0; j < variables.size(); ++j) {
                    ColumnSchema variable = (ColumnSchema)variables.get(j);
                    String variableName = variable.getNameString();
                    if (prefix != null && !variableName.startsWith(prefix)) continue;
                    variableNames.add(variableName);
                    variableTypes.put(variableName, SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(variable.getDataType()));
                }
            }
            DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, variableNames);
            if (completion != null) {
                for (Map.Entry entry : variableTypes.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(prefix)) continue;
                    Suggestion suggestion = new TypedParameterSuggestion((String)entry.getKey(), (String)entry.getValue(), SuggestionGroup.VARIABLE).setOffset(prefix);
                    completion.addSuggestion(suggestion);
                }
                completion.checkAndCompress();
                completion.moveSingleSuggestionToCompletion();
            }
            return completion;
        }
        return null;
    }

    public static enum VariableScope {
        ALL,
        PARAMETERS;

    }
}

