/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractServiceEventHandlerCompleter;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class ServiceEventHandlerCompleter
extends AbstractServiceEventHandlerCompleter
implements PrefixCompleter {
    private ServiceAccessor serviceAccessor;
    private String serviceName;

    public ServiceEventHandlerCompleter(ServiceAccessor serviceAccessor, String serviceName, RuntimeContext runtimeContext) {
        super(runtimeContext);
        this.serviceAccessor = serviceAccessor;
        this.serviceName = serviceName;
        if (this.serviceName == null && serviceAccessor != null) {
            this.serviceName = ModeratorUtils.makeComponentFullName(serviceAccessor.isAvailable() ? serviceAccessor.getActualNodeName() : serviceAccessor.getNodeName(), serviceAccessor.getComponentType(), serviceAccessor.getComponentName());
        }
    }

    @Override
    public DSLCompletion complete(String prefix) {
        try {
            return this.complete(this.getEventHandlersProvider(), prefix);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to complete event handlers for service '{}'. Cause: {}", this.serviceName, exception.getMessage());
            return null;
        }
    }

    public EventHandlersProvider getEventHandlersProvider() throws Exception {
        RepositoryAccessor repositoryAccessor;
        if (this.serviceAccessor != null && this.serviceAccessor.isAvailable() && this.serviceAccessor.isOpened()) {
            return new EventHandlersProvider(){

                @Override
                public List<String> listEventHandlers() throws Exception {
                    return ServiceEventHandlerCompleter.this.serviceAccessor.listEventHandlers();
                }

                @Override
                public EventHandler lookupEventHandler(String handlerName) throws Exception {
                    return ServiceEventHandlerCompleter.this.serviceAccessor.lookupEventHandler(handlerName);
                }

                @Override
                public List<EventHandler> getEventHandlers() throws Exception {
                    return ServiceEventHandlerCompleter.this.serviceAccessor.getEventHandlers();
                }

                @Override
                public String getEventHandlerParameterName(String handlerName) throws Exception {
                    return ServiceEventHandlerCompleter.this.serviceAccessor.getEventHandlerParameterName(handlerName);
                }

                @Override
                public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String handlerName) throws Exception {
                    return ServiceEventHandlerCompleter.this.serviceAccessor.getEventHandlerRPLMethodInfo(handlerName);
                }
            };
        }
        if (this.serviceName != null && this.getSystemConnection() != null && (repositoryAccessor = this.getSystemConnection().getRepositoryAccessor(ModeratorUtils.extractNodeName(this.serviceName))) != null) {
            final ServiceConfigurationObject sco = repositoryAccessor.loadServiceConfiguration(ModeratorUtils.extractComponentNameName(this.serviceName), ModeratorUtils.extractComponentNameType(this.serviceName));
            return new EventHandlersProvider(){

                @Override
                public List<String> listEventHandlers() throws Exception {
                    return sco.listEventHandlers();
                }

                @Override
                public EventHandler lookupEventHandler(String handlerName) throws Exception {
                    return sco.getEventHandler(handlerName);
                }

                @Override
                public List<EventHandler> getEventHandlers() throws Exception {
                    return sco.getEventHandlers();
                }

                @Override
                public String getEventHandlerParameterName(String handlerName) {
                    return null;
                }

                @Override
                public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String handlerName) {
                    return null;
                }
            };
        }
        throw new Exception("Failed to create event handlers provider for service " + this.serviceName);
    }

    private DSLCompletion complete(EventHandlersProvider eventHandlersAccessor, String prefix) throws Exception {
        TreeSet<String> eventHandlerNames = new TreeSet<String>();
        for (String eventHandler : eventHandlersAccessor.listEventHandlers()) {
            if (prefix != null && !eventHandler.startsWith(prefix)) continue;
            eventHandlerNames.add(eventHandler);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, new ArrayList<String>(eventHandlerNames));
        if (completion != null) {
            for (String eventHandlerName : eventHandlerNames) {
                try {
                    String parameterName;
                    EventHandler eventHandler = eventHandlersAccessor.lookupEventHandler(eventHandlerName);
                    if (eventHandler == null) continue;
                    TriggerFunctionParserContextImpl parserContext = new TriggerFunctionParserContextImpl(this.runtimeContext);
                    Type<Object> requestType = TypeFactory.createObjectType();
                    Type<Object> responseType = TypeFactory.createObjectType();
                    try {
                        requestType = TypeFactory.createSemanticTypeType(eventHandler.getRequestSemanticType(), parserContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        responseType = TypeFactory.createSemanticTypeType(eventHandler.getResponseSemanticType(), parserContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MethodSuggestion suggestion = new MethodSuggestion(eventHandlerName, responseType.getName(), SuggestionGroup.SERVICE_EVENT_HANDLER);
                    suggestion.setOffset(prefix);
                    RPLMethodsCache.RPLMethodInfo methodInfo = eventHandlersAccessor.getEventHandlerRPLMethodInfo(eventHandlerName);
                    if (methodInfo != null) {
                        suggestion.setDescription(methodInfo.description());
                        suggestion.setSamples(methodInfo.samples());
                    }
                    if ((parameterName = eventHandlersAccessor.getEventHandlerParameterName(eventHandlerName)) == null) {
                        parameterName = "o";
                    }
                    suggestion.addArgument(new MethodSuggestion.MethodArgument(parameterName, new String[]{requestType.getName()}));
                    suggestion.addArgument(new MethodSuggestion.MethodArgument("properties", new String[]{"map"}).setOptional(true));
                    suggestion.addArgument(new MethodSuggestion.MethodArgument("timeout", new String[]{"long"}).setOptional(true));
                    completion.addSuggestion(suggestion);
                }
                catch (FabricComponentAccessorException exception) {
                    Trace.logError(this, "Failed to get event handler with name '{}' of service '{}'.", eventHandlerName, this.serviceName);
                    Trace.logException(this, exception, false);
                }
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    public static interface EventHandlersProvider {
        public List<String> listEventHandlers() throws Exception;

        public EventHandler lookupEventHandler(String var1) throws Exception;

        public List<EventHandler> getEventHandlers() throws Exception;

        public String getEventHandlerParameterName(String var1) throws Exception;

        public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String var1) throws Exception;
    }
}

