/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.parser.completion.SchemaObjectFilter;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableType;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SchemaObjectCompleter
implements PrefixCompleter {
    private DataspaceStore store;
    private String schemaName;
    private List<Integer> objectTypes;
    private SchemaObjectFilter filter;
    private boolean onlyNames;
    private boolean withSystem;
    private boolean inAllDataspaces;

    public SchemaObjectCompleter(DataspaceStore store, String schemaName, Integer ... objectTypes) {
        this.store = store;
        this.schemaName = schemaName;
        this.objectTypes = Arrays.asList(objectTypes);
        this.onlyNames = false;
        this.withSystem = true;
    }

    public SchemaObjectCompleter filter(SchemaObjectFilter filter) {
        this.filter = filter;
        return this;
    }

    public SchemaObjectCompleter onlyNames(boolean onlyNames) {
        this.onlyNames = onlyNames;
        return this;
    }

    public SchemaObjectCompleter withSystem(boolean withSystem) {
        this.withSystem = withSystem;
        return this;
    }

    public SchemaObjectCompleter inAllDataspaces(boolean inAllDataspaces) {
        this.inAllDataspaces = inAllDataspaces;
        return this;
    }

    private void addObjectIfAccepts(String prefix, SchemaObject object, List<String> objectNames, List<SchemaObject> objects) {
        String name = this.quoteName(object);
        if ((prefix == null || name.startsWith(prefix)) && (this.filter == null || this.filter.filter(object)) && (this.inAllDataspaces || object.getSchemaName() == null || object.getSchemaName().name.equalsIgnoreCase(this.schemaName) || prefix != null && prefix.length() > 0) && !objectNames.contains(name)) {
            objectNames.add(name);
            objects.add(object);
        }
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> objectNames = new ArrayList<String>();
        ArrayList<SchemaObject> objects = new ArrayList<SchemaObject>();
        for (Integer objectType : this.objectTypes) {
            Iterator iterator;
            if (objectType == 2) {
                for (DataspaceSchema schema : this.store.schemaManager.getAllSchemas()) {
                    this.addObjectIfAccepts(prefix, schema, objectNames, objects);
                }
                continue;
            }
            if (objectType == 12) {
                iterator = this.store.getGranteeManager().getGrantees().iterator();
                while (iterator.hasNext()) {
                    this.addObjectIfAccepts(prefix, (SchemaObject)iterator.next(), objectNames, objects);
                }
                continue;
            }
            if (objectType == 34) {
                iterator = this.store.schemaManager.dataspaceObjectIterator(this.schemaName, 4);
                while (iterator.hasNext()) {
                    SchemaObject object = (SchemaObject)iterator.next();
                    if (!(object instanceof AbstractCollection) || ((AbstractCollection)object).getReplicationSource() == null) continue;
                    this.addObjectIfAccepts(prefix, object, objectNames, objects);
                }
                continue;
            }
            if (objectType == 41) {
                iterator = this.store.schemaManager.dataspaceObjectIterator("SDS", 41);
                while (iterator.hasNext()) {
                    this.addObjectIfAccepts(prefix, (SchemaObject)iterator.next(), objectNames, objects);
                }
                continue;
            }
            if (objectType == 42) {
                iterator = this.store.schemaManager.dataspaceObjectIterator("SDS", 42);
                while (iterator.hasNext()) {
                    this.addObjectIfAccepts(prefix, (SchemaObject)iterator.next(), objectNames, objects);
                }
                continue;
            }
            if (objectType == 43) {
                iterator = this.store.schemaManager.dataspaceObjectIterator("SDS", 43);
                while (iterator.hasNext()) {
                    this.addObjectIfAccepts(prefix, (SchemaObject)iterator.next(), objectNames, objects);
                }
                continue;
            }
            if (objectType == 44) {
                iterator = this.store.schemaManager.dataspaceObjectIterator("SDS", 44);
                while (iterator.hasNext()) {
                    this.addObjectIfAccepts(prefix, (SchemaObject)iterator.next(), objectNames, objects);
                }
                continue;
            }
            iterator = this.createObjectsIterator(this.schemaName, objectType);
            if (SqlInvariants.isSdsSchemaName(this.schemaName) && (objectType == 4 || objectType == 3 || objectType == 17)) {
                iterator = null;
            }
            if ((iterator = this.wrapForAllDataspaces(iterator, objectType)) != null) {
                while (iterator.hasNext()) {
                    SchemaObject schemaObject;
                    Object object = iterator.next();
                    if (object instanceof NameManager.ObjectName) {
                        object = this.store.schemaManager.findSchemaObject((NameManager.ObjectName)object);
                    }
                    if ((schemaObject = (SchemaObject)object) == null || objectType == 5 && !(schemaObject instanceof View) || (schemaObject.getObjectType() == 14 || schemaObject.getObjectType() == 13) & !this.objectTypes.contains(schemaObject.getObjectType())) continue;
                    this.addObjectIfAccepts(prefix, schemaObject, objectNames, objects);
                }
            }
            if (objectType != 4 && objectType != 3) continue;
            for (Collection collection : this.store.schemaManager.listTransientCollections()) {
                this.addObjectIfAccepts(prefix, collection, objectNames, objects);
            }
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, objectNames);
        if (completion != null) {
            block50: for (SchemaObject object : objects) {
                Suggestion suggestion = null;
                String objectName = this.quoteName(object);
                SuggestionGroup group = SuggestionGroup.SCHEMA_OBJECT;
                switch (object.getObjectType()) {
                    case 17: {
                        if (!this.onlyNames) {
                            if (this.shouldSkipFunction(objectName)) continue block50;
                            RoutineSchema routineSchema = (RoutineSchema)object;
                            RplScript rpl = routineSchema.getSpecificRoutines()[0];
                            suggestion = new MethodSuggestion(objectName, SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(rpl.getReturnType()), SuggestionGroup.ROUTINE).setOffset(prefix);
                            if (rpl.getParameterCount() > 0) {
                                for (int i = 0; i < rpl.getParameterCount(); ++i) {
                                    Type type = rpl.getParameter(i).getDataType();
                                    String[] types = new String[]{SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(type)};
                                    MethodSuggestion.MethodArgument arg = new MethodSuggestion.MethodArgument(rpl.getParameter(i).getNameString(), types);
                                    ((MethodSuggestion)suggestion).addArgument(arg);
                                }
                            }
                            group = SuggestionGroup.ROUTINE;
                            break;
                        }
                    }
                    default: {
                        switch (object.getObjectType()) {
                            case 4: {
                                if (this.shouldSkipTable(objectName)) continue block50;
                                group = SuggestionGroup.COLLECTION;
                                if (!(object instanceof Collection)) break;
                                switch (((Collection)object).getCollectionType()) {
                                    case AUDIT_QUEUE: 
                                    case BLOCKING_QUEUE: 
                                    case EVENT_QUEUE: 
                                    case EVENT_TABLE: 
                                    case MESSAGE_QUEUE: 
                                    case PROCESS_QUEUE: 
                                    case QUEUE: 
                                    case TABLE: {
                                        group = SuggestionGroup.COLLECTION;
                                        break;
                                    }
                                    case DIRECTORY_TABLE: {
                                        group = SuggestionGroup.DIRECTORY_TABLE;
                                        break;
                                    }
                                    case FILE_TABLE: {
                                        group = SuggestionGroup.FILE_TABLE;
                                        break;
                                    }
                                    case JOURNAL_FILE_TABLE: {
                                        group = SuggestionGroup.JOURNAL_FILE_TABLE;
                                        break;
                                    }
                                    case LOG_FILE_TABLE: {
                                        group = SuggestionGroup.LOG_FILE_TABLE;
                                        break;
                                    }
                                    case SEMAGRAPTH_TABLE: {
                                        group = SuggestionGroup.SEMAGRAPH_TABLE;
                                        break;
                                    }
                                    case FUNCTION_TABLE: {
                                        group = SuggestionGroup.FUNCTION_TABLE;
                                        break;
                                    }
                                    case MAP: {
                                        group = SuggestionGroup.MAP;
                                        break;
                                    }
                                    case SOURCE_STREAM: {
                                        group = SuggestionGroup.SOURCE_STREAM;
                                        break;
                                    }
                                    case VIEW: {
                                        group = SuggestionGroup.VIEW;
                                        break;
                                    }
                                    case VTABLE: {
                                        group = SuggestionGroup.VIRTUAL_TABLE;
                                        break;
                                    }
                                }
                                if (((AbstractCollection)object).getReplicationSource() == null || !this.objectTypes.contains(34)) break;
                                group = SuggestionGroup.REPLICATION_SOURCE;
                                break;
                            }
                            case 3: {
                                if (this.shouldSkipTable(objectName)) continue block50;
                                group = SuggestionGroup.TABLE;
                                break;
                            }
                            case 31: {
                                group = SuggestionGroup.JOB;
                                break;
                            }
                            case 32: {
                                group = SuggestionGroup.ACTOR;
                                break;
                            }
                            case 37: {
                                group = SuggestionGroup.REFERENCE_LINK;
                                break;
                            }
                            case 9: {
                                group = SuggestionGroup.TRIGGER;
                                break;
                            }
                            case 17: 
                            case 19: {
                                if (this.shouldSkipFunction(objectName)) continue block50;
                                group = SuggestionGroup.ROUTINE;
                                break;
                            }
                            case 30: {
                                group = SuggestionGroup.TIMER;
                                break;
                            }
                            case 5: {
                                group = SuggestionGroup.VIEW;
                                break;
                            }
                            case 2: {
                                if (this.shouldSkipSchema(objectName)) continue block50;
                                group = SuggestionGroup.SCHEMA;
                                break;
                            }
                            case 29: {
                                if (this.shouldSkipSchema(objectName)) continue block50;
                                group = SuggestionGroup.REPLICATION_TARGET;
                                break;
                            }
                            case 34: {
                                group = SuggestionGroup.REPLICATION_SOURCE;
                                break;
                            }
                            case 27: {
                                switch (((ServerObject)object).getServerRole()) {
                                    case FILE: {
                                        group = SuggestionGroup.FILE_SERVER;
                                        break;
                                    }
                                    case NOSQL: {
                                        if (NoSqlServerObject.NoSqlServerType.AWS.name().equalsIgnoreCase(((ServerObject)object).getServerType())) {
                                            group = SuggestionGroup.AWS_SERVER;
                                            break;
                                        }
                                        group = SuggestionGroup.NOSQL_SERVER;
                                        break;
                                    }
                                    case SQL: {
                                        group = SuggestionGroup.SQL_SERVER;
                                    }
                                }
                                break;
                            }
                            case 12: {
                                group = ((Grantee)object).isRole() ? SuggestionGroup.GROUP : SuggestionGroup.USER;
                                break;
                            }
                            case 14: {
                                group = SuggestionGroup.DOMAIN;
                                break;
                            }
                            case 13: {
                                group = SuggestionGroup.TYPE;
                                break;
                            }
                            case 8: {
                                group = SuggestionGroup.SEQUENCE;
                            }
                        }
                        if (objectName == null) break;
                        suggestion = new TokenSuggestion(objectName).setOffset(prefix);
                    }
                }
                if (suggestion == null) continue;
                suggestion.setGroup(group);
                completion.addSuggestion(suggestion);
            }
            if (completion.getSuggestions() != null && completion.getSuggestions().size() > 0) {
                completion.checkAndCompress();
                completion.moveSingleSuggestionToCompletion();
            } else {
                completion = null;
            }
        }
        return completion;
    }

    private Iterator createObjectsIterator(String schemaName, Integer objectType) {
        Iterator iterator = this.store.schemaManager.dataspaceObjectIterator(schemaName, objectType);
        if (this.withSystem && (objectType == 14 || objectType == 13)) {
            iterator = new WrapperIterator(iterator, this.store.schemaManager.dataspaceObjectIterator("SYS", objectType));
        }
        return iterator;
    }

    private Iterator wrapForAllDataspaces(Iterator iterator, Integer objectType) {
        DataspaceSchema[] schemas;
        for (DataspaceSchema schema : schemas = this.store.schemaManager.getAllSchemas()) {
            if (SqlInvariants.isSystemSchemaName(schema.getName()) || SqlInvariants.isLobsSchemaName(schema.getName()) || SqlInvariants.isRdsSchemaName(schema.getName()) || SqlInvariants.isSdsSchemaName(schema.getName()) || schema.getName().equalsIgnoreCase(this.schemaName)) continue;
            iterator = iterator != null ? new WrapperIterator(iterator, this.createObjectsIterator(schema.getName(), objectType)) : this.createObjectsIterator(schema.getName(), objectType);
        }
        return iterator;
    }

    private boolean shouldSkipTable(String name) {
        if (this.withSystem) {
            return false;
        }
        return this.isSystemTable(name);
    }

    private boolean isSystemTable(String name) {
        return name.equals(HadoopVirtualTableType.HADOOP_APPLICATIONS.getName()) || name.equals(HadoopVirtualTableType.HADOOP_CLUSTER_METRICS.getName());
    }

    private boolean shouldSkipSchema(String name) {
        if (this.withSystem) {
            return false;
        }
        return this.isSystemSchema(name);
    }

    private boolean isSystemSchema(String name) {
        return AbstractOperation.isSystemDataspace(name);
    }

    private boolean shouldSkipFunction(String name) {
        if (this.withSystem) {
            return false;
        }
        return this.isSystemFunction(name);
    }

    private boolean isSystemFunction(String name) {
        return name.equals("deleteTokenForDeletedApplications");
    }

    private String quoteName(SchemaObject object) {
        if (object.getObjectName().schema == null || object.getObjectName().schema.name == null || object.getObjectName().schema.name.equalsIgnoreCase(this.schemaName) || object.getObjectType() == 41 || object.getObjectType() == 42 || object.getObjectType() == 43 || object.getObjectType() == 44) {
            return NameManager.quoteNameIfNeeded(object.getObjectName().name);
        }
        return NameManager.quoteNameIfNeeded(object.getObjectName().schema.name) + "." + NameManager.quoteNameIfNeeded(object.getObjectName().name);
    }
}

