/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.util.List;
import java.util.stream.Collectors;

public class RowColumnCompleter
implements PrefixCompleter {
    private Row row;
    private SemanticTypeLookupContext context;

    public RowColumnCompleter(Row row, SemanticTypeLookupContext context) {
        this.row = row;
        this.context = context;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        if (this.row == null) {
            return null;
        }
        RowMetaData rowMetaData = this.row.getMeta();
        if (rowMetaData == null) {
            return null;
        }
        List matchedColumns = rowMetaData.getColumnDescriptors().stream().filter(c -> c.getName().startsWith(prefix)).collect(Collectors.toList());
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, rowMetaData.getColumnNames());
        if (completion != null) {
            for (ColumnDescriptor column : matchedColumns) {
                completion.addSuggestion(new TypedParameterSuggestion(column.getName(), column.getTypeName(), SuggestionGroup.COLUMN).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

