/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RPLMethodCompleter
implements PrefixCompleter {
    private final RPLMethodsCache cache;
    private final Class<?> parent;
    private boolean includeInherited = false;
    private Function<RPLMethodsCache.RPLMethodInfo, Boolean> filter = null;

    public RPLMethodCompleter(RPLMethodsCache cache, Class<?> parent) {
        this.cache = cache;
        this.parent = parent;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        List<RPLMethodsCache.RPLMethodInfo> methods = this.includeInherited ? this.cache.listMethodsWithInherited(this.parent) : this.cache.listMethods(this.parent);
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, (methods = methods.stream().filter((? super T m) -> m.name().startsWith(prefix) && (this.filter == null || this.filter.apply((RPLMethodsCache.RPLMethodInfo)m) != false)).collect(Collectors.toList())).stream().map(m -> m.name()).collect(Collectors.toList()));
        if (completion != null) {
            for (RPLMethodsCache.RPLMethodInfo methodInfo : methods) {
                completion.addSuggestion(new SyntaxSuggestion(this.buildName(methodInfo), this.buildSyntax(methodInfo), SuggestionGroup.METHOD).setOffset(prefix).setDescription(methodInfo.description()).setSamples(methodInfo.samples()));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    private String buildName(RPLMethodsCache.RPLMethodInfo methodInfo) {
        Object name = methodInfo.name();
        String syntax = methodInfo.syntax();
        if ((syntax == null || syntax.length() == 0) && methodInfo.method().getParameterCount() == 0) {
            name = (String)name + "()";
        }
        return name;
    }

    private String buildSyntax(RPLMethodsCache.RPLMethodInfo methodInfo) {
        Object syntax = methodInfo.syntax();
        if (syntax == null || ((String)syntax).length() == 0) {
            Method method = methodInfo.method();
            if (method.getParameterCount() > 0) {
                TriggerFunctionParserContextImpl context = new TriggerFunctionParserContextImpl(DataspaceStore.getContext());
                syntax = Arrays.asList(method.getParameterTypes()).stream().map(p -> {
                    String typeName = this.resolveInternalTypeName((Class<?>)p);
                    if (typeName == null) {
                        typeName = TypeFactory.resolveTypeName(p, context);
                    }
                    return typeName;
                }).collect(Collectors.joining(", "));
                syntax = "(" + (String)syntax + ")";
            } else {
                syntax = "";
            }
        }
        syntax = (String)syntax + " : " + this.buildReturnType(methodInfo);
        return syntax;
    }

    private String buildReturnType(RPLMethodsCache.RPLMethodInfo methodInfo) {
        if (methodInfo.returnType() != null && methodInfo.returnType().length() > 0) {
            return methodInfo.returnType();
        }
        Class<?> type = methodInfo.method().getReturnType();
        String typeName = this.resolveInternalTypeName(type);
        if (typeName == null) {
            typeName = TypeFactory.resolveTypeName(type, new TriggerFunctionParserContextImpl(DataspaceStore.getContext()));
        }
        return typeName;
    }

    private String resolveInternalTypeName(Class<?> type) {
        if (Column.class.isAssignableFrom(type) || Snapshot.class.isAssignableFrom(type) || Selection.class.isAssignableFrom(type)) {
            return type.getSimpleName();
        }
        return null;
    }

    public RPLMethodCompleter includeInherited(boolean includeInherited) {
        this.includeInherited = includeInherited;
        return this;
    }

    public RPLMethodCompleter filter(Function<RPLMethodsCache.RPLMethodInfo, Boolean> filter) {
        this.filter = filter;
        return this;
    }
}

