/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCacheImpl;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.fields.FieldsMethodsAllowedForCompletion;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.TreeSet;

public class MethodCompleter
implements PrefixCompleter {
    private Class<?> parentClass;
    private SemanticTypeLookupContext context;
    private boolean onlyStaticMethods;

    public MethodCompleter(Class<?> parentClass, SemanticTypeLookupContext context, boolean onlyStaticMethods) {
        this.parentClass = parentClass;
        this.context = context;
        this.onlyStaticMethods = onlyStaticMethods;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        TreeSet<String> methodNames = new TreeSet<String>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.parentClass.getMethods()) {
            if (prefix != null && !method.getName().startsWith(prefix) || !FieldsMethodsAllowedForCompletion.isMethodAllowed(this.parentClass, method, this.onlyStaticMethods)) continue;
            methodNames.add(method.getName());
            methods.add(method);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, new ArrayList<String>(methodNames));
        if (completion != null) {
            for (Method method : methods) {
                MethodSuggestion suggestion = new MethodSuggestion(method.getName(), TypeFactory.resolveTypeName(method.getReturnType(), this.context), SuggestionGroup.METHOD);
                suggestion.setOffset(prefix);
                for (Parameter parameter : method.getParameters()) {
                    suggestion.addArgument(new MethodSuggestion.MethodArgument(parameter.getName(), new String[]{TypeFactory.resolveTypeName(parameter.getType(), this.context)}));
                }
                RPLMethodsCache.RPLMethodInfo rplMethodInfo = RPLMethodsCacheImpl.getRPLMethodInfo(method);
                if (rplMethodInfo != null) {
                    suggestion.setDescription(rplMethodInfo.description());
                    suggestion.setSamples(rplMethodInfo.samples());
                }
                completion.addSuggestion(suggestion);
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

