/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;
import java.util.Collection;

public class FunctionUnitCompleter
implements PrefixCompleter {
    protected Collection<String> functionUnits;

    public FunctionUnitCompleter(Collection<String> functionUnits) {
        this.functionUnits = functionUnits;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> units = new ArrayList<String>();
        for (String unitName : this.functionUnits) {
            if (prefix != null && !unitName.startsWith(prefix)) continue;
            units.add(unitName);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, units);
        if (completion != null) {
            for (String unit : units) {
                completion.addSuggestion(new TokenSuggestion(unit, SuggestionGroup.FUNCTION_UNIT).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

