/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.fields.FieldsMethodsAllowedForCompletion;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class FieldCompleter
implements PrefixCompleter {
    private Class<?> parentClass;
    private SemanticTypeLookupContext context;

    public FieldCompleter(Class<?> parentClass, SemanticTypeLookupContext context) {
        this.parentClass = parentClass;
        this.context = context;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        OrderedMap<String, Field> fields = new OrderedMap<String, Field>();
        for (Field field : this.parentClass.getDeclaredFields()) {
            if (prefix != null && !field.getName().startsWith(prefix) || !FieldsMethodsAllowedForCompletion.isFieldAllowed(field)) continue;
            fields.put(field.getName(), field);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, new ArrayList<String>(fields.keySet()));
        if (completion != null) {
            for (Field field : fields.values()) {
                completion.addSuggestion(new TypedParameterSuggestion(field.getName(), TypeFactory.resolveTypeName(field.getType(), this.context), SuggestionGroup.ELEMENT).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

