/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.types.FacetsSchemaObject;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public class FacetsTypeCompleter
implements PrefixCompleter {
    private FacetsSchemaObject facetsSchemaObject;

    public FacetsTypeCompleter(FacetsSchemaObject facetsSchemaObject) {
        this.facetsSchemaObject = facetsSchemaObject;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        Map<String, ColumnSchema> keysMap = this.facetsSchemaObject.getColumnsMap().entrySet().stream().filter(entry -> prefix == null || ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ColumnSchema)e.getValue()));
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, new ArrayList<String>(keysMap.keySet()));
        if (completion != null) {
            for (ColumnSchema column : keysMap.values()) {
                completion.addSuggestion(new TypedParameterSuggestion(NameManager.quoteNameIfNeeded(column.getObjectName().getNameString()), column.dataType.getTypeDefinition(), SuggestionGroup.ELEMENT).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

