/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.Trace;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.sdo.EventDatagramWithProperties;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.fields.SpecificFieldAccessorsManager;
import com.streamscape.sef.evtrigger.function.fields.event.EventSpecificFieldAccessors;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;

public class EventPropertiesCompleter
implements PrefixCompleter {
    private Class<?> eventClass;
    private ImmutableEventDatagram event;
    private SemanticTypeLookupContext context;
    private static final Method GET_PROPERTY_METHOD;
    private static final Method GET_PROPERTY_TYPE_METHOD;
    private static final Method GET_PROPERTY_NAMES_METHOD;

    public EventPropertiesCompleter(Class<?> eventClass, ImmutableEventDatagram event, SemanticTypeLookupContext context) {
        this.eventClass = eventClass;
        this.event = event;
        this.context = context;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<Object> propertyNames = new ArrayList<Object>();
        if (this.event != null && EventDatagramWithProperties.class.isAssignableFrom(this.eventClass)) {
            try {
                for (Object property : (Set)GET_PROPERTY_NAMES_METHOD.invoke((Object)this.event, new Object[0])) {
                    if (prefix != null && !((String)property).startsWith(prefix)) continue;
                    propertyNames.add(property);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OrderedMap<String, SpecificFieldAccessorsManager.SpecificFieldInfo> fields = new OrderedMap<String, SpecificFieldAccessorsManager.SpecificFieldInfo>();
        for (SpecificFieldAccessorsManager.SpecificFieldInfo info : EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().listSpecificFieldsFor(this.eventClass)) {
            if (prefix != null && !info.fieldName.startsWith(prefix)) continue;
            fields.put(info.fieldName, info);
        }
        ArrayList<String> allNames = new ArrayList<String>();
        allNames.addAll(propertyNames);
        allNames.addAll(fields.keySet());
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, allNames);
        if (completion != null) {
            if (this.event != null) {
                for (String string : propertyNames) {
                    String typeName = this.resolvePropertyTypeName(string);
                    if (typeName == null) {
                        typeName = "undefined";
                    }
                    completion.addSuggestion(new TypedParameterSuggestion(string, typeName, SuggestionGroup.EVENT_PROPERTY).setOffset(prefix));
                }
            }
            for (SpecificFieldAccessorsManager.SpecificFieldInfo specificFieldInfo : fields.values()) {
                completion.addSuggestion(new TypedParameterSuggestion(specificFieldInfo.fieldName, TypeFactory.resolveTypeName(specificFieldInfo.fieldType, this.context), SuggestionGroup.ELEMENT).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    public PropertyType resolvePropertyType(String propertyName) {
        try {
            return (PropertyType)((Object)GET_PROPERTY_TYPE_METHOD.invoke((Object)this.event, propertyName));
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to resolve property '" + propertyName + "' type. Cause: " + exception.getMessage());
            return null;
        }
    }

    public String resolvePropertyTypeName(String propertyName) {
        try {
            PropertyType propertyType = this.resolvePropertyType(propertyName);
            if (propertyType != null) {
                return TypeFactory.convertFromEventPropertyType(propertyType, GET_PROPERTY_METHOD.invoke((Object)this.event, propertyName)).getName();
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to resolve property '" + propertyName + "' type. Cause: " + exception.getMessage());
        }
        return null;
    }

    static {
        try {
            GET_PROPERTY_METHOD = EventDatagramWithProperties.class.getMethod("getEventObjectProperty", String.class);
            GET_PROPERTY_TYPE_METHOD = EventDatagramWithProperties.class.getMethod("getEventPropertyType", String.class);
            GET_PROPERTY_NAMES_METHOD = EventDatagramWithProperties.class.getMethod("getEventPropertyNames", new Class[0]);
            GET_PROPERTY_METHOD.setAccessible(true);
            GET_PROPERTY_TYPE_METHOD.setAccessible(true);
            GET_PROPERTY_NAMES_METHOD.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

